/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JSlider;

import net.dudesblog.rmc.core.JMPlayer;

public class PlaySliderAction implements MouseListener {

	private int calculateTime(int value) {
		Double newTime = (JMPlayer.getAllTime() * value) / 100;
		return newTime.intValue();
	}

	@Override
	public void mouseClicked(MouseEvent e) {

	}

	@Override
	public void mouseEntered(MouseEvent e) {

	}

	@Override
	public void mouseExited(MouseEvent e) {

	}

	@Override
	public void mousePressed(MouseEvent event) {
		if (JMPlayer.getInstance().isPlaying()) {
			JMPlayer.getInstance().togglePlay();
		}
	}

	@Override
	public void mouseReleased(MouseEvent event) {
		if (JMPlayer.getInstance().isPlaying()) {
			JSlider slider = (JSlider) event.getSource();
			JMPlayer.getInstance().setTimePosition(
					calculateTime(slider.getValue()));
		}
	}

}
