/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.rmc.core.JMPlayer;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;

public class PlayerNextAction implements MouseListener {

	@Override
	public void mouseClicked(MouseEvent event) {
		final ItemPanel nextFile = MediaTable.getInstance().getNextFileInList();
		MediaTable.getInstance().doFocus(nextFile.getLocation());
		if (nextFile != null && JMPlayer.getInstance().isPlaying()) {
			new Thread(new Runnable() {
				public void run() {
					try {
						File file;
						if (nextFile.isPathIsInvalid()) {
							file = nextFile.getAliasFile();
						} else {
							file = nextFile.getFile();
						}
						JMPlayer.getInstance().open(file);
					} catch (IOException e) {
						ErrorHandler.handleError(e, e.getCause().toString(),
								LanguageResource.getString("FILE_NOT_FOUND")
										+ nextFile, null);
					}
				}
			}).start();
		}

	}

	@Override
	public void mouseEntered(MouseEvent e) {

	}

	@Override
	public void mouseExited(MouseEvent e) {

	}

	@Override
	public void mousePressed(MouseEvent e) {

	}

	@Override
	public void mouseReleased(MouseEvent e) {

	}

}
