/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;

import javax.swing.ImageIcon;
import javax.swing.JButton;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.rmc.core.JMPlayer;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;
import net.dudesblog.rmc.gui.PlayerPanel;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class PlayerPlayAction implements MouseListener {

	private static boolean isPlaying = false;

	public static void togglePlay() {
		isPlaying = !isPlaying;
	}

	@Override
	public void mouseClicked(MouseEvent event) {
		final ItemPanel selectedItemPanel = MediaTable.getInstance()
				.getSelectedItemPanel();
		if (selectedItemPanel == null) {
			ErrorHandler
					.handleError(
							null,
							LanguageResource
									.getString("NO_SELECTED_FILE_TO_PLAY"),
							""
									+ LanguageResource
											.getString("PLEASE_SELECT_A_FILE_FROM_PLAY_LIST_TO_PLAY"),
							PlayerPanel.getInstance());
		} else if (!JMPlayer.getInstance().isPlaying()) {
			isPlaying = true;
			JButton button = (JButton) event.getSource();
			button.setIcon(new ImageIcon(ClazzPics.class
					.getResource("playerPause.png")));
			new Thread(new Runnable() {
				public void run() {
					try {
						File file;
						if (selectedItemPanel.isPathIsInvalid()) {
							file = selectedItemPanel.getAliasFile();
						} else {
							file = selectedItemPanel.getFile();
						}
						JMPlayer.getInstance().open(file);
					} catch (IOException e) {
						ErrorHandler.handleError(e, e.getCause().toString(),
								LanguageResource.getString("FILE_NOT_FOUND")
										+ selectedItemPanel.getFileNameLabel()
												.getText(), null);
					}
				}
			}).start();
		} else {
			isPlaying = !isPlaying;
			new Thread(new Runnable() {
				public void run() {
					JMPlayer.getInstance().togglePlay();
				}
			}).start();
			JButton button = (JButton) event.getSource();
			if (!isPlaying) {
				button.setIcon(new ImageIcon(ClazzPics.class
						.getResource("playerStart.png")));
			} else {
				button.setIcon(new ImageIcon(ClazzPics.class
						.getResource("playerPause.png")));
			}
		}
	}

	@Override
	public void mouseEntered(MouseEvent e) {

	}

	@Override
	public void mouseExited(MouseEvent e) {

	}

	@Override
	public void mousePressed(MouseEvent e) {

	}

	@Override
	public void mouseReleased(MouseEvent e) {

	}

}
