/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.JComponent;

import net.dudesblog.rmc.core.JMPlayer;
import net.dudesblog.rmc.gui.PlayerPanel;

public class PlayerVolumeAction extends TimerTask implements MouseListener {

	private static Component button;

	private static Timer timer;

	@Override
	public void mouseClicked(MouseEvent event) {

	}

	@Override
	public void mouseEntered(MouseEvent e) {

	}

	@Override
	public void mouseExited(MouseEvent e) {

	}

	@Override
	public void mousePressed(MouseEvent event) {
		button = (JComponent) event.getSource();
		timer = new Timer();
		timer.schedule(new PlayerVolumeAction(), 0, 250);
	}

	private boolean isNotZero(float volume) {
		return (volume - 10 >= 0);
	}

	private boolean isNotFull(float volume) {
		return (volume - 10 <= 110);
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		timer.cancel();
		timer = null;
	}

	@Override
	public void run() {
		float volume = JMPlayer.getInstance().getVolume();
		if (button.getName().equals("up") && isNotFull(volume)) {
			JMPlayer.getInstance().setVolume(volume + 10);
		} else if (button.getName().equals("down") && isNotZero(volume)) {
			JMPlayer.getInstance().setVolume(volume - 10);
		}
		PlayerPanel.updateVolumeImage(JMPlayer.getInstance().getVolume());
	}

}
