/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;

import net.dudesblog.guihelper.gui.reusables.LabledTextFeild;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;

public class SelectDirAction implements ActionListener {

	private File dir;

	private String mediaFolder;

	private JFileChooser mFileChooser;

	private LabledTextFeild labledTextFeild;

	public SelectDirAction(LabledTextFeild labledTextFeild, String mediaFolder) {
		this.labledTextFeild = labledTextFeild;
		this.mediaFolder = mediaFolder;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (mediaFolder != null) {
			mFileChooser = new JFileChooser(mediaFolder);
		} else {
			mFileChooser = new JFileChooser();
		}
		mFileChooser.setMultiSelectionEnabled(false);
		mFileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		mFileChooser.setDialogTitle(LanguageResource
				.getString("CHOOSE_DIR_TO_CONVERT"));
		int returnVal = mFileChooser.showOpenDialog(null);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			dir = mFileChooser.getSelectedFile();
			this.labledTextFeild.setValue(dir.getAbsolutePath());
		}
	}

	public File getDir() {
		return dir;
	}

	public void setDir(File dir) {
		this.dir = dir;
	}

}
