/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.rmc.core.converter.Mp3Converter;
import net.dudesblog.rmc.core.converter.WaveConverter;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;
import net.dudesblog.rmc.gui.UpperShortcutsPanel;

public class StartConvertingAction extends AbstractConvertingAction implements
		ActionListener {

	private UpperShortcutsPanel upperShortcutsPanel;

	private boolean stop;

	private static List<ItemPanel> itemsList;

	public StartConvertingAction(UpperShortcutsPanel upperShortcutsPanel) {
		this.upperShortcutsPanel = upperShortcutsPanel;
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		itemsList = new ArrayList<ItemPanel>(MediaTable.getInstance()
				.getAllItemsList());
		if (itemsList.size() > 0) {
			this.upperShortcutsPanel.disableButtons();
			StartConvertingAction action = new StartConvertingAction(
					this.upperShortcutsPanel);
			action.start();
		}
	}

	@Override
	public void run() {
		int threadsAllowed = calculateThreadsAllowed();
		int index = 0;
		while (!stop) {
			if (index <= itemsList.size()) {
				if (index < threadsAllowed) {
					ItemPanel itemPanel = getNextItem(index);
					if (itemPanel != null) {
						index++;
						if (PropertyManager.getProperty("rmc.user.outformat")
								.equals("mp3")) {
							mp3(itemPanel);
						} else {
							wav(itemPanel);
						}
						Thread thread = new Thread(itemPanel.getConverter());
						runningThreadsMap.put(itemPanel, thread);
						thread.start();
						startWatchMotion(itemPanel);
					}
				} else {
					if (index != runningThreadsMap.size()) {
						index = runningThreadsMap.size();
						continue;
					}
					try {
						sleep(1000L);
					} catch (InterruptedException e) {

					}
				}
			} else {
				if (runningThreadsMap.size() == 0) {
					stop = true;
					upperShortcutsPanel.enableButtons();
				} else {
					try {
						sleep(100L);
					} catch (InterruptedException e) {

					}
				}
			}
		}
	}

	private synchronized ItemPanel getNextItem(int index) {
		if (itemsList.size() > index) {
			return itemsList.get(index);
		}
		return null;
	}

	public static void removeFinshedItem(ItemPanel itemPanel) {
		if (itemsList.contains(itemPanel)) {
			itemsList.remove(itemPanel);
		}
	}

	private void wav(final ItemPanel itemPanel) {
		itemPanel.setConverter(new WaveConverter(itemPanel));
	}

	private void mp3(final ItemPanel itemPanel) {
		itemPanel.setConverter(new Mp3Converter(itemPanel));
	}

	private void startWatchMotion(final ItemPanel itemPanel) {
		new Thread(new Runnable() {
			@Override
			public void run() {
				itemPanel.start();
			}
		}).start();
	}

}
