/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.core.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;
import net.dudesblog.rmc.util.FileManager;
import net.dudesblog.rmc.util.constants.Constants;

public abstract class AbstractConverter implements Runnable {

	protected static final String OSName = System.getProperty("os.name")
			.toLowerCase();

	protected static final File mTempDir = Constants.FileConstants.RMC_TEMP_FOLDER;

	private static String MPLAYER;

	static {
		if (OSName.contains("windows")) {
			MPLAYER = "lib/mplayer/mencoder.exe ";
		} else {
			MPLAYER = "mplayer ";
		}
	}

	protected String mFilePath;

	protected String mFileName;

	protected ItemPanel mItem;

	protected String mOutputFile;

	protected String destination;

	protected boolean mp3;

	protected boolean isWavGenerated;

	protected AbstractConverter(ItemPanel pItem) {
		this.mItem = pItem;
		if (pItem.isPathIsInvalid()) {
			this.mFilePath = pItem.getAliasFile().getParent();
			this.mFileName = pItem.getAliasFile().getName();
		} else {
			this.mFilePath = pItem.getFile().getParent();
			this.mFileName = pItem.getFile().getName();
		}
		String outputFolder = PropertyManager.getProperty("rmc.user.outfolder");
		if (outputFolder != null && outputFolder.length() > 0) {
			if (new File(outputFolder).mkdirs()) {
				this.destination = outputFolder;
			} else {
				getDestinationPathFromTheFile(pItem);
				ErrorHandler
						.handleError(
								new IOException(),
								"Output Folder is not accessable!",
								"<html>Real Media converter Faild to access the Output folder<br>Using the source folder as output folder!</html>",
								MediaTable.getInstance());
			}
		} else {
			getDestinationPathFromTheFile(pItem);
		}
	}

	private void getDestinationPathFromTheFile(ItemPanel pItem) {
		if (pItem.isPathIsInvalid()) {
			this.destination = pItem.getFile().getParent();
		} else {
			this.destination = mFilePath;
		}
	}

	public void rmToWav(String pFileToConvert, String destination) {
		try {
			InputStreamConsumer.isMp3 = false;
			mp3 = false;
			mOutputFile = removeTypeExt(pFileToConvert);
			String aTask = "";
			aTask = MPLAYER + mFilePath + "/" + pFileToConvert
					+ " -ao pcm:file=" + mTempDir.getPath() + "/" + mOutputFile
					+ "_temp.wav";
			Process proc = Runtime.getRuntime().exec(aTask);
			new PrintWriter(proc.getOutputStream());
			new BufferedReader(new InputStreamReader(System.in));
			new Thread(new ProcessConsumer(proc.getInputStream(), mItem))
					.start();
			new Thread(new ErrorConsumer(proc.getErrorStream(), mItem)).start();
			if (proc.waitFor() == 0) {
				if (this instanceof WaveConverter) {
					try {
						FileManager.copyFile(new File(mTempDir.getPath() + "/"
								+ mOutputFile + "_temp.wav"), new File(
								destination
										+ "/"
										+ removeTypeExt(mItem.getFile()
												.getName()) + ".wav"));
					} catch (IOException e) {
						mItem.errorAction();
						ErrorHandler.handleError(e, "Error while copying file",
								e.getMessage(), MediaTable.getInstance());
						return;
					}
					mItem.successAction();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	protected String removeTypeExt(String pFileToConvert) {
		return pFileToConvert.replaceFirst(".rm", "").replaceFirst(".ra", "")
				.replaceFirst(".ram", "").replaceFirst(".RM", "").replaceFirst(
						".RA", "").replaceFirst(".RAM", "");
	}

	public boolean isMp3() {
		return mp3;
	}

	public void setMp3(boolean mp3) {
		this.mp3 = mp3;
	}

}
