/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.core.converter;

import java.io.InputStream;
import java.util.StringTokenizer;

import net.dudesblog.rmc.gui.ItemPanel;

public abstract class InputStreamConsumer implements Runnable {
	protected final InputStream mIn;

	protected ItemPanel mItem;

	protected int mProgress = 0;

	public static boolean isMp3;

	private StringTokenizer mStringTokenizer;

	protected InputStreamConsumer(InputStream in, ItemPanel pItem) {
		mIn = in;
		mItem = pItem;
	}

	protected int calculateMplayerProgrees(String pLine) {
		if (pLine != null && pLine.length() > 2
				&& pLine.substring(0, 2).equalsIgnoreCase("A:")) {
			String[] temp = pLine.split("of");
			Double value = 0d;
			try {
				value = Double.parseDouble(new StringTokenizer(temp[0]
						.substring(2), "(").nextToken().trim())
						/ Double.parseDouble(new StringTokenizer(temp[1], "(")
								.nextToken().trim());
				value = value * 100;
				mProgress = value.intValue();
			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
			return mProgress;
		}
		return mProgress;
	}

	protected int calculateLameProgress(String pLine) {
		if (pLine != null && pLine.length() > 16) {
			try {
				mStringTokenizer = new StringTokenizer(pLine, "%");
				String temp = mStringTokenizer.nextToken();
				mProgress = Integer.parseInt(temp.substring(temp.length() - 2)
						.trim());
			} catch (NumberFormatException e) {
			}
		}
		// System.out.println(mProgress);
		return mProgress;
	}

}
