/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.core.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;
import net.dudesblog.rmc.util.FileManager;

public class Mp3Converter extends AbstractConverter {

	public Mp3Converter(ItemPanel panel) {
		super(panel);
	}

	public void wavToMp3(String pFileToConvert, String destination) {
		if (!(pFileToConvert.endsWith(".wav") || pFileToConvert
				.endsWith(".WAV"))) {
			rmToWav(pFileToConvert, destination);
			try {
				InputStreamConsumer.isMp3 = true;
				mp3 = true;
				String aTask = getLameFunction() + " " + mTempDir.getPath()
						+ "/" + mOutputFile + "_temp.wav " + mTempDir.getPath()
						+ "/" + mOutputFile + ".mp3";
				Process proc = Runtime.getRuntime().exec(aTask);
				new PrintWriter(proc.getOutputStream());
				new BufferedReader(new InputStreamReader(System.in));
				new Thread(new ProcessConsumer(proc.getInputStream(), mItem))
						.start();
				new Thread(new ErrorConsumer(proc.getErrorStream(), mItem))
						.start();
				if (proc.waitFor() == 0) {
					try {
						FileManager.copyFile(new File(mTempDir.getPath()
								+ "/"
								+ mOutputFile.replaceFirst(".wav", "")
										.replaceFirst(".WAV", "") + ".mp3"),
								new File(destination
										+ "/"
										+ removeTypeExt(mItem.getFile()
												.getName().replaceFirst(".wav",
														"").replaceFirst(
														".WAV", "")) + ".mp3"));
						mItem.successAction();
					} catch (IOException e) {
						mItem.errorAction();
						ErrorHandler.handleError(e, "Error while copying file",
								e.getMessage(), MediaTable.getInstance());
						return;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			try {
				InputStreamConsumer.isMp3 = true;
				mp3 = true;
				String aTask = getLameFunction()
						+ mFilePath
						+ " "
						+ mTempDir.getPath()
						+ "/"
						+ mOutputFile.replaceFirst(".wav", ".mp3")
								.replaceFirst(".WAV", ".mp3");
				Process proc = Runtime.getRuntime().exec(aTask);
				new PrintWriter(proc.getOutputStream());
				new BufferedReader(new InputStreamReader(System.in));
				new Thread(new ProcessConsumer(proc.getInputStream(), mItem))
						.start();
				new Thread(new ErrorConsumer(proc.getErrorStream(), mItem))
						.start();
				if (proc.waitFor() == 0) {
					try {
						FileManager.copyFile(new File(mTempDir.getPath()
								+ "/"
								+ mOutputFile.replaceFirst(".wav", "")
										.replaceFirst(".WAV", "") + ".mp3"),
								new File(destination
										+ "/"
										+ mItem.getFile().getName()
												.replaceFirst(".wav", "")
												.replaceFirst(".WAV", "")
										+ ".mp3"));
						mItem.successAction();
					} catch (IOException e) {
						mItem.errorAction();
						ErrorHandler.handleError(e, "Error while copying file",
								e.getMessage(), MediaTable.getInstance());
						return;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private String getLameFunction() {
		String lameFunction = PropertyManager.getProperty("rmc.user.lame");
		if (OSName.contains("windows")) {
			lameFunction.replace("lame", "lib/lame/lame.exe");
		}
		return lameFunction;
	}

	public boolean isMp3() {
		return this.mp3;
	}

	public void setMp3(boolean mp3) {
		this.mp3 = mp3;
	}

	public void run() {
		wavToMp3(mFileName, destination);
	}

}
