/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.Language;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.actions.AbstractConvertingAction;
import net.dudesblog.rmc.actions.ItemSelectedAction;
import net.dudesblog.rmc.actions.StartConvertingAction;
import net.dudesblog.rmc.core.converter.AbstractConverter;
import net.dudesblog.rmc.meta.pics.ClazzPics;
import net.dudesblog.rmc.util.constants.Constants;

public class ItemPanel extends JPanel {

	private Motion motion;

	private static final String EMPTY_STRING = "     ";

	private static final String LANGUAGE = Language.getSCurrentLocaleLanguage().getLanguage();

	private static final long serialVersionUID = 1L;

	private JLabel watch;

	private JLabel watchIcon;

	private JLabel fileNameLabel;

	private File file;

	private int progress;

	private JPanel watchPanel;

	private AbstractConverter converter;

	private boolean pathIsInvalid;

	private File aliasFile;

	public ItemPanel(File file) {
		super(new BorderLayout());
		this.file = file;
		this.watch = new JLabel();
		this.watchIcon = new JLabel();
		this.fileNameLabel = new JLabel(file.getAbsolutePath());
		this.fileNameLabel.setName(Constants.GUIConstants.FIRST_CHILD);
		this.fileNameLabel.setToolTipText(file.getAbsolutePath());
		this.watch.setName(Constants.GUIConstants.SECOND_CHILD);
		this.watchIcon.setName(Constants.GUIConstants.SECOND_CHILD);
		this.setName(Constants.GUIConstants.PARENT);
		ItemSelectedAction selectedAction = new ItemSelectedAction();
		this.addMouseListener(selectedAction);
		this.watch.addMouseListener(selectedAction);
		this.watchIcon.addMouseListener(selectedAction);
		this.fileNameLabel.addMouseListener(selectedAction);
		watchPanel = new JPanel();
		watchPanel.addMouseListener(selectedAction);
		watchPanel.setName(Constants.GUIConstants.FIRST_CHILD);
		watchPanel.add(OreintationHelper.setJComponentOreintation(watchIcon));
		watchPanel.add(OreintationHelper.setJComponentOreintation(watch));
		this.add(OreintationHelper.setJComponentOreintation(watchPanel),
				BorderLayout.LINE_START);
		this.add(
				OreintationHelper.setJComponentOreintation(this.fileNameLabel),
				BorderLayout.CENTER);
		this.watchIcon.setIcon(new ImageIcon(ClazzPics.class
				.getResource("watch01.png")));
		this.setWatchText(watch, "   0%");
	}

	private void setWatchText(JLabel watch, String text) {
		if (LANGUAGE.equals("ar")
				|| LANGUAGE.equals("ps")) {
			watch.setText(EMPTY_STRING + text);
		} else {
			watch.setText(text + EMPTY_STRING);
		}
	}

	public void start() {
		motion = new Motion();
	}

	private class Motion extends TimerTask {
		int delay = 5000; // delay for 5 sec.
		int period = 1000; // repeat every sec.
		int i = 1;

		public Motion() {
			Timer timer = new Timer();
			timer.scheduleAtFixedRate(this, 0, 40);
		}

		public void run() {
			if (i < 10) {
				watchIcon.setIcon(new ImageIcon(ClazzPics.class
						.getResource("watch0" + i + ".png")));
			} else {
				watchIcon.setIcon(new ImageIcon(ClazzPics.class
						.getResource("watch" + i + ".png")));
			}
			if (i == 11) {
				i = 1;
			}
			i++;
			watchIcon.updateUI();
			watchPanel.updateUI();
		}

	}

	public JLabel getWatchLabel() {
		return watch;
	}

	public void setWatchLabel(JLabel watch) {
		this.watch = watch;
	}

	public JLabel getFileNameLabel() {
		return fileNameLabel;
	}

	public void setFileNameLabel(JLabel fileNameLabel) {
		this.fileNameLabel = fileNameLabel;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public void successAction() {
		if (motion != null) {
			motion.cancel();
			motion = null;
			watchIcon.setIcon(new ImageIcon(ClazzPics.class
					.getResource("ok.png")));
			AbstractConvertingAction.removeFinshedItem(this);
			StartConvertingAction.removeFinshedItem(this);
			if (PropertyManager.getProperty("rmc.user.delete").equals("true")) {
				file.delete();
			}
			setWatchText(watch, "100%");
		}
	}

	public void abortAction() {
		if (motion != null) {
			motion.cancel();
			motion = null;
			watchIcon.setIcon(new ImageIcon(ClazzPics.class
					.getResource("abort.png")));
			converter = null;
			setWatchText(watch, " ????");
		}
	}

	public void setProgress(int x) {
		int temp = progress;
		if (converter != null) {
			if (!converter.isMp3()) {
				progress = calculateProgress(x, "wav");
				if (progress - temp < 5) {
					if (progress < 10) {
						setWatchText(watch, " 0" + progress + "%");
					} else {
						setWatchText(watch, " " + progress + "%");
					}
				}
			} else {
				progress = calculateProgress(x, "mp3");
				if (progress - temp < 5 && progress - temp > 0) {
					setWatchText(watch, " " + progress + "%");
				}
			}
		}
	}

	private int calculateProgress(int x, String type) {
		if (type.equals("wav")) {
			if (PropertyManager.getProperty("rmc.user.outformat").equals("wav")) {
				return x;
			} else {
				return (x * 35) / 100;
			}
		} else {
			return ((x * 65) / 100) + 35;
		}
	}

	public void errorAction() {
		if (motion != null) {
			motion.cancel();
			motion = null;
			watchIcon.setIcon(new ImageIcon(ClazzPics.class
					.getResource("error.png")));
			converter = null;
			setWatchText(watch, " ????");
		}
	}

	public JPanel getWatchPanel() {
		return watchPanel;
	}

	public void setWatchPanel(JPanel watchPanel) {
		this.watchPanel = watchPanel;
	}

	public JLabel getWatchIcon() {
		return watchIcon;
	}

	public void setWatchIcon(JLabel watchIcon) {
		this.watchIcon = watchIcon;
	}

	public AbstractConverter getConverter() {
		return converter;
	}

	public void setConverter(AbstractConverter converter) {
		this.converter = converter;
	}

	public boolean isPathIsInvalid() {
		return pathIsInvalid;
	}

	public void setPathIsInvalid(boolean pathIsInvalid) {
		this.pathIsInvalid = pathIsInvalid;
	}

	public File getAliasFile() {
		return aliasFile;
	}

	public void setAliasFile(File aliasFile) {
		this.aliasFile = aliasFile;
	}
}
