/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.GridLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class LowerShortcutsPanel extends JPanel {

	private static final long serialVersionUID = 1L;

	private static LowerShortcutsPanel instance;

	private LowerShortcutsPanel() {
		super();
		init();
	}

	private void init() {
		this.setLayout(new GridLayout(1, 5));
		JButton allButton = new JButton(LanguageResource.getString("ALL"),
				new ImageIcon(ClazzPics.class.getResource("all.png")));
		allButton.setToolTipText(LanguageResource.getString("ALL"));
		JButton noneButton = new JButton(LanguageResource.getString("NONE"),
				new ImageIcon(ClazzPics.class.getResource("none.png")));
		noneButton.setToolTipText(LanguageResource.getString("NONE"));
		JButton startButton = new JButton(LanguageResource.getString("START"),
				new ImageIcon(ClazzPics.class.getResource("start.png")));
		startButton.setToolTipText(LanguageResource.getString("START"));
		JButton stopButton = new JButton(LanguageResource.getString("STOP"),
				new ImageIcon(ClazzPics.class.getResource("stop.png")));
		stopButton.setToolTipText(LanguageResource.getString("STOP"));
		JButton clearButton = new JButton(LanguageResource.getString("CLEAR"),
				new ImageIcon(ClazzPics.class.getResource("clear.png")));
		clearButton.setToolTipText(LanguageResource.getString("CLEAR"));
		this.add(OreintationHelper.setTextUnderIcon(allButton));
		this.add(OreintationHelper.setTextUnderIcon(noneButton));
		this.add(OreintationHelper.setTextUnderIcon(startButton));
		this.add(OreintationHelper.setTextUnderIcon(stopButton));
		this.add(OreintationHelper.setTextUnderIcon(clearButton));
	}

	public static LowerShortcutsPanel getInstance() {
		if (instance == null) {
			instance = new LowerShortcutsPanel();
		}
		return instance;
	}
}
