/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

import net.dudesblog.guihelper.gui.reusables.StatusBar;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class MainFrame extends JFrame {

	private static final long serialVersionUID = 1L;

	private static StatusBar sStatusBar = new StatusBar(new int[] { 10, 35, 20,
			0 });

	private static final int HIGHT = 500;

	private static final int WIDTH = 450;

	public MainFrame() {
		super();
		this.setResizable(false);
		this.setIconImage(new ImageIcon(ClazzPics.class
				.getResource("realplay.png")).getImage());
		this.setTitle(LanguageResource.getString("REAL_MEDIA_CONVERTER_PRO"));
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Toolkit aTheKit = this.getToolkit();
		Dimension aWndSize = aTheKit.getScreenSize();
		this.setBounds((int) ((aWndSize.getWidth() - WIDTH) / 2),
				(int) ((aWndSize.getHeight() - HIGHT) / 2), WIDTH, HIGHT);

		JPanel upperPanel = new JPanel(new BorderLayout());
		upperPanel.add(OreintationHelper
				.setJComponentOreintation(new MainMenuBar()),
				BorderLayout.NORTH);
		upperPanel.add(OreintationHelper
				.setJComponentOreintation(UpperShortcutsPanel.getInstance()),
				BorderLayout.CENTER);
		upperPanel.add(OreintationHelper.setJComponentOreintation(PlayerPanel
				.getInstance()), BorderLayout.SOUTH);
		sStatusBar.setContent(0, -1);
		sStatusBar.setContent(1, LanguageResource.getString("WARNING"));
		sStatusBar.setContent(2, "www.dudesblog.net");

		this.add(OreintationHelper.setJComponentOreintation(upperPanel),
				BorderLayout.NORTH);
		this.add(MediaTable.getInstance(), BorderLayout.CENTER);
		this.add(OreintationHelper.setJComponentOreintation(sStatusBar),
				BorderLayout.SOUTH);
	}

}