/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.actions.ClearAllAction;
import net.dudesblog.rmc.actions.HelpAction;
import net.dudesblog.rmc.actions.OpenDirAction;
import net.dudesblog.rmc.actions.OpenFileAction;
import net.dudesblog.rmc.actions.OpenSettingsFrameAction;
import net.dudesblog.rmc.actions.PlayerFiveBackwardAction;
import net.dudesblog.rmc.actions.PlayerFiveForwardAction;
import net.dudesblog.rmc.actions.PlayerNextAction;
import net.dudesblog.rmc.actions.PlayerPlayAction;
import net.dudesblog.rmc.actions.PlayerPreviousAction;
import net.dudesblog.rmc.actions.PlayerVolumeAction;
import net.dudesblog.rmc.gui.help.Project_AboutBoxPanel;

import sun.awt.VerticalBagLayout;

public class MainMenuBar extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;

	public MainMenuBar() {
		super();
		this.setLayout(new VerticalBagLayout());
		JMenuBar aMenuBar = new JMenuBar();
		aMenuBar.add(OreintationHelper
				.setJComponentOreintation(createFileMenu()));
		aMenuBar.add(OreintationHelper
				.setJComponentOreintation(createEditMenu()));
		aMenuBar.add(OreintationHelper
				.setJComponentOreintation(createPlayMenu()));
		aMenuBar.add(OreintationHelper
				.setJComponentOreintation(createConverterMenu()));
		aMenuBar.add(OreintationHelper
				.setJComponentOreintation(createHelpMenu()));
		this.add(OreintationHelper.setJComponentOreintation(aMenuBar));
	}

	private JMenu createFileMenu() {
		JMenu aFileMenu = new JMenu(LanguageResource.getString("FILE"));
		JMenuItem aAddFileMenuItem = new JMenuItem(LanguageResource
				.getString("ADD_FILES"));
		aAddFileMenuItem.addActionListener(new OpenFileAction(PropertyManager
				.getProperty("rmc.user.mediafolder")));
		JMenuItem aAddFolderMenuItem = new JMenuItem(LanguageResource
				.getString("ADD_FOLDER"));
		aAddFolderMenuItem.addActionListener(new OpenDirAction());
		JMenuItem aClearFilesMenuItem = new JMenuItem(LanguageResource
				.getString("CLEAR"));
		aClearFilesMenuItem.addActionListener(new ClearAllAction());
		JMenuItem aExitMenuItem = new JMenuItem(LanguageResource
				.getString("EXIT"));
		aExitMenuItem.setActionCommand("exit");
		aExitMenuItem.addActionListener(this);
		aFileMenu.add(OreintationHelper
				.setJComponentOreintation(aAddFileMenuItem));
		aFileMenu.add(OreintationHelper
				.setJComponentOreintation(aAddFolderMenuItem));
		aFileMenu.add(OreintationHelper
				.setJComponentOreintation(aClearFilesMenuItem));
		aFileMenu.add(new JSeparator());
		aFileMenu
				.add(OreintationHelper.setJComponentOreintation(aExitMenuItem));
		return aFileMenu;
	}

	private JMenu createPlayMenu() {
		JMenu playMenu = new JMenu(LanguageResource.getString("PLAYER"));
		JMenuItem playMenuItem = new JMenuItem(LanguageResource
				.getString("PLAY"));
		playMenuItem.addMouseListener(new PlayerPlayAction());
		JMenuItem stopMenuItem = new JMenuItem(LanguageResource
				.getString("STOP"));
		stopMenuItem.addActionListener(new OpenDirAction());
		JMenuItem seekBackwardMenuItem = new JMenuItem(LanguageResource
				.getString("SEEK_BACKWARD"));
		seekBackwardMenuItem.addMouseListener(new PlayerFiveBackwardAction());
		JMenuItem seekForwardMenuItem = new JMenuItem(LanguageResource
				.getString("SEEK_FOREWARD"));
		seekForwardMenuItem.addMouseListener(new PlayerFiveForwardAction());
		JMenuItem nextMenuItem = new JMenuItem(LanguageResource
				.getString("NEXT"));
		nextMenuItem.addMouseListener(new PlayerNextAction());
		JMenuItem previousMenuItem = new JMenuItem(LanguageResource
				.getString("PREVIOUS"));
		previousMenuItem.addMouseListener(new PlayerPreviousAction());
		JMenuItem upMenuItem = new JMenuItem(LanguageResource
				.getString("INCREASE_VOLUME"));
		upMenuItem.setName("up");
		upMenuItem.addMouseListener(new PlayerVolumeAction());
		JMenuItem downMenuItem = new JMenuItem(LanguageResource
				.getString("DECREASE_VOLUME"));
		downMenuItem.setName("down");
		downMenuItem.addMouseListener(new PlayerVolumeAction());
		playMenu.add(OreintationHelper.setJComponentOreintation(playMenuItem));
		playMenu.add(OreintationHelper.setJComponentOreintation(stopMenuItem));
		playMenu.add(OreintationHelper
				.setJComponentOreintation(seekForwardMenuItem));
		playMenu.add(OreintationHelper
				.setJComponentOreintation(seekBackwardMenuItem));
		playMenu.add(OreintationHelper.setJComponentOreintation(nextMenuItem));
		playMenu.add(OreintationHelper
				.setJComponentOreintation(previousMenuItem));
		playMenu.add(new JSeparator());
		playMenu.add(OreintationHelper.setJComponentOreintation(upMenuItem));
		playMenu.add(OreintationHelper.setJComponentOreintation(downMenuItem));
		return playMenu;
	}

	private JMenu createHelpMenu() {
		JMenu aHelpMenu = new JMenu(LanguageResource.getString("HELP"));
		JMenuItem aAboutMenuItem = new JMenuItem(LanguageResource
				.getString("ABOUT"));
		aAboutMenuItem.setActionCommand("about");
		aAboutMenuItem.addActionListener(this);
		JMenuItem aHelpMenuItem = new JMenuItem(LanguageResource
				.getString("HELP"));
		aHelpMenuItem.addActionListener(new HelpAction());
		aHelpMenu.add(OreintationHelper
				.setJComponentOreintation(aAboutMenuItem));
		aHelpMenu.add(new JSeparator());
		aHelpMenu
				.add(OreintationHelper.setJComponentOreintation(aHelpMenuItem));
		return aHelpMenu;
	}

	private JMenu createConverterMenu() {
		JMenu converterMenu = new JMenu(LanguageResource.getString("CONVERTER"));
		JMenuItem convertItem = new JMenuItem(LanguageResource
				.getString("START"));
		// convertItem.addActionListener(this);
		JMenuItem stopMenuItem = new JMenuItem(LanguageResource
				.getString("CANCEL_CONVERSION"));
		// stopMenuItem.addActionListener(this);
		converterMenu.add(OreintationHelper
				.setJComponentOreintation(convertItem));
		converterMenu.add(OreintationHelper
				.setJComponentOreintation(stopMenuItem));
		return converterMenu;
	}

	private JMenu createEditMenu() {
		JMenu editMenu = new JMenu(LanguageResource.getString("EDIT"));
		JMenuItem editMenuItem = new JMenuItem(LanguageResource
				.getString("SETTINGS"));
		editMenuItem.addActionListener(new OpenSettingsFrameAction());
		editMenu.add(OreintationHelper.setJComponentOreintation(editMenuItem));
		return editMenu;
	}

	public void actionPerformed(ActionEvent pEvent) {
		if (pEvent.getActionCommand() == "exit") {
			System.exit(0);
		} else if (pEvent.getActionCommand() == "about") {
			// TODO : make a good about menu and help.
			JOptionPane
					.showMessageDialog(MediaTable.getInstance() , new Project_AboutBoxPanel(),
							"About",
							JOptionPane.PLAIN_MESSAGE);
		}
	}

}
