/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.util.FileManager;
import sun.awt.VerticalBagLayout;

public class MediaTable extends JScrollPane {

	private static final long serialVersionUID = 1L;

	private static MediaTable instance;

	private static List<ItemPanel> allItemsList;

	private static JPanel mainPanel = new JPanel(new VerticalBagLayout());

	private static ItemPanel selectedItemPanel;

	private static final Color FOREGROUND_COLOR = Color.WHITE;

	private static final Color BACKGROUND_COLOR = Color.DARK_GRAY;

	private MediaTable() {
		super(OreintationHelper.setJComponentOreintation(mainPanel));
		setLayout(new ScrollPaneLayout());
		init();
	}

	public ItemPanel getNextFileInList() {
		if (allItemsList.size() > 0) {
			int currentIndex = allItemsList.indexOf(selectedItemPanel);
			if (allItemsList.size() > currentIndex + 1) {
				ItemPanel itemPanel = allItemsList.get(currentIndex + 1);
				paintNewItem(itemPanel);
				setSelectedItemPanel(itemPanel);
				return itemPanel;
			}
			ItemPanel itemPanel = allItemsList.get(0);
			paintNewItem(itemPanel);
			setSelectedItemPanel(itemPanel);
			return itemPanel;
		}
		return null;
	}

	public static void paintNewItem(ItemPanel itemPanel) {
		restColors();
		itemPanel.setBackground(BACKGROUND_COLOR);
		itemPanel.setForeground(FOREGROUND_COLOR);
		itemPanel.getWatchLabel().setForeground(FOREGROUND_COLOR);
		itemPanel.getWatchLabel().setBackground(BACKGROUND_COLOR);
		itemPanel.getWatchIcon().setForeground(FOREGROUND_COLOR);
		itemPanel.getWatchIcon().setBackground(BACKGROUND_COLOR);
		itemPanel.getFileNameLabel().setForeground(FOREGROUND_COLOR);
		itemPanel.getFileNameLabel().setBackground(BACKGROUND_COLOR);
		itemPanel.getWatchPanel().setForeground(FOREGROUND_COLOR);
		itemPanel.getWatchPanel().setBackground(BACKGROUND_COLOR);
		MediaTable.getInstance().updateUI();
	}

	public ItemPanel getPreviousFileInList() {
		if (allItemsList.size() > 0) {
			int currentIndex = allItemsList.indexOf(selectedItemPanel);
			if (currentIndex > 0) {
				ItemPanel itemPanel = allItemsList.get(currentIndex - 1);
				paintNewItem(itemPanel);
				setSelectedItemPanel(itemPanel);
				return itemPanel;
			}
			ItemPanel itemPanel = allItemsList.get(allItemsList.size() - 1);
			paintNewItem(itemPanel);
			setSelectedItemPanel(itemPanel);
			return itemPanel;
		}
		return null;
	}

	private void init() {
		this.setBorder(new TitledBorder(LanguageResource.getString("PLYLIST")));
		this
				.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		this
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		allItemsList = new ArrayList<ItemPanel>();
		JPanel headerPanel = new JPanel(new BorderLayout());
		headerPanel.setBackground(Color.DARK_GRAY);
		headerPanel.add(OreintationHelper
				.setJComponentOreintation(setFontColor(new JLabel(
						LanguageResource.getString("PROCESS")))),
				BorderLayout.LINE_START);
		headerPanel.add(OreintationHelper
				.setJComponentOreintation(setFontColor(new JLabel(
						LanguageResource.getString("FILE_NAME")))),
				BorderLayout.CENTER);
		this.setColumnHeaderView(OreintationHelper
				.setJComponentOreintation(headerPanel));
	}

	private JLabel setFontColor(JLabel label) {
		label.setForeground(Color.WHITE);
		label.setHorizontalAlignment(SwingConstants.CENTER);
		return label;
	}

	public static MediaTable getInstance() {
		if (instance == null) {
			instance = new MediaTable();
		}
		return instance;
	}

	public static void addFiles(ItemPanel[] items) {
		clearAll();
		List<String> invalidFiles = new ArrayList<String>();
		for (ItemPanel itemPanel : items) {
			try {
				if (FileManager.isValidFile(itemPanel.getFile())) {
					if (filePathIsValidForUnix(itemPanel.getFileNameLabel()
							.getText())) {
						mainPanel.add(OreintationHelper
								.setJComponentOreintation(itemPanel));
						allItemsList.add(itemPanel);
					} else {
						try {
							itemPanel.setPathIsInvalid(true);
							itemPanel.setAliasFile(FileManager
									.addToTmpFolder(itemPanel.getFile()
											.getName().replaceAll(" ", "_")));
							FileManager.copyFile(itemPanel.getFile(), itemPanel
									.getAliasFile());
							mainPanel.add(OreintationHelper
									.setJComponentOreintation(itemPanel));
							allItemsList.add(itemPanel);
						} catch (IOException e) {
							invalidFiles.add(itemPanel.getFileNameLabel()
									.getText());
							ErrorHandler.handleError(e,
									"Error while copying file", e.getMessage(),
									MediaTable.getInstance());
						}
					}
				}
			} catch (IOException e) {
				invalidFiles.add(itemPanel.getFileNameLabel().getText());
				ErrorHandler.handleError(e, "Error while validating file", e
						.getMessage(), MediaTable.getInstance());
			}
		}
		restColors();
		if (invalidFiles.size() > 0) {
			getInstance().showInfoMessage(invalidFiles);
		}
		if (allItemsList.size() > 0) {
			ItemPanel itemPanel = allItemsList.get(0);
			paintNewItem(itemPanel);
			getInstance().setSelectedItemPanel(itemPanel);
		}
	}

	private void showInfoMessage(List<String> invalidFiles) {
		// TODO Localize info message
		String message = "<html>The following file(s) could not be open<br>problems in file(s) permissions and/or file(s) type were found<br>please fix the problem(s) and try again!<br>";
		for (String string : invalidFiles) {
			message += (string + "<br>");
		}
		JOptionPane.showMessageDialog(this, message + "</html>");
	}

	private static boolean filePathIsValidForUnix(String filePath) {
		if (filePath.contains(" ")) {
			return false;
		}
		return true;
	}

	public static void restColors() {
		for (int i = 0; i < mainPanel.getComponents().length; i++) {
			ItemPanel itemPanel = (ItemPanel) mainPanel.getComponent(i);
			if (i % 2 == 0) {
				itemPanel.setBackground(Color.WHITE);
				itemPanel.getWatchPanel().setBackground(Color.WHITE);
			} else {
				itemPanel.setBackground(Color.LIGHT_GRAY);
				itemPanel.getWatchPanel().setBackground(Color.LIGHT_GRAY);
			}
			itemPanel.getWatchLabel().setForeground(Color.BLACK);
			itemPanel.getFileNameLabel().setForeground(Color.BLACK);
		}
		mainPanel.updateUI();
	}

	public static void clearAll() {
		mainPanel.removeAll();
		mainPanel.updateUI();
		allItemsList.clear();
		getInstance().setSelectedItemPanel(null);
	}

	public void setSelectedItemPanel(ItemPanel itemPanel) {
		selectedItemPanel = itemPanel;
	}

	public ItemPanel getSelectedItemPanel() {
		return selectedItemPanel;
	}

	public List<ItemPanel> getAllItemsList() {
		return allItemsList;
	}

	public void setAllItemsList(List<ItemPanel> allItemsList) {
		MediaTable.allItemsList = allItemsList;
	}

	public void doFocus(Point point) {
		JScrollBar verticalScrollBar = this.getVerticalScrollBar();
		JScrollBar horizontalScrollBar = this.getHorizontalScrollBar();
		verticalScrollBar.setValue(new Double(point.getY()).intValue());
		horizontalScrollBar.setValue(new Double(point.getX()).intValue());
	}
}
