/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.actions.PlaySliderAction;
import net.dudesblog.rmc.actions.PlayerFiveBackwardAction;
import net.dudesblog.rmc.actions.PlayerFiveForwardAction;
import net.dudesblog.rmc.actions.PlayerNextAction;
import net.dudesblog.rmc.actions.PlayerPlayAction;
import net.dudesblog.rmc.actions.PlayerPreviousAction;
import net.dudesblog.rmc.actions.PlayerStopAction;
import net.dudesblog.rmc.actions.PlayerVolumeAction;
import net.dudesblog.rmc.core.JMPlayer;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class PlayerPanel extends JPanel {

	private static JLabel volumeImageLabel = new JLabel(new ImageIcon(
			ClazzPics.class.getResource("audio-volume-low.png")));

	private static JLabel fromLabel = new JLabel("00:00:00   ");

	private static JLabel currentLabel = new JLabel("   00:00:00");

	private static final long serialVersionUID = 1L;

	private static PlayerPanel instance;

	private static JSlider timeSlider;

	private static JButton startButton;

	private static JPanel volumePanel;

	private PlayerPanel() {
		super(new BorderLayout());
		init();
	}

	public static void setPauseIcon() {
		startButton.setIcon(new ImageIcon(ClazzPics.class
				.getResource("playerPause.png")));
	}

	public static void setPlayIcon() {
		startButton.setIcon(new ImageIcon(ClazzPics.class
				.getResource("playerStart.png")));
	}

	public static void updateSlider(String current, String from, int value) {
		currentLabel.setText("   " + fitWidth(current));
		fromLabel.setText(fitWidth(from) + "   ");
		timeSlider.setValue(value);
	}

	private static String fitWidth(String string) {
		if (string.contains(".")) {
			string = string.substring(0, string.indexOf("."));
		}
		if (string.length() == 2) {
			string = "00:00:" + string;
		} else if (string.length() == 5) {
			string = "00:" + string;
		}
		return string;
	}

	public static void updateVolumeImage(float volume) {
		volumePanel.remove(volumeImageLabel);
		int volumePercentage = new Float((volume / 130) * 100).intValue();
		if (volumePercentage == 0) {
			volumeImageLabel = new JLabel(new ImageIcon(ClazzPics.class
					.getResource("audio-volume-muted.png")));
		} else if (volumePercentage > 0 && volumePercentage <= 35) {
			volumeImageLabel = new JLabel(new ImageIcon(ClazzPics.class
					.getResource("audio-volume-low.png")));
		} else if (volumePercentage > 35 && volumePercentage <= 65) {
			volumeImageLabel = new JLabel(new ImageIcon(ClazzPics.class
					.getResource("audio-volume-medium.png")));
		} else if (volumePercentage > 65 && volumePercentage <= 100) {
			volumeImageLabel = new JLabel(new ImageIcon(ClazzPics.class
					.getResource("audio-volume-high.png")));
		}
		volumeImageLabel.setToolTipText(volumePercentage + "%");
		volumeImageLabel.updateUI();
		volumePanel.add(volumeImageLabel, BorderLayout.CENTER);
		volumePanel.updateUI();
		getInstance().updateUI();
	}

	private void init() {
		volumeImageLabel.setToolTipText(JMPlayer.getInstance().getVolume()
				+ "%");
		this.setBorder(new TitledBorder(LanguageResource
				.getString("REAL_MEDIA_PLAYER")));
		JPanel sliderPanel = new JPanel(new BorderLayout());
		timeSlider = new JSlider(JSlider.HORIZONTAL, 0, 100, 0);
		timeSlider.addMouseListener(new PlaySliderAction());
		timeSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		sliderPanel.add(currentLabel, BorderLayout.BEFORE_LINE_BEGINS);
		sliderPanel.add(timeSlider, BorderLayout.CENTER);
		sliderPanel.add(fromLabel, BorderLayout.AFTER_LINE_ENDS);
		timeSlider.setBorder(new EmptyBorder(4, 4, 4, 4));
		JPanel buttonsPanel = new JPanel(new GridBagLayout());
		JButton previousButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("playerPrevious.png")));
		buttonsPanel.add(previousButton);
		previousButton.addMouseListener(new PlayerPreviousAction());
		previousButton.setToolTipText(LanguageResource.getString("PREVIOUS"));
		JButton seekBackwardButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("playerSeekBackward.png")));
		seekBackwardButton.addMouseListener(new PlayerFiveBackwardAction());
		buttonsPanel.add(seekBackwardButton);
		seekBackwardButton.setToolTipText(LanguageResource
				.getString("SEEK_BACKWARD"));
		startButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("playerStart.png")));
		startButton.addMouseListener(new PlayerPlayAction());
		buttonsPanel.add(startButton);
		startButton.setToolTipText(LanguageResource.getString("PLAY"));
		JButton stopButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("playerStop.png")));
		stopButton.addMouseListener(new PlayerStopAction());
		buttonsPanel.add(stopButton);
		stopButton.setToolTipText(LanguageResource.getString("STOP"));
		JButton seekForwardButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("playerSeekForward.png")));
		buttonsPanel.add(seekForwardButton);
		seekForwardButton.addMouseListener(new PlayerFiveForwardAction());
		seekForwardButton.setToolTipText(LanguageResource
				.getString("SEEK_FOREWARD"));
		JButton nextButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("playerNext.png")));
		buttonsPanel.add(nextButton);
		nextButton.addMouseListener(new PlayerNextAction());
		nextButton.setToolTipText(LanguageResource.getString("NEXT"));
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(OreintationHelper.setJComponentOreintation(sliderPanel),
				BorderLayout.NORTH);
		panel.add(buttonsPanel, BorderLayout.CENTER);
		this.add(OreintationHelper.setJComponentOreintation(panel),
				BorderLayout.CENTER);
		volumePanel = new JPanel(new BorderLayout());

		JButton increasVolumeButton = new JButton("+");
		increasVolumeButton.setToolTipText(LanguageResource
				.getString("INCREASE_VOLUME"));
		increasVolumeButton.setName("up");
		increasVolumeButton.addMouseListener(new PlayerVolumeAction());
		volumePanel.add(increasVolumeButton, BorderLayout.NORTH);
		volumePanel.add(volumeImageLabel, BorderLayout.CENTER);
		JButton decreasVolumeButton = new JButton("-");
		decreasVolumeButton.setName("down");
		decreasVolumeButton.addMouseListener(new PlayerVolumeAction());
		decreasVolumeButton.setToolTipText(LanguageResource
				.getString("DECREASE_VOLUME"));
		volumePanel.add(decreasVolumeButton, BorderLayout.SOUTH);
		this.add(OreintationHelper.setJComponentOreintation(volumePanel),
				BorderLayout.LINE_END);
	}

	public static JComponent getInstance() {
		if (instance == null) {
			instance = new PlayerPanel();
		}
		return instance;
	}

}
