/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui;

import java.awt.Component;
import java.awt.GridLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.actions.ClearAllAction;
import net.dudesblog.rmc.actions.OpenDirAction;
import net.dudesblog.rmc.actions.OpenFileAction;
import net.dudesblog.rmc.actions.OpenSettingsFrameAction;
import net.dudesblog.rmc.actions.StartConvertingAction;
import net.dudesblog.rmc.actions.StopConvertingAction;
import net.dudesblog.rmc.actions.HelpAction;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class UpperShortcutsPanel extends JPanel {

	private static final long serialVersionUID = 1L;

	private static UpperShortcutsPanel instance;

	private UpperShortcutsPanel() {
		super();
		init();
	}

	private void init() {
		this.setLayout(new GridLayout(1, 5));
		JButton addFileButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("file.png")));
		addFileButton.setToolTipText(LanguageResource.getString("ADD_FILES"));
		addFileButton.setName(LanguageResource.getString("ADD_FILES"));
		addFileButton.addActionListener(new OpenFileAction(PropertyManager
				.getProperty("rmc.user.mediafolder")));
		JButton addDirButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("folder.png")));
		addDirButton.setToolTipText(LanguageResource.getString("ADD_FOLDER"));
		addDirButton.setName(LanguageResource.getString("ADD_FOLDER"));
		addDirButton.addActionListener(new OpenDirAction());
		JButton settingsButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("settings.png")));
		settingsButton.setToolTipText(LanguageResource.getString("SETTINGS"));
		settingsButton.setName(LanguageResource.getString("SETTINGS"));
		settingsButton.addActionListener(new OpenSettingsFrameAction());
		JButton helpButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("help.png")));
		helpButton.setToolTipText(LanguageResource.getString("HELP"));
		helpButton.setName(LanguageResource.getString("HELP"));
		helpButton.addActionListener(new HelpAction());
		JButton startButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("convert.png")));
		startButton.setToolTipText(LanguageResource.getString("START"));
		startButton.setName(LanguageResource.getString("START"));
		startButton.addActionListener(new StartConvertingAction(this));
		JButton stopButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("cancel.png")));
		stopButton.setToolTipText(LanguageResource
				.getString("CANCEL_CONVERSION"));
		stopButton.setName(LanguageResource.getString("CANCEL_CONVERSION"));
		stopButton.addActionListener(new StopConvertingAction(this));
		JButton clearButton = new JButton(new ImageIcon(ClazzPics.class
				.getResource("clear.png")));
		clearButton.setToolTipText(LanguageResource.getString("CLEAR"));
		clearButton.setName(LanguageResource.getString("CLEAR"));
		clearButton.addActionListener(new ClearAllAction());
		this.add(OreintationHelper.setTextUnderIcon(addFileButton));
		this.add(OreintationHelper.setTextUnderIcon(addDirButton));
		this.add(OreintationHelper.setTextUnderIcon(startButton));
		this.add(OreintationHelper.setTextUnderIcon(stopButton));
		this.add(OreintationHelper.setTextUnderIcon(settingsButton));
		this.add(OreintationHelper.setTextUnderIcon(clearButton));
		this.add(OreintationHelper.setTextUnderIcon(helpButton));
	}

	public static UpperShortcutsPanel getInstance() {
		if (instance == null) {
			instance = new UpperShortcutsPanel();
		}
		return instance;
	}

	public void disableButtons() {
		for (Component component : this.getComponents()) {
			if (component instanceof JButton
					&& !component.getName().equals(
							LanguageResource.getString("CANCEL_CONVERSION"))) {
				component.setEnabled(false);
			}
			this.updateUI();
		}
	}

	public void enableButtons() {
		for (Component component : this.getComponents()) {
			if (component instanceof JButton
					&& !component.getName().equals(
							LanguageResource.getString("CANCEL_CONVERSION"))) {
				component.setEnabled(true);
			}
			this.updateUI();
		}
	}
}
