/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui.help;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

import net.dudesblog.rmc.meta.pics.ClazzPics;

public class Project_AboutBoxPanel extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;
	private Border border = BorderFactory.createEtchedBorder();
	private JButton mLicenceButton;
	private JButton mCreditsButton;

	public Project_AboutBoxPanel() {
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void actionPerformed(ActionEvent evt) {
		if (evt.getSource() == this.mLicenceButton) {
			JOptionPane.showMessageDialog(this, new Project_LicenceBoxPanel(),
					"Licence", JOptionPane.PLAIN_MESSAGE);
		} else if (evt.getSource() == this.mCreditsButton) {
			JOptionPane.showMessageDialog(this, new Project_CreditsBoxPanel(),
					"Credits", JOptionPane.PLAIN_MESSAGE);
		}
	}

	private void jbInit() throws Exception {
		this.setLayout(new BorderLayout());
		this.setBorder(this.border);
		JLabel noteLabel = new JLabel(new ImageIcon(ClazzPics.class.getResource("rmc_128.png")));
		JLabel aboutLabel = new JLabel("<html><div align=\"center\"><h1>REAL MEDIA CONVERTER 3.0</h1><p> Multi threaded converter for RealMedia formats</p><p>Using Lame and MPlayer </p><p>©  2008 - 2009 Fadi A-Katout.<br></p></div></html>");
		
		this.mLicenceButton = new JButton("Licence");
		this.mLicenceButton.addActionListener(this);
		this.mLicenceButton.setToolTipText("Licence");
		this.mLicenceButton.setActionCommand("Licence");
		
		this.mCreditsButton = new JButton("Credits");
		this.mCreditsButton.addActionListener(this);
		this.mCreditsButton.setToolTipText("Credits");
		this.mCreditsButton.setActionCommand("Credits");
		
		JPanel panel = new JPanel(new GridLayout());
		panel.add(this.mCreditsButton, BorderLayout.WEST);
		panel.add(this.mLicenceButton, BorderLayout.EAST);
		
		this.add(noteLabel, BorderLayout.NORTH);
		this.add(aboutLabel, BorderLayout.CENTER);
		this.add(panel, BorderLayout.SOUTH);
	}

}
