/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui.settings;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

import net.dudesblog.guihelper.gui.look.MyUIManager;
import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class AppearancePanel extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;

	private static JRadioButton javaRadioButton = new JRadioButton(
			LanguageResource.getString("JAVA"));

	private static JRadioButton osRadioButton = new JRadioButton(
			LanguageResource.getString("OPERATING_SYSTEM"));

	private static JRadioButton rmcRadioButton = new JRadioButton(
			LanguageResource.getString("REAL_MEDIA_CONVERTER"));

	private static JComboBox subThemeComboBox = new JComboBox(new Object[] {
			LanguageResource.getString("STANDARD"),
			LanguageResource.getString("BLUE"),
			LanguageResource.getString("BLACK"),
			LanguageResource.getString("GRAY") });

	private static JPanel centerPanel = new JPanel(new BorderLayout());

	private static JPanel picturePanel = new JPanel(new BorderLayout());

	private static JButton applyButton = new JButton(LanguageResource
			.getString("APPLAY"));

	private static JPanel themePanel = new JPanel();

	private String lfSelection;

	public AppearancePanel() {
		this.setLayout(new BorderLayout());
		initAppearancePanel();
	}

	private void initAppearancePanel() {
		this.setBorder(new TitledBorder(LanguageResource
				.getString("APPEARANCE")));
		JPanel lfPanel = new JPanel();
		lfPanel
				.add(OreintationHelper
						.setJComponentOreintation(javaRadioButton));
		lfPanel.add(OreintationHelper.setJComponentOreintation(osRadioButton));
		lfPanel.add(OreintationHelper.setJComponentOreintation(rmcRadioButton));
		javaRadioButton.addActionListener(this);
		osRadioButton.addActionListener(this);
		rmcRadioButton.addActionListener(this);

		themePanel.add(OreintationHelper
				.setJComponentOreintation(subThemeComboBox));
		subThemeComboBox.addActionListener(this);

		centerPanel.add(picturePanel, BorderLayout.CENTER);

		JLabel noteLabel = new JLabel(new ImageIcon(ClazzPics.class
				.getResource("note.png")));
		noteLabel
				.setText(LanguageResource
						.getString("PLEASE_NOTE_THAT_YOU_NEED_TO_RESTART_THE_APPLICATION_FOR_CHANGES_TOTAKE_EFFECT"));

		applyButton.addActionListener(this);

		this.add(lfPanel, BorderLayout.NORTH);
		this.add(centerPanel, BorderLayout.CENTER);
		this.add(noteLabel, BorderLayout.SOUTH);
		loadUserSettings(PropertyManager.getProperty("rmc.user.lf"));
	}

	private void loadUserSettings(String themeFunction) {
		if (themeFunction.equals("java")) {
			lfSelection = "java";
			javaRadioButton.setSelected(true);
			setJavaPic();
		} else if (themeFunction.equals("os")) {
			lfSelection = "os";
			osRadioButton.setSelected(true);
			setOsPic();
		} else if (themeFunction.equals("rmc")) {
			lfSelection = "rmc";
			rmcRadioButton.setSelected(true);
			String subTheme = PropertyManager.getProperty("rmc.user.lf.sub");
			;
			if (subTheme.equals("Blue")) {
				subThemeComboBox.setSelectedIndex(1);
			} else if (subTheme.equals("Black")) {
				subThemeComboBox.setSelectedIndex(2);
			} else if (subTheme.equals("Gray")) {
				subThemeComboBox.setSelectedIndex(3);
			} else {
				subThemeComboBox.setSelectedIndex(0);
			}
			centerPanel.add(themePanel, BorderLayout.PAGE_START);
			setRmcPic();
		}
	}

	public String getThemeOption() {
		if (javaRadioButton.isSelected()) {
			return "java";
		} else if (osRadioButton.isSelected()) {
			return "os";
		} else {
			return "rmc";
		}
	}

	public String getSubThemeOption() {
		int index = subThemeComboBox.getSelectedIndex();
		String subTheme;
		switch (index) {
		case 0:
			subTheme = "default";
			break;
		case 1:
			subTheme = "Blue";
			break;
		case 2:
			subTheme = "Black";
			break;
		case 3:
			subTheme = "Gray";
			break;
		default:
			subTheme = "default";
			break;
		}
		return subTheme;
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		if (event.getSource() == javaRadioButton) {
			centerPanel.remove(themePanel);
			lfSelection = "java";
			javaRadioButton.setSelected(true);
			osRadioButton.setSelected(false);
			rmcRadioButton.setSelected(false);
			setJavaPic();
		} else if (event.getSource() == osRadioButton) {
			centerPanel.remove(themePanel);
			javaRadioButton.setSelected(false);
			osRadioButton.setSelected(true);
			rmcRadioButton.setSelected(false);
			setOsPic();
		} else if (event.getSource() == rmcRadioButton) {
			lfSelection = "rmc";
			centerPanel.add(themePanel, BorderLayout.PAGE_START);
			javaRadioButton.setSelected(false);
			osRadioButton.setSelected(false);
			rmcRadioButton.setSelected(true);
			setRmcPic();
		} else if (event.getSource() == applyButton) {
			PropertyManager.setProperty("rmc.user.lf", lfSelection);
			int index = subThemeComboBox.getSelectedIndex();
			String subTheme;
			switch (index) {
			case 0:
				subTheme = "default";
				break;
			case 1:
				subTheme = "Blue";
				break;
			case 2:
				subTheme = "Black";
				break;
			case 3:
				subTheme = "Gray";
				break;
			default:
				subTheme = "default";
				break;
			}
			PropertyManager.setProperty("rmc.user.lf.sub", subTheme);
			try {
				MyUIManager.setLF(PropertyManager.getProperty("rmc.user.lf"));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		picturePanel.updateUI();
		updateUI();
	}

	private void setJavaPic() {
		JLabel label = new JLabel(new ImageIcon(ClazzPics.class
				.getResource("java.png")));
		label.setText(LanguageResource.getString("JAVA_NATIVE_LOOK_AND_FEEL"));
		label.setVerticalTextPosition(JLabel.BOTTOM);
		label.setHorizontalTextPosition(JLabel.CENTER);
		picturePanel.removeAll();
		picturePanel.add(label, BorderLayout.CENTER);
	}

	private void setOsPic() {
		JLabel label = new JLabel(new ImageIcon(ClazzPics.class
				.getResource("os.png")));
		label.setText(LanguageResource
				.getString("OPERATING_SYSTEM_NATIVE_LOOK_AND_FEEL"));
		label.setVerticalTextPosition(JLabel.BOTTOM);
		label.setHorizontalTextPosition(JLabel.CENTER);
		picturePanel.removeAll();
		picturePanel.add(label, BorderLayout.CENTER);
	}

	private void setRmcPic() {
		JLabel label = new JLabel(new ImageIcon(ClazzPics.class
				.getResource("rmc_128.png")));
		label.setText(LanguageResource.getString("RMC_NATIVE_LOOK_AND_FEEL"));
		label.setVerticalTextPosition(JLabel.BOTTOM);
		label.setHorizontalTextPosition(JLabel.CENTER);
		picturePanel.removeAll();
		picturePanel.add(label, BorderLayout.CENTER);
	}

}
