/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui.settings;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;

public class LAMEPanel extends JPanel implements ActionListener, ChangeListener {

	private static final long serialVersionUID = 1L;

	private static JRadioButton sBitrateTargetRadioButton;

	private static JRadioButton sQualityTargetRadioButton;

	private static JComboBox sEncodingEnginQualityComboBox;

	private static JComboBox sEncodingModeComboBox;

	private static JCheckBox sCopyRightCheckBox;

	private static JPanel sBitratePanel;

	private static JSlider sBitRateSlider;

	private static JLabel sBitRateSliderLabel;

	private static JCheckBox sRestrictEncoderToConstatBitrateCheckBox;

	private static JPanel sQualityPanel;

	private static JSlider sQualitySlider;

	private static JLabel sQualitySliderLabel;

	private static JCheckBox sWhatIsLameCheckBox;

	private static String sLameFunction;

	public LAMEPanel() {
		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(LanguageResource.getString("L.A.M.E")));
		initSettingPanle();
	}

	private void initSettingPanle() {
		JPanel aUpperPanel = new JPanel(new BorderLayout());
		JPanel aTargetPanel = new JPanel(new GridLayout(2, 1));
		aTargetPanel.setBorder(new TitledBorder(LanguageResource
				.getString("TARGET")));
		sBitrateTargetRadioButton = new JRadioButton(LanguageResource
				.getString("BITRATE"));
		sBitrateTargetRadioButton.addActionListener(this);
		sQualityTargetRadioButton = new JRadioButton(LanguageResource
				.getString("QUALITY"));
		sQualityTargetRadioButton.addActionListener(this);
		aTargetPanel.add(OreintationHelper
				.setJComponentOreintation(sBitrateTargetRadioButton));
		aTargetPanel.add(OreintationHelper
				.setJComponentOreintation(sQualityTargetRadioButton));
		aUpperPanel.add(OreintationHelper
				.setJComponentOreintation(aTargetPanel),
				BorderLayout.LINE_START);

		JPanel aEncodingEnginQualityPanel = new JPanel();
		aEncodingEnginQualityPanel.setBorder(new TitledBorder(LanguageResource
				.getString("ENCODING_QUALITY")));
		sEncodingEnginQualityComboBox = new JComboBox(new Object[] {
				LanguageResource.getString("FAST"),
				LanguageResource.getString("STANDARD"),
				LanguageResource.getString("HIGH") });
		aEncodingEnginQualityPanel.add(OreintationHelper
				.setJComponentOreintation(sEncodingEnginQualityComboBox),
				BorderLayout.CENTER);
		aUpperPanel.add(OreintationHelper
				.setJComponentOreintation(aEncodingEnginQualityPanel),
				BorderLayout.CENTER);

		JPanel aEncodingTypePanel = new JPanel(new GridLayout(2, 1));
		aEncodingTypePanel.setBorder(new TitledBorder(LanguageResource
				.getString("MISCELLANEOUS")));
		sCopyRightCheckBox = new JCheckBox(LanguageResource
				.getString("COPYRIGHT_FILE"));
		sEncodingModeComboBox = new JComboBox(new Object[] {
				LanguageResource.getString("MONO"),
				LanguageResource.getString("STEREO"),
				LanguageResource.getString("JOINT_STEREO"),
				LanguageResource.getString("FORCED_STEREO"),
				LanguageResource.getString("DUAL_CHANNELS") });
		aEncodingTypePanel.add(OreintationHelper
				.setJComponentOreintation(sEncodingModeComboBox));
		aEncodingTypePanel.add(OreintationHelper
				.setJComponentOreintation(sCopyRightCheckBox));
		aUpperPanel.add(OreintationHelper
				.setJComponentOreintation(aEncodingTypePanel),
				BorderLayout.LINE_END);
		this.add(OreintationHelper.setJComponentOreintation(aUpperPanel),
				BorderLayout.PAGE_START);
		sBitratePanel = new JPanel(new GridLayout(3, 1));
		sBitratePanel.setBorder(new TitledBorder(LanguageResource
				.getString("BITRATE")));
		sBitRateSlider = new JSlider(JSlider.HORIZONTAL, 8, 320, 8);
		sBitRateSlider.addChangeListener(this);
		sBitRateSlider.setPaintLabels(true);
		sBitRateSlider.setSnapToTicks(true);
		sBitRateSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		Hashtable<Integer, JLabel> aBitrateTable = new Hashtable<Integer, JLabel>();
		aBitrateTable.put(8, new JLabel("8"));
		aBitrateTable.put(64, new JLabel("64"));
		aBitrateTable.put(128, new JLabel("128"));
		aBitrateTable.put(192, new JLabel("192"));
		aBitrateTable.put(256, new JLabel("256"));
		aBitrateTable.put(320, new JLabel("320"));
		sBitRateSlider.setLabelTable(aBitrateTable);
		sBitRateSliderLabel = new JLabel(LanguageResource
				.getString("SELECTED_VALUE")
				+ " : 8");
		sBitRateSliderLabel.setBorder(new TitledBorder(""));
		sRestrictEncoderToConstatBitrateCheckBox = new JCheckBox(
				LanguageResource
						.getString("RESTRICT_ENCODER_TO_CONSTANT_BITRATE"));
		sBitratePanel.add(OreintationHelper
				.setJComponentOreintation(sBitRateSlider));
		sBitratePanel.add(OreintationHelper
				.setJComponentOreintation(sBitRateSliderLabel));
		sBitratePanel
				.add(OreintationHelper
						.setJComponentOreintation(sRestrictEncoderToConstatBitrateCheckBox));
		this.add(OreintationHelper.setJComponentOreintation(sBitratePanel),
				BorderLayout.CENTER);
		sQualityPanel = new JPanel(new GridLayout(3, 1, 5, 5));
		sQualityPanel.setBorder(new TitledBorder(LanguageResource
				.getString("QUALITY")));
		sQualitySlider = new JSlider(JSlider.HORIZONTAL, 10, 100, 60);
		sQualitySlider.addChangeListener(this);
		sQualitySlider.setPaintLabels(true);
		sQualitySlider.setSnapToTicks(true);
		sQualitySlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
		Hashtable<Integer, JLabel> aQualityTable = new Hashtable<Integer, JLabel>();
		aQualityTable.put(10, new JLabel("10"));
		aQualityTable.put(20, new JLabel("20"));
		aQualityTable.put(30, new JLabel("30"));
		aQualityTable.put(40, new JLabel("40"));
		aQualityTable.put(50, new JLabel("50"));
		aQualityTable.put(60, new JLabel("60"));
		aQualityTable.put(70, new JLabel("70"));
		aQualityTable.put(80, new JLabel("80"));
		aQualityTable.put(90, new JLabel("90"));
		aQualityTable.put(100, new JLabel("100"));
		sQualitySlider.setLabelTable(aQualityTable);
		sQualitySliderLabel = new JLabel(LanguageResource
				.getString("SELECTED_VALUE")
				+ " : 60");
		sQualitySliderLabel.setBorder(new TitledBorder(""));

		sWhatIsLameCheckBox = new JCheckBox(LanguageResource
				.getString("WHAT_IS_LAME?_JUST_GIVE_ME_MY_MP3!"));
		sWhatIsLameCheckBox.addActionListener(this);
		sQualityPanel.add(OreintationHelper
				.setJComponentOreintation(sQualitySlider));
		sQualityPanel.add(OreintationHelper
				.setJComponentOreintation(sQualitySliderLabel));
		sQualityPanel.add(OreintationHelper
				.setJComponentOreintation(sWhatIsLameCheckBox));
		this.add(OreintationHelper.setJComponentOreintation(sQualityPanel),
				BorderLayout.PAGE_END);
		loadUserSettings(PropertyManager.getProperty("rmc.user.lame"));
	}

	@Override
	public void actionPerformed(ActionEvent pEvent) {
		if (pEvent.getSource() == sWhatIsLameCheckBox) {
			if (!sWhatIsLameCheckBox.isSelected()) {
				enablePanle(this, true);
				if (sQualityTargetRadioButton.isSelected()) {
					enablePanle(sQualityPanel, true);
					enablePanle(sBitratePanel, false);
				} else {
					enablePanle(sQualityPanel, false);
					enablePanle(sBitratePanel, true);
				}
			} else {
				enablePanle(this, false);
				sWhatIsLameCheckBox.setEnabled(true);
			}
		}
		if (pEvent.getSource() == sBitrateTargetRadioButton) {
			sBitrateTargetRadioButton.setSelected(true);
			sQualityTargetRadioButton.setSelected(false);
			enablePanle(sQualityPanel, false);
			enablePanle(sBitratePanel, true);
			sWhatIsLameCheckBox.setEnabled(true);
		} else if (pEvent.getSource() == sQualityTargetRadioButton) {
			sBitrateTargetRadioButton.setSelected(false);
			sQualityTargetRadioButton.setSelected(true);
			enablePanle(sQualityPanel, true);
			enablePanle(sBitratePanel, false);
		}
	}

	@Override
	public void stateChanged(ChangeEvent pChangeEvent) {
		if (pChangeEvent.getSource() == sBitRateSlider) {
			if (!sBitRateSlider.getValueIsAdjusting()) {
				if (sBitRateSlider.getValue() % 8 != 0) {
					if (sBitRateSlider.getValue() % 8 > 4) {
						sBitRateSlider.setValue(sBitRateSlider.getValue()
								- (sBitRateSlider.getValue() % 8) + 8);
					} else {
						sBitRateSlider.setValue(sBitRateSlider.getValue()
								- (sBitRateSlider.getValue() % 8));
					}
				}
				sBitRateSliderLabel.setText(LanguageResource
						.getString("SELECTED_VALUE")
						+ " : " + sBitRateSlider.getValue());
			}
		} else {
			if (!sQualitySlider.getValueIsAdjusting()) {
				if (sQualitySlider.getValue() % 10 != 0) {
					if (sQualitySlider.getValue() % 10 > 5) {
						sQualitySlider.setValue(sQualitySlider.getValue()
								- (sQualitySlider.getValue() % 10) + 10);
					} else {
						sQualitySlider.setValue(sQualitySlider.getValue()
								- (sQualitySlider.getValue() % 10));
					}
				}
				sQualitySliderLabel.setText(LanguageResource
						.getString("SELECTED_VALUE")
						+ " : " + sQualitySlider.getValue());
			}
		}

	}

	public static void enablePanle(JComponent pPanel, boolean pEnable) {
		pPanel.setEnabled(pEnable);
		for (int i = 0; i < pPanel.getComponents().length; i++) {
			if (pPanel.getComponents()[i] instanceof JComponent) {
				JComponent aComponent = (JComponent) pPanel.getComponents()[i];
				aComponent.setEnabled(pEnable);
				enablePanle(aComponent, pEnable);
			}
		}
	}

	private void loadUserSettings(String lameFunction) {
		sEncodingEnginQualityComboBox.setSelectedIndex(1);
		if (lameFunction.equals("lame -h ")) {
			enablePanle(this, false);
			sBitrateTargetRadioButton.setSelected(true);
			sWhatIsLameCheckBox.setEnabled(true);
			sWhatIsLameCheckBox.setSelected(true);
			return;
		}
		if (lameFunction.startsWith("lame -f ")) {
			sEncodingEnginQualityComboBox.setSelectedIndex(0);
		} else if (lameFunction.startsWith("lame -h ")) {
			sEncodingEnginQualityComboBox.setSelectedIndex(2);
		}
		if (lameFunction.contains(" -c ")) {
			sCopyRightCheckBox.setSelected(true);
		}
		if (lameFunction.contains(" -m m ")) {
			sEncodingModeComboBox.setSelectedIndex(0);
		} else if (lameFunction.contains(" -m s ")) {
			sEncodingModeComboBox.setSelectedIndex(1);
		} else if (lameFunction.contains(" -m j ")) {
			sEncodingModeComboBox.setSelectedIndex(2);
		} else if (lameFunction.contains(" -m f ")) {
			sEncodingModeComboBox.setSelectedIndex(3);
		} else if (lameFunction.contains(" -m d ")) {
			sEncodingModeComboBox.setSelectedIndex(4);
		}
		if (lameFunction.contains(" -V ")) {
			int selectedValue = 100 - Integer.parseInt(lameFunction.substring(
					lameFunction.indexOf(" -V ") + 3).trim()) * 10;
			sQualitySlider.setValue(selectedValue);
			sBitrateTargetRadioButton.setSelected(false);
			sQualityTargetRadioButton.setSelected(true);
			enablePanle(sQualityPanel, true);
			enablePanle(sBitratePanel, false);
		} else if (lameFunction.contains("--cbr -b ")
				|| lameFunction.contains("--abr ")) {
			int selectedValue;
			if (lameFunction.contains("--cbr -b ")) {
				sRestrictEncoderToConstatBitrateCheckBox.setSelected(true);
				selectedValue = Integer.parseInt(lameFunction.substring(
						lameFunction.indexOf("--cbr -b ") + 8).trim());
			} else {
				selectedValue = Integer.parseInt(lameFunction.substring(
						lameFunction.indexOf("--abr ") + 5).trim());
			}
			sBitRateSlider.setValue(selectedValue);
			sBitrateTargetRadioButton.setSelected(true);
			sQualityTargetRadioButton.setSelected(false);
			enablePanle(sQualityPanel, false);
			enablePanle(sBitratePanel, true);
			sWhatIsLameCheckBox.setEnabled(true);
		}
	}

	public String getConvertingFunction() {
		String aConvertingFunction = "lame ";
		if (sWhatIsLameCheckBox.isSelected()) {
			return "lame -h ";
		}
		if (sEncodingEnginQualityComboBox.getSelectedItem().toString().equals(
				LanguageResource.getString("FAST"))) {
			aConvertingFunction += "-f ";
		} else if (sEncodingEnginQualityComboBox.getSelectedItem().toString()
				.equals(LanguageResource.getString("HIGH"))) {
			aConvertingFunction += "-h ";
		}
		if (sCopyRightCheckBox.isSelected()) {
			aConvertingFunction += "-c ";
		}
		if (sEncodingModeComboBox.getSelectedItem().toString().equals(
				LanguageResource.getString("MONO"))) {
			aConvertingFunction += "-m m ";
		} else if (sEncodingModeComboBox.getSelectedItem().toString().equals(
				LanguageResource.getString("STEREO"))) {
			aConvertingFunction += "-m s ";
		} else if (sEncodingModeComboBox.getSelectedItem().toString().equals(
				LanguageResource.getString("JOINT_STEREO"))) {
			aConvertingFunction += "-m j ";
		} else if (sEncodingModeComboBox.getSelectedItem().toString().equals(
				LanguageResource.getString("FORCED_STEREO"))) {
			aConvertingFunction += "-m f ";
		} else if (sEncodingModeComboBox.getSelectedItem().toString().equals(
				LanguageResource.getString("DUAL_CHANNELS"))) {
			aConvertingFunction += "-m d ";
		}
		if (sBitrateTargetRadioButton.isSelected()) {
			if (sRestrictEncoderToConstatBitrateCheckBox.isSelected()) {
				aConvertingFunction += "--cbr -b " + sBitRateSlider.getValue()
						+ " ";
			} else {
				aConvertingFunction += "--abr " + sBitRateSlider.getValue()
						+ " ";
			}
		} else if (sQualityTargetRadioButton.isSelected()) {
			aConvertingFunction += ("-V " + (100 - sQualitySlider.getValue()) / 10)
					+ " ";
		}
		return aConvertingFunction;
	}

	public static String getLameFunction() {
		return sLameFunction;
	}

	public static void setLameFunction(String lameFunction) {
		sLameFunction = lameFunction;
	}
}
