/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui.settings;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class LanguagePanel extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;

	private static JRadioButton arabicRadioButton = new JRadioButton(
			LanguageResource.getString("ARABIC"), new ImageIcon(ClazzPics.class.getResource("ar.png")));

	private static JRadioButton pashtoRadioButton = new JRadioButton(
			LanguageResource.getString("PASHTO"), new ImageIcon(ClazzPics.class.getResource("ps.png")));

	
	private static JRadioButton englishRadioButton = new JRadioButton(LanguageResource.getString("ENGLISH"), new ImageIcon(
					ClazzPics.class.getResource("en.png")));

	public LanguagePanel() {
		setLayout(new BorderLayout());
		initLanguagePanel();
	}

	private void initLanguagePanel() {
		this
				.setBorder(new TitledBorder(LanguageResource
						.getString("LANGUAGE")));
		JPanel panel = new JPanel();
		panel
				.add(OreintationHelper
						.setJComponentOreintation(arabicRadioButton));
		panel.add(OreintationHelper
				.setJComponentOreintation(englishRadioButton));
		panel.add(OreintationHelper
				.setJComponentOreintation(pashtoRadioButton));
		arabicRadioButton.addActionListener(this);
		englishRadioButton.addActionListener(this);
		pashtoRadioButton.addActionListener(this);
		JLabel noteLabel = new JLabel(new ImageIcon(ClazzPics.class
				.getResource("note.png")));
		noteLabel
				.setText(LanguageResource
						.getString("PLEASE_NOTE_THAT_YOU_NEED_TO_RESTART_THE_APPLICATION_FOR_CHANGES_TOTAKE_EFFECT"));

		this.add(panel, BorderLayout.NORTH);
		this.add(noteLabel, BorderLayout.SOUTH);
		loadUserSettings(PropertyManager.getProperty("rmc.user.lang"));
	}

	private void loadUserSettings(String languageFunction) {
		if (languageFunction.equals("ar")) {
			arabicRadioButton.setSelected(true);
		} else if (languageFunction.equals("en")) {
			englishRadioButton.setSelected(true);
		} else if (languageFunction.equals("ps")) {
			pashtoRadioButton.setSelected(true);
		}
	}

	public String getLanguageOption() {
		if (arabicRadioButton.isSelected()) {
			return "ar";
		} else if (pashtoRadioButton.isSelected()) { 
			return "ps";
		} else {
			return "en";
		}
	}

	@Override
	public void actionPerformed(ActionEvent event) {
		if (event.getSource() == arabicRadioButton) {
			arabicRadioButton.setSelected(true);
			englishRadioButton.setSelected(false);
			pashtoRadioButton.setSelected(false);
		} else if (event.getSource() == pashtoRadioButton) {
			arabicRadioButton.setSelected(false);
			pashtoRadioButton.setSelected(true);
			englishRadioButton.setSelected(false);
		} else {
			arabicRadioButton.setSelected(false);
			englishRadioButton.setSelected(true);
			pashtoRadioButton.setSelected(false);
		}

	}

}
