/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui.settings;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.border.TitledBorder;

import net.dudesblog.guihelper.gui.reusables.LabledTextFeild;
import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.actions.SelectDirAction;

public class MiscPanel extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;

	private static JRadioButton wavRadioButton = new JRadioButton(
			LanguageResource.getString("WAV"));

	private static JRadioButton mp3RadioButton = new JRadioButton(
			LanguageResource.getString("MP3"));

	private static JRadioButton noRadioButton = new JRadioButton(
			LanguageResource.getString("NO"));

	private static JRadioButton yesRadioButton = new JRadioButton(
			LanguageResource.getString("YES"));

	private static JRadioButton customThreadingRadioButton = new JRadioButton(
			LanguageResource.getString("CUSTOM"));

	private static JRadioButton multiThreadedRadioButton = new JRadioButton(
			LanguageResource.getString("MULTI_THREADED"));

	private static JRadioButton singleThreadRadioButton = new JRadioButton(
			LanguageResource.getString("SINGLE_THREAD"));

	private static JSpinner threadSpinner;

	private static JCheckBox sameFileFolderCheckBox = new JCheckBox(
			LanguageResource.getString("SAME_FILE_FOLDER"));

	private static LabledTextFeild outputFolderFeild = new LabledTextFeild(
			"OUTPUT_FOLDER");

	private static JButton browseButton1 = new JButton(LanguageResource
			.getString("BROWSE"));

	private static JButton browseButton2 = new JButton(LanguageResource
			.getString("BROWSE"));

	private static LabledTextFeild mediaFolderFeild = new LabledTextFeild(
			"MEDIA_FOLDER");

	public MiscPanel() {
		initMiscPanel();
	}

	private void initMiscPanel() {
		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(LanguageResource
				.getString("MISCELLANEOUS")));
		JPanel mediaFolderPanel = new JPanel(new BorderLayout());
		mediaFolderPanel.setBorder(new TitledBorder(LanguageResource
				.getString("SELECT_YOUR_MEDIA_HOME_FOLDER")));

		mediaFolderPanel.add(OreintationHelper
				.setJComponentOreintation(mediaFolderFeild),
				BorderLayout.CENTER);
		mediaFolderPanel.add(OreintationHelper
				.setJComponentOreintation(browseButton1),
				BorderLayout.AFTER_LINE_ENDS);

		SpinnerModel model = new SpinnerListModel(new Object[] { 1, 2, 3, 4, 5,
				6, 7, 8, 9, 10, 11, 12, 13, 14, 15 });
		JPanel threadingPanel = new JPanel(new BorderLayout());
		threadingPanel.setBorder(new TitledBorder(LanguageResource
				.getString("THREADING_OPTIONS")));
		singleThreadRadioButton.addActionListener(this);
		multiThreadedRadioButton.addActionListener(this);
		customThreadingRadioButton.addActionListener(this);
		threadSpinner = new JSpinner(model);
		threadingPanel.add(OreintationHelper
				.setJComponentOreintation(singleThreadRadioButton),
				BorderLayout.NORTH);
		threadingPanel.add(OreintationHelper
				.setJComponentOreintation(multiThreadedRadioButton),
				BorderLayout.CENTER);
		JPanel customPanel = new JPanel(new BorderLayout());
		customPanel.add(OreintationHelper
				.setJComponentOreintation(customThreadingRadioButton),
				BorderLayout.CENTER);
		customPanel
				.add(OreintationHelper.setJComponentOreintation(threadSpinner),
						BorderLayout.LINE_END);
		threadingPanel.add(OreintationHelper
				.setJComponentOreintation(customPanel), BorderLayout.SOUTH);

		JPanel centerPanel = new JPanel(new BorderLayout());

		JPanel outputPanel = new JPanel(new BorderLayout());
		mp3RadioButton.addActionListener(this);
		wavRadioButton.addActionListener(this);
		outputPanel.setBorder(new TitledBorder(LanguageResource
				.getString("OUTPUT_FORMAT")));
		outputPanel.add(OreintationHelper
				.setJComponentOreintation(mp3RadioButton), BorderLayout.CENTER);
		outputPanel.add(OreintationHelper
				.setJComponentOreintation(wavRadioButton),
				BorderLayout.BEFORE_LINE_BEGINS);

		JPanel outputFolderPanel = new JPanel(new BorderLayout());
		sameFileFolderCheckBox.addActionListener(this);
		outputFolderPanel.setBorder(new TitledBorder(LanguageResource
				.getString("SELECT_YOUR_OUTPUT_FOLDER")));
		outputFolderPanel.add(OreintationHelper
				.setJComponentOreintation(outputFolderFeild),
				BorderLayout.CENTER);
		outputFolderPanel.add(OreintationHelper
				.setJComponentOreintation(browseButton2),
				BorderLayout.AFTER_LINE_ENDS);
		outputFolderPanel.add(OreintationHelper
				.setJComponentOreintation(sameFileFolderCheckBox),
				BorderLayout.NORTH);

		JPanel deleteOriginalFilesPanel = new JPanel(new BorderLayout());
		yesRadioButton.addActionListener(this);
		noRadioButton.addActionListener(this);
		deleteOriginalFilesPanel.setBorder(new TitledBorder(LanguageResource
				.getString("DELETE_ORIGINAL_FILES")));
		deleteOriginalFilesPanel.add(OreintationHelper
				.setJComponentOreintation(yesRadioButton), BorderLayout.CENTER);
		deleteOriginalFilesPanel.add(OreintationHelper
				.setJComponentOreintation(noRadioButton),
				BorderLayout.BEFORE_LINE_BEGINS);

		centerPanel.add(
				OreintationHelper.setJComponentOreintation(outputPanel),
				BorderLayout.CENTER);
		centerPanel.add(OreintationHelper
				.setJComponentOreintation(outputFolderPanel),
				BorderLayout.PAGE_START);
		centerPanel.add(OreintationHelper
				.setJComponentOreintation(deleteOriginalFilesPanel),
				BorderLayout.PAGE_END);

		this.add(OreintationHelper.setJComponentOreintation(mediaFolderPanel),
				BorderLayout.PAGE_START);
		this.add(OreintationHelper.setJComponentOreintation(centerPanel),
				BorderLayout.CENTER);
		this.add(OreintationHelper.setJComponentOreintation(threadingPanel),
				BorderLayout.PAGE_END);
		loadUserSettings();
	}

	public Map<String, String> getUserSettings() {
		Map<String, String> props = new HashMap<String, String>();
		props.put("rmc.user.mediafolder", mediaFolderFeild.getValue());
		if (sameFileFolderCheckBox.isSelected()) {
			props.put("rmc.user.outfolder", "");
		} else {
			props.put("rmc.user.outfolder", outputFolderFeild.getValue());
		}
		if (wavRadioButton.isSelected()) {
			props.put("rmc.user.outformat", "wav");
		} else {
			props.put("rmc.user.outformat", "mp3");
		}
		if (yesRadioButton.isSelected()) {
			props.put("rmc.user.delete", "true");
		} else {
			props.put("rmc.user.delete", "false");
		}
		if (singleThreadRadioButton.isSelected()) {
			props.put("rmc.user.threading", "s");
		} else if (multiThreadedRadioButton.isSelected()) {
			props.put("rmc.user.threading", "m");
		} else {
			props.put("rmc.user.threading", "c");
			props.put("rmc.user.customthreadsnumber", threadSpinner.getValue()
					.toString());
		}
		return props;
	}

	private void loadUserSettings() {
		String mediaFolder = PropertyManager
				.getProperty("rmc.user.mediafolder");
		if (mediaFolder != null) {
			File folder = new File(mediaFolder);
			if (folder.exists() && folder.isDirectory()) {
				browseButton1.addActionListener(new SelectDirAction(
						mediaFolderFeild, mediaFolder));
				mediaFolderFeild.setValue(mediaFolder);
			} else {
				browseButton1.addActionListener(new SelectDirAction(
						mediaFolderFeild, null));
			}
		}
		String outFolder = PropertyManager.getProperty("rmc.user.outfolder");
		if (outFolder != null && outFolder.length() > 0) {
			File folder = new File(outFolder);
			if (folder.exists() && folder.isDirectory()) {
				browseButton2.addActionListener(new SelectDirAction(
						outputFolderFeild, outFolder));
				outputFolderFeild.setValue(outFolder);
			} else {
				browseButton2.addActionListener(new SelectDirAction(
						outputFolderFeild, null));
			}
		} else {
			browseButton2.addActionListener(new SelectDirAction(
					outputFolderFeild, null));
			sameFileFolderCheckBox.setSelected(true);
			outputFolderFeild.getNamedTextField().setEnabled(false);
			browseButton2.setEnabled(false);
		}
		String outputFormat = PropertyManager.getProperty("rmc.user.outformat");
		if (outputFormat.equals("mp3")) {
			mp3RadioButton.setSelected(true);
		} else {
			wavRadioButton.setSelected(true);
		}
		String delete = PropertyManager.getProperty("rmc.user.delete");
		if (delete.equals("true")) {
			yesRadioButton.setSelected(true);
		} else {
			noRadioButton.setSelected(true);
		}
		String threading = PropertyManager.getProperty("rmc.user.threading");
		if (threading.equals("s")) {
			singleThreadRadioButton.setSelected(true);
			threadSpinner.setEnabled(false);
		} else if (threading.equals("m")) {
			multiThreadedRadioButton.setSelected(true);
			threadSpinner.setEnabled(false);
		} else if (threading.equals("c")) {
			customThreadingRadioButton.setSelected(true);
			threadSpinner.setEnabled(true);
			Integer threadsNumber = Integer.parseInt(PropertyManager
					.getProperty("rmc.user.customthreadsnumber"));
			threadSpinner.getModel().setValue(threadsNumber);
		}
	}

	@Override
	public void actionPerformed(ActionEvent pEvent) {
		if (pEvent.getSource() == sameFileFolderCheckBox) {
			if (sameFileFolderCheckBox.isSelected()) {
				outputFolderFeild.getNamedTextField().setEnabled(false);
				browseButton2.setEnabled(false);
			} else {
				browseButton2.setEnabled(true);
				outputFolderFeild.getNamedTextField().setEnabled(true);
			}
		}
		if (pEvent.getSource() == customThreadingRadioButton) {
			customThreadingRadioButton.setSelected(true);
			threadSpinner.setEnabled(true);
			multiThreadedRadioButton.setSelected(false);
			singleThreadRadioButton.setSelected(false);
		} else if (pEvent.getSource() == multiThreadedRadioButton) {
			customThreadingRadioButton.setSelected(false);
			threadSpinner.setEnabled(false);
			multiThreadedRadioButton.setSelected(true);
			singleThreadRadioButton.setSelected(false);
		} else if (pEvent.getSource() == singleThreadRadioButton) {
			customThreadingRadioButton.setSelected(false);
			threadSpinner.setEnabled(false);
			multiThreadedRadioButton.setSelected(false);
			singleThreadRadioButton.setSelected(true);
		}
		if (pEvent.getSource() == noRadioButton) {
			noRadioButton.setSelected(true);
			yesRadioButton.setSelected(false);
		} else if (pEvent.getSource() == yesRadioButton) {
			noRadioButton.setSelected(false);
			yesRadioButton.setSelected(true);
		}
		if (pEvent.getSource() == mp3RadioButton) {
			mp3RadioButton.setSelected(true);
			wavRadioButton.setSelected(false);
		} else if (pEvent.getSource() == wavRadioButton) {
			mp3RadioButton.setSelected(false);
			wavRadioButton.setSelected(true);
		}

	}
}
