/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.gui.settings;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.Language;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import net.dudesblog.rmc.meta.pics.ClazzPics;

public class SettingsFrame extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;

	private static JButton saveButton = new JButton(LanguageResource
			.getString("SAVE_AND_EXIT"));

	private static JButton cancelButton = new JButton(LanguageResource
			.getString("CANCEL"));

	private static LAMEPanel sSettingsPanel;

	private static SettingsFrame instance;

	private static MiscPanel miscPanel;

	private static AppearancePanel appearancePanel;

	private static JPanel buttonsPanel;

	private static LanguagePanel languagePanel;

	private SettingsFrame() {
		this.setTitle(LanguageResource.getString("SETTINGS"));
		this.setIconImage(new ImageIcon(ClazzPics.class
				.getResource("realplay.png")).getImage());
		Dimension aScreen = Toolkit.getDefaultToolkit().getScreenSize();
		this.setBounds((int) (aScreen.getWidth() - 650) / 2, (int) (aScreen
				.getHeight() - 460) / 2, 650, 460);
		this.setLayout(new BorderLayout());
		initFrame();
		JTabbedPane tabbedPane = new JTabbedPane();
		if (Language.getSCurrentLocaleLanguage().getLanguage().equals("ar")
				|| Language.getSCurrentLocaleLanguage().getLanguage().equals("ps")) {
			tabbedPane.setTabPlacement(JTabbedPane.RIGHT);
		} else {
			tabbedPane.setTabPlacement(JTabbedPane.LEFT);
		}
		if (PropertyManager.getProperty("rmc.user.lf").equals("os")) {
			this.setExtendedState(MAXIMIZED_BOTH);
		}
		tabbedPane.addTab(LanguageResource.getString("L.A.M.E"), new ImageIcon(
				ClazzPics.class.getResource("realplay.png")), OreintationHelper
				.setJComponentOreintation(sSettingsPanel), LanguageResource
				.getString("L.A.M.E"));
		tabbedPane.addTab(LanguageResource.getString("MISCELLANEOUS"),
				new ImageIcon(ClazzPics.class.getResource("misc.png")),
				OreintationHelper.setJComponentOreintation(miscPanel),
				LanguageResource.getString("MISCELLANEOUS"));
		tabbedPane.addTab(LanguageResource.getString("APPEARANCE"),
				new ImageIcon(ClazzPics.class.getResource("theme.png")),
				OreintationHelper.setJComponentOreintation(appearancePanel),
				LanguageResource.getString("APPEARANCE"));
		tabbedPane.addTab(LanguageResource.getString("LANGUAGE"),
				new ImageIcon(ClazzPics.class.getResource("language.png")),
				OreintationHelper.setJComponentOreintation(languagePanel),
				LanguageResource.getString("LANGUAGE"));
		this.add(OreintationHelper.setJComponentOreintation(tabbedPane),
				BorderLayout.CENTER);
		this.add(OreintationHelper.setJComponentOreintation(buttonsPanel),
				BorderLayout.SOUTH);
	}

	private void initFrame() {
		sSettingsPanel = new LAMEPanel();
		miscPanel = new MiscPanel();
		languagePanel = new LanguagePanel();
		appearancePanel = new AppearancePanel();
		initButtonsPanel();
	}

	private void initButtonsPanel() {
		buttonsPanel = new JPanel(new BorderLayout());
		JPanel panel = new JPanel();
		cancelButton.addActionListener(this);
		saveButton.addActionListener(this);
		panel.add(cancelButton);
		panel.add(saveButton);
		buttonsPanel.add(panel, BorderLayout.EAST);
	}

	@Override
	public void actionPerformed(ActionEvent pEvent) {
		if (pEvent.getSource() == cancelButton) {
			this.dispose();
		} else if (pEvent.getSource() == saveButton) {
			Properties properties = new Properties();
			properties.put("rmc.user.lame", sSettingsPanel
					.getConvertingFunction());
			properties.putAll(miscPanel.getUserSettings());
			properties.put("rmc.user.lf", appearancePanel.getThemeOption());
			properties.put("rmc.user.lf.sub", appearancePanel
					.getSubThemeOption());
			properties.put("rmc.user.lang", languagePanel.getLanguageOption());
			PropertyManager.saveUserSettings(properties);
			this.dispose();
		}
	}

	public static SettingsFrame getInstance() {
		if (instance == null) {
			instance = new SettingsFrame();
		}
		return instance;
	}

}
