/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.start;

import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import net.dudesblog.guihelper.gui.font.GuiFontSetter;
import net.dudesblog.guihelper.gui.look.MyUIManager;
import net.dudesblog.guihelper.gui.reusables.SplashScreen;
import net.dudesblog.guihelper.lock.UniqueApp;
import net.dudesblog.guihelper.util.PropertyManager;
import net.dudesblog.guihelper.util.Language_util.Language;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.rmc.gui.MainFrame;
import net.dudesblog.rmc.gui.settings.SettingsFrame;
import net.dudesblog.rmc.meta.pics.ClazzPics;
import net.dudesblog.rmc.util.FileManager;

public class Launcher {

	public static void main(String[] args) throws ClassNotFoundException,
			InstantiationException, IllegalAccessException,
			UnsupportedLookAndFeelException {
		MyUIManager.setLF(PropertyManager.getProperty("rmc.user.lf"));
		Language.setSCurrentLocaleOreintation(new Locale(PropertyManager.getProperty("rmc.user.lang")));
		Language.setSCurrentLocaleLanguage(new Locale(PropertyManager.getProperty("rmc.user.lang")));
		if (PropertyManager.getProperty("rmc.user.lang").equals("ps")) {
			Language.setSCurrentLocaleOreintation(new Locale("ar"));
		}
		MainFrame aMainFarme = new MainFrame();
		if (applicationIsUnique()) {
			SplashScreen aSplashScreen = new SplashScreen("rmc_192.png");
			init();
			FileManager.initializeTempFolder();
			GuiFontSetter.adjustFont(aMainFarme);
			GuiFontSetter.adjustFont(SettingsFrame.getInstance());
			aMainFarme.setVisible(true);
			aSplashScreen.dispose();
		} else {
			JOptionPane.showMessageDialog(aMainFarme, LanguageResource
					.getString("APPLICATION_ALREADY_RUNING"), LanguageResource
					.getString("ERROR"), JOptionPane.OK_OPTION, new ImageIcon(
					ClazzPics.class.getResource("realplay.png")));
			System.exit(0);
		}
	}

	public static void init() {
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				FileManager.initializeTempFolder();
			}
		});
		// TODO localize file chooser options from the excel sheet in the
		// /home/fadi/Archive/java_programing/Internationalization for Swing
		// standard components.ods
		UIManager.put("OptionPane.cancelButtonText", LanguageResource
				.getString("Cancel"));
		UIManager.put("OptionPane.noButtonText", LanguageResource
				.getString("No"));
		UIManager.put("OptionPane.okButtonText", LanguageResource
				.getString("Ok"));
		UIManager.put("OptionPane.yesButtonText", LanguageResource
				.getString("Yes"));
	}

	private static boolean applicationIsUnique() {
		UniqueApp aUniqueApp = new UniqueApp("AuditingManager");
		if (aUniqueApp.isAppActive()) {
			return false;
		} else {
			return true;
		}
	}
}
