/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.util.constants;

import java.io.File;

public interface Constants {
	
	public static final String OSName = System.getProperty("os.name").toLowerCase();

	public interface GUIConstants {

		public static final String PARENT = "parent";

		public static final String SECOND_CHILD = "secondChild";

		public static final String FIRST_CHILD = "firstChild";
	}

	public class FileConstants {

		public static String USER_HOME;
		
		static {
			if (OSName.contains("windows")) {
				USER_HOME = "c:/rmc";
			} else {
				USER_HOME = System.getProperty("user.home");
			}
		}

		public static final String RMC_USER_FOLDER_NAME = ".rmc";

		public static final String RMC_TEMP_FOLDER_NAME = "tmp";

		public static final File RMC_USER_FOLDER = new File(USER_HOME, RMC_USER_FOLDER_NAME);

		public static final File RMC_TEMP_FOLDER = new File(RMC_USER_FOLDER, RMC_TEMP_FOLDER_NAME);

		public static final File RMC_USER_CONFIG_FILE = new File(RMC_USER_FOLDER, "userConfig.xml");

	}
}
