/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.graphstream.algorithm.generator.BaseGenerator;

public class LifeGenerator
extends BaseGenerator {
    private static final int[] NEIGHT = new int[]{-1, -1, 0, -1, 1, -1, -1, 0, 1, 0, -1, 1, 0, 1, 1, 1};
    private static final int[] LINK_WITH = new int[]{-1, -1, 0, -1, 1, -1, -1, 0};
    int width;
    int height;
    boolean[] cells;
    boolean[] swap;
    boolean tore;
    boolean pushCoords;
    double step;

    public LifeGenerator(int width, int height, boolean[] data) {
        this.width = width;
        this.height = height;
        this.cells = Arrays.copyOf(data, data.length);
        this.swap = new boolean[width * height];
    }

    public LifeGenerator(String path) throws IOException {
        File in = new File(path);
        BufferedImage data = ImageIO.read(in);
        this.loadData(data);
        this.pushCoords = true;
        this.tore = true;
    }

    public LifeGenerator(InputStream in) throws IOException {
        BufferedImage data = ImageIO.read(in);
        this.loadData(data);
        this.pushCoords = true;
        this.tore = true;
    }

    public LifeGenerator(BufferedImage cellsData) {
        this.loadData(cellsData);
        this.pushCoords = true;
        this.tore = true;
    }

    protected void loadData(BufferedImage data) {
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.cells = new boolean[this.width * this.height];
        this.swap = new boolean[this.width * this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int rgb = data.getRGB(x, y);
                this.cells[x * this.height + y] = (rgb & 0xFF0000) != 0;
            }
        }
    }

    protected void computeNextState() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int c = 0;
                int idx = x * this.height + y;
                boolean alive = this.cells[idx];
                for (int i = 0; i < NEIGHT.length; i += 2) {
                    int ny;
                    int nx;
                    if (!this.tore && (x + NEIGHT[i] < 0 || x + NEIGHT[i] >= this.width || y + NEIGHT[i + 1] < 0 || y + NEIGHT[i + 1] >= this.height) || !this.cells[(nx = (x + NEIGHT[i] + this.width) % this.width) * this.height + (ny = (y + NEIGHT[i + 1] + this.height) % this.height)]) continue;
                    ++c;
                }
                this.swap[idx] = false;
                if (!alive && c == 3) {
                    this.swap[idx] = true;
                    continue;
                }
                if (alive && c < 2) {
                    this.swap[idx] = false;
                    continue;
                }
                if (alive && c < 4) {
                    this.swap[idx] = true;
                    continue;
                }
                if (!alive || c <= 3) continue;
                this.swap[idx] = false;
            }
        }
    }

    protected void addNode(int x, int y) {
        String id = this.nodeId(x, y);
        this.addNode(id);
        if (this.pushCoords) {
            this.sendNodeAttributeAdded(this.sourceId, id, "xyz", new float[]{x, y, 0.0f});
        }
    }

    protected void delNode(int x, int y) {
        this.delNode(this.nodeId(x, y));
    }

    protected void addEdge(int x1, int y1, int x2, int y2) {
        this.addEdge(this.edgeId(x1, y1, x2, y2), this.nodeId(x1, y1), this.nodeId(x2, y2));
    }

    protected void delEdge(int x1, int y1, int x2, int y2) {
        this.delEdge(this.edgeId(x1, y1, x2, y2));
    }

    protected String nodeId(int x, int y) {
        return String.format("%d_%d", x, y);
    }

    protected String edgeId(int x1, int y1, int x2, int y2) {
        return String.format("%d_%d__%d_%d", x1, y1, x2, y2);
    }

    @Override
    public void begin() {
        this.step = 0.0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.cells[x * this.height + y]) continue;
                this.addNode(x, y);
            }
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                boolean alive = this.cells[x * this.height + y];
                for (int i = 0; i < LINK_WITH.length; i += 2) {
                    if (!this.tore && (x + LINK_WITH[i] < 0 || x + LINK_WITH[i] >= this.width || y + LINK_WITH[i + 1] < 0 || y + LINK_WITH[i + 1] >= this.height)) continue;
                    int nx = (x + LINK_WITH[i] + this.width) % this.width;
                    int ny = (y + LINK_WITH[i + 1] + this.height) % this.height;
                    boolean nalive = this.cells[nx * this.height + ny];
                    if (!alive || !nalive) continue;
                    this.addEdge(x, y, nx, ny);
                }
            }
        }
    }

    @Override
    public boolean nextEvents() {
        int idx;
        int y;
        int x;
        this.computeNextState();
        double d = this.step;
        this.step = d + 1.0;
        this.sendStepBegins(this.sourceId, d);
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                idx = x * this.height + y;
                if (this.cells[idx] || !this.swap[idx]) continue;
                this.addNode(x, y);
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                boolean alive = this.swap[x * this.height + y];
                boolean alived = this.cells[x * this.height + y];
                for (int i = 0; i < LINK_WITH.length; i += 2) {
                    if (!this.tore && (x + LINK_WITH[i] < 0 || x + LINK_WITH[i] >= this.width || y + LINK_WITH[i + 1] < 0 || y + LINK_WITH[i + 1] >= this.height)) continue;
                    int nx = (x + LINK_WITH[i] + this.width) % this.width;
                    int ny = (y + LINK_WITH[i + 1] + this.height) % this.height;
                    boolean nalive = this.swap[nx * this.height + ny];
                    boolean nalived = this.cells[nx * this.height + ny];
                    if (alived && nalived && (alive && !nalive || !alive && nalive)) {
                        this.delEdge(x, y, nx, ny);
                        continue;
                    }
                    if (!(!alived && nalived || alived && !nalived) && (alived || nalived) || !alive || !nalive) continue;
                    this.addEdge(x, y, nx, ny);
                }
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                idx = x * this.height + y;
                if (!this.cells[idx] || this.swap[idx]) continue;
                this.delNode(x, y);
            }
        }
        boolean[] tmp = this.cells;
        this.cells = this.swap;
        this.swap = tmp;
        return true;
    }

    public void setTore(boolean on) {
        this.tore = on;
    }

    public boolean isTore() {
        return this.tore;
    }

    public void setPushCoords(boolean on) {
        this.pushCoords = on;
    }

    public boolean isCoordsPushed() {
        return this.pushCoords;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

