/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import java.util.concurrent.atomic.DoubleAccumulator;
import org.graphstream.algorithm.DynamicAlgorithm;
import org.graphstream.algorithm.measure.ChartMinMaxAverageSeriesMeasure;
import org.graphstream.graph.Graph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SinkAdapter;

public class DegreeMeasure
extends ChartMinMaxAverageSeriesMeasure
implements DynamicAlgorithm {
    protected Graph g;
    private Sink trigger = new StepTrigger();

    public DegreeMeasure() {
        super("Degree");
    }

    @Override
    public void terminate() {
        this.g.removeSink(this.trigger);
        this.g = null;
    }

    @Override
    public void compute() {
        DoubleAccumulator min = new DoubleAccumulator((x, y) -> y, Double.MAX_VALUE);
        DoubleAccumulator max = new DoubleAccumulator((x, y) -> y, Double.MIN_VALUE);
        DoubleAccumulator avg = new DoubleAccumulator((x, y) -> x + y, 0.0);
        this.g.nodes().forEach(n -> {
            min.accumulate(Math.min(min.get(), (double)n.getDegree()));
            max.accumulate(Math.max(max.get(), (double)n.getDegree()));
            avg.accumulate(n.getDegree());
        });
        int avgFinal = (int)(avg.get() / (double)this.g.getNodeCount());
        this.addValue(this.g.getStep(), min.get(), avgFinal, max.get());
    }

    @Override
    public void init(Graph graph) {
        this.g = graph;
        this.g.addSink(this.trigger);
    }

    private class StepTrigger
    extends SinkAdapter {
        private StepTrigger() {
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            DegreeMeasure.this.compute();
        }
    }
}

