/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import swingx.Marker;
import swingx.docking.Bridge;
import swingx.docking.Dock;
import swingx.docking.DockingPane;
import swingx.docking.Slice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Docking
extends JLayeredPane {
    private DockingPane dockingPane;
    public DropLayer dropLayer = new DropLayer();
    private JComponent root;
    private Rectangle screenBounds = new Rectangle();

    public Docking() {
        this.setLayout(new DockLayout());
        this.add((Component)this.dropLayer, JLayeredPane.DRAG_LAYER);
    }

    public void setMarkerXOR(boolean xor) {
        this.dropLayer.xor = xor;
    }

    public void setMarkerStroke(BasicStroke stroke) {
        this.dropLayer.stroke = stroke;
    }

    public void setMarkerForeground(Color foreground) {
        this.dropLayer.foreground = foreground;
    }

    public void setMarkerBackground(Color background) {
        this.dropLayer.background = background;
    }

    public void setDockingPane(DockingPane dockingPane) {
        if (this.dockingPane != null) {
            throw new Error("dockingPane already set");
        }
        this.dockingPane = dockingPane;
    }

    public void setRoot(JComponent root) {
        this.root = root;
        this.add(root);
    }

    public void setScreenBounds(Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds must not be null");
        }
        this.screenBounds = bounds;
    }

    public Rectangle getScreenBounds() {
        return this.screenBounds;
    }

    public JComponent getRoot() {
        return this.root;
    }

    public void startDrop() {
        this.dropLayer.setVisible(true);
    }

    public void endDrop() {
        this.dropLayer.clearMark();
        this.dropLayer.setVisible(false);
    }

    public List<Object> getDockableKeys() {
        ArrayList<Object> keys = new ArrayList<Object>();
        this.getDockableKeys(this.root, keys);
        return keys;
    }

    private void getDockableKeys(JComponent component, List<Object> keys) {
        if (component instanceof Slice) {
            Slice slice = (Slice)component;
            this.getDockableKeys(slice.getMain(), keys);
            this.getDockableKeys(slice.getRemainder(), keys);
        } else if (component instanceof Dock) {
            Dock dock = (Dock)component;
            keys.addAll(dock.getDockableKeys());
        }
    }

    public boolean hasDockable() {
        return this.hasDockable(this.root);
    }

    protected boolean hasDockable(JComponent component) {
        if (component instanceof Slice) {
            Slice slice = (Slice)component;
            if (this.hasDockable(slice.getMain())) {
                return true;
            }
            if (this.hasDockable(slice.getRemainder())) {
                return true;
            }
        } else if (component instanceof Dock) {
            Dock dock = (Dock)component;
            return dock.hasDockable();
        }
        return false;
    }

    public boolean updateVisibility() {
        boolean hasVisible = this.hasVisibleDockOrBridge(this.root);
        Dock dock = null;
        if (!hasVisible) {
            dock = this.getDock(null, this.root);
        }
        this.updateVisibility(this.root, dock);
        return hasVisible;
    }

    protected void updateVisibility(JComponent component, Dock keepVisible) {
        if (component instanceof Slice) {
            Slice slice = (Slice)component;
            this.updateVisibility(slice.getMain(), keepVisible);
            this.updateVisibility(slice.getRemainder(), keepVisible);
            slice.setVisible(slice.getMain().isVisible() || slice.getRemainder().isVisible());
        } else if (component instanceof Dock) {
            Dock dock = (Dock)component;
            component.setVisible(dock == keepVisible || dock.getVisibleDockableCount() > 0);
        } else if (component instanceof Bridge) {
            Bridge bridge;
            bridge.setVisible((bridge = (Bridge)component).getBridged() != null);
        }
    }

    protected boolean hasVisibleDockOrBridge(JComponent component) {
        Bridge bridge;
        Dock dock;
        if (component instanceof Slice) {
            Slice slice = (Slice)component;
            if (this.hasVisibleDockOrBridge(slice.getMain())) {
                return true;
            }
            if (this.hasVisibleDockOrBridge(slice.getRemainder())) {
                return true;
            }
        } else if (component instanceof Dock ? (dock = (Dock)component).getVisibleDockableCount() > 0 : component instanceof Bridge && (bridge = (Bridge)component).getBridged() != null) {
            return true;
        }
        return false;
    }

    public Slice slice(JComponent child, JComponent main) {
        Slice newSlice = this.dockingPane.createSlice();
        if (child == this.root) {
            this.remove(this.root);
            newSlice.setMain(main);
            newSlice.setRemainder(child);
            this.root = newSlice;
            this.add(this.root);
            this.repaint();
            this.revalidate();
        } else {
            Slice parentSlice = this.getSlice(child);
            parentSlice.replace(child, newSlice);
            newSlice.setMain(main);
            newSlice.setRemainder(child);
        }
        return newSlice;
    }

    public void unslice(JComponent child) {
        if (child == this.root) {
            this.remove(this.root);
            this.root = this.dockingPane.createDock();
            this.add(this.root);
            this.repaint();
            this.revalidate();
        } else {
            Slice slice = this.getSlice(child);
            JComponent other = slice.getOther(child);
            if (slice == this.root) {
                this.remove(this.root);
                this.root = other;
                this.add(other);
            } else {
                Slice sliceSlice = this.getSlice(slice);
                sliceSlice.replace(slice, other);
            }
        }
    }

    private Slice getSlice(JComponent component) {
        Container parent = component.getParent();
        while (!(parent instanceof Slice)) {
            parent = parent.getParent();
        }
        return (Slice)parent;
    }

    public Bridge getBridge(Object key) {
        return this.getBridge(key, this.root);
    }

    private Bridge getBridge(Object key, JComponent component) {
        Slice slice;
        Bridge bridge = null;
        if (component instanceof Bridge) {
            Bridge candidate = (Bridge)component;
            if (key.equals(candidate.getKey())) {
                bridge = candidate;
            }
        } else if (component instanceof Slice && (bridge = this.getBridge(key, (slice = (Slice)component).getMain())) == null) {
            bridge = this.getBridge(key, slice.getRemainder());
        }
        return bridge;
    }

    public Dock getDock(Object key) {
        return this.getDock(key, this.root);
    }

    private Dock getDock(Object key, JComponent component) {
        Slice slice;
        Dock dock = null;
        if (component instanceof Dock) {
            Dock candidate = (Dock)component;
            if (key == null || candidate.containsDockable(key)) {
                dock = candidate;
            }
        } else if (component instanceof Slice && (dock = this.getDock(key, (slice = (Slice)component).getMain())) == null) {
            dock = this.getDock(key, slice.getRemainder());
        }
        return dock;
    }

    public JComponent getDropReceiver() {
        return this.dropLayer;
    }

    protected class DockLayout
    implements LayoutManager {
        protected DockLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension size = new Dimension();
            Insets insets = Docking.this.getInsets();
            size.width = insets.left + insets.top;
            size.height = insets.top + insets.bottom;
            if (Docking.this.root.isVisible()) {
                Dimension rootSize = Docking.this.root.getMinimumSize();
                size.width += rootSize.width;
                size.height += rootSize.height;
            }
            return size;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size = new Dimension();
            Insets insets = Docking.this.getInsets();
            size.width = insets.left + ((Docking)Docking.this).screenBounds.width + insets.right;
            size.height = insets.top + ((Docking)Docking.this).screenBounds.height + insets.bottom;
            return size;
        }

        public void layoutContainer(Container parent) {
            int x = 0;
            int y = 0;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Docking.this.dropLayer.setBounds(x, y, width, height);
            Insets insets = parent.getInsets();
            Docking.this.root.setBounds(x += insets.left, y += insets.top, width -= insets.left + insets.right, height -= insets.top + insets.bottom);
        }
    }

    protected class DropLayer
    extends JComponent {
        private boolean xor = false;
        private Color background = new Color(0, 0, 255, 32);
        private Color foreground = new Color(0, 0, 255, 128);
        private BasicStroke stroke = new BasicStroke(2.0f);
        private Marker marker;

        private DropLayer() {
            this.setVisible(false);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.marker != null) {
                this.marker.paint((Graphics2D)g);
            }
        }

        public void clearMark() {
            if (this.marker != null) {
                this.marker.release();
                this.marker = null;
            }
        }

        public void setMark(Rectangle rect, int orientation, float weight) {
            this.clearMark();
            if (rect == null) {
                throw new IllegalArgumentException("rect must not be null");
            }
            if (orientation == 1) {
                rect.height = (int)((float)rect.height * weight);
            } else if (orientation == 3) {
                rect.y = rect.y + rect.height - (int)((float)rect.height * weight);
                rect.height = (int)((float)rect.height * weight);
            } else if (orientation == 2) {
                rect.width = (int)((float)rect.width * weight);
            } else if (orientation == 4) {
                rect.x = rect.x + rect.width - (int)((float)rect.width * weight);
                rect.width = (int)((float)rect.width * weight);
            }
            this.marker = Marker.create(this, this.xor, this.background, this.foreground, this.stroke, rect);
        }
    }
}

