/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.PointInTime;
import java.util.ArrayList;
import java.util.Arrays;

public class STEvent
implements Comparable {
    private static String SEP = " - ";
    public String type;
    public String city;
    public double lat;
    public double lon;
    public String[] lastnames;
    public int year;
    public String entity;
    public String propertyName;
    public String propertyDate;
    public String propertyPlace;
    public String propertyString;
    private Property property;

    public STEvent() {
        this.property = null;
    }

    public STEvent(Property property, Double lat, Double lon) {
        this.type = STEvent.buildType(property.getTag());
        this.city = STEvent.buildCity(property.getProperty("PLAC"));
        this.lat = lat;
        this.lon = lon;
        this.lastnames = STEvent.buildLastnames(property.getEntity());
        this.year = STEvent.buildDate((PropertyDate)property.getProperty("DATE"));
        this.property = property;
        this.entity = this.getDisplayEntity();
        this.propertyName = this.getDisplayName();
        this.propertyDate = this.getDisplayDate();
        this.propertyPlace = this.getDisplayPlace();
        this.propertyString = this.getDisplayString();
    }

    public int compareTo(Object o) {
        return this.getKey().compareTo(((STEvent)o).getKey());
    }

    public boolean isSameType(STEvent e) {
        return this.type.equals(e.type);
    }

    public boolean isSameCity(STEvent e) {
        if (this.city.equals(e.city) && !e.city.isEmpty()) {
            return true;
        }
        for (String city1 : this.city.split(" ")) {
            for (String city2 : e.city.split(" ")) {
                if ((!city1.contains(city2) || city1.length() <= 2) && (!city2.contains(city1) || city2.length() <= 2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSameYear(STEvent e) {
        return this.year == e.year;
    }

    public boolean isSameName(STEvent e) {
        for (String name1 : this.lastnames) {
            if (name1.length() < 3) continue;
            for (String name2 : e.lastnames) {
                if (name2.length() < 3 || !name1.contains(name2) && !name2.contains(name1)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSame(STEvent e) {
        return this.isSameType(e) && this.isSameCity(e) && this.isSameName(e) && this.isSameYear(e);
    }

    public String getDisplayEvent() {
        return this.propertyName + SEP + this.propertyDate + SEP + this.propertyPlace;
    }

    public Object getProperty() {
        return this.property == null ? this.propertyString : this.property;
    }

    private String getDisplayEntity() {
        Entity ent = this.property.getEntity();
        return ent.toString(true);
    }

    private String getDisplayName() {
        return this.property.getPropertyName();
    }

    private String getDisplayDate() {
        PropertyDate pDate = (PropertyDate)this.property.getProperty("DATE");
        return pDate == null ? "" : pDate.getDisplayValue();
    }

    private String getDisplayPlace() {
        PropertyPlace pPlace = (PropertyPlace)this.property.getProperty("PLAC");
        return pPlace == null ? "" : pPlace.getDisplayValue();
    }

    private String getDisplayString() {
        return this.property.toString();
    }

    private String getKey() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.type).append(SEP);
        ret.append(this.city).append(SEP);
        for (String name : this.lastnames) {
            ret.append(name).append(SEP);
        }
        return ret.toString();
    }

    private static String buildType(String tag) {
        String type = "";
        switch (tag) {
            case "BIRT": 
            case "CHR": 
            case "BAPM": {
                type = "B";
                break;
            }
            case "MARR": 
            case "MARC": 
            case "ENGA": {
                type = "M";
                break;
            }
            case "DEAT": 
            case "BURI": 
            case "CREM": {
                type = "S";
                break;
            }
            default: {
                type = "Z";
            }
        }
        return type;
    }

    private static String buildCity(Property pPlace) {
        return ((PropertyPlace)pPlace).getCity().toUpperCase();
    }

    private static int buildDate(PropertyDate pDate) {
        PointInTime pitS = pDate.getStart();
        if (pDate.isRange()) {
            PointInTime pitE = pDate.getEnd();
            return (pitS.getYear() + pitE.getYear()) / 2;
        }
        return pitS.getYear();
    }

    private static String[] buildLastnames(Entity entity) {
        String[] ret = new String[]{};
        if (entity instanceof Indi) {
            Indi indi = (Indi)entity;
            return STEvent.upperCase(indi.getLastNames());
        }
        if (entity instanceof Fam) {
            Indi wife;
            ArrayList<String> names = new ArrayList<String>();
            Fam fam = (Fam)entity;
            Indi husb = fam.getHusband();
            if (husb != null) {
                names.addAll(Arrays.asList(STEvent.upperCase(husb.getLastNames())));
            }
            if ((wife = fam.getWife()) != null) {
                names.addAll(Arrays.asList(STEvent.upperCase(wife.getLastNames())));
            }
            return names.toArray(new String[names.size()]);
        }
        return ret;
    }

    private static String[] upperCase(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].toUpperCase();
        }
        return names;
    }
}

