/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Note;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyXRef;
import java.util.Optional;
import java.util.regex.Pattern;

public class PropertyNote
extends PropertyXRef {
    public static final String TAG = "NOTE";

    PropertyNote(String tag) {
        super(tag);
        this.assertTag(TAG);
    }

    PropertyNote() {
        super(TAG);
    }

    @Override
    protected boolean findPropertiesRecursivelyTest(Pattern tag, Pattern value) {
        Optional<Entity> oNote = this.getTargetEntity();
        if (oNote.isPresent()) {
            AbstractNote note = (AbstractNote)oNote.get();
            if (tag.matcher(this.getTag()).matches() && value.matcher(note.getDelegate().getValue()).matches()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void link() throws GedcomException {
        Note enote = (Note)this.getCandidate();
        PropertyForeignXRef fxref = new PropertyForeignXRef();
        enote.addProperty(fxref);
        this.link(fxref);
    }

    @Override
    public String getTargetType() {
        return TAG;
    }
}

