/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ChangeSupport
implements DocumentListener,
ChangeListener,
ActionListener {
    private List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private Object source;
    private boolean hasChanged = false;
    private boolean mute = false;

    public ChangeSupport(Object source) {
        this.source = source;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean set) {
        this.hasChanged = set;
        if (set) {
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listeners.isEmpty()) {
            this.hasChanged = false;
        }
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void removeAllChangeListeners() {
        this.listeners.clear();
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this.source);
    }

    public final void fireChangeEvent(Object source) {
        this.fireChangeEvent(new ChangeEvent(source));
    }

    public void fireChangeEvent(ChangeEvent event) {
        this.hasChanged = true;
        if (!this.mute) {
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(event);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChangeEvent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireChangeEvent(e.getSource());
    }

    public void mute() {
        this.mute = true;
    }

    public void unmute() {
        this.mute = false;
    }
}

