/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import genj.gedcom.Gedcom;
import genj.util.Registry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class MassMergePanel
extends JPanel {
    public static int GEDCOM_SCOPE = 0;
    public static int BATCH_SCOPE = 1;
    public static int DUPLICATE_SCOPE = 2;
    private Registry registry = null;
    private JRadioButton batchScope;
    private ButtonGroup buttonGroup1;
    private JRadioButton duplicateScope;
    private JRadioButton gedcomScope;
    private JLabel mergeScopeLabel;
    private JLabel probLabel;
    private JSpinner probThreshold;

    public MassMergePanel(Gedcom gedcom) {
        this.registry = gedcom.getRegistry();
        this.initComponents();
        this.readParams();
        this.updateDisplay();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.mergeScopeLabel = new JLabel();
        this.duplicateScope = new JRadioButton();
        this.batchScope = new JRadioButton();
        this.gedcomScope = new JRadioButton();
        this.probLabel = new JLabel();
        this.probThreshold = new JSpinner();
        Mnemonics.setLocalizedText((JLabel)this.mergeScopeLabel, (String)NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.mergeScopeLabel.text"));
        this.mergeScopeLabel.setToolTipText(NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.mergeScopeLabel.toolTipText"));
        this.buttonGroup1.add(this.duplicateScope);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateScope, (String)NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.duplicateScope.text"));
        this.duplicateScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MassMergePanel.this.duplicateScopeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.batchScope);
        Mnemonics.setLocalizedText((AbstractButton)this.batchScope, (String)NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.batchScope.text"));
        this.batchScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MassMergePanel.this.batchScopeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.gedcomScope);
        Mnemonics.setLocalizedText((AbstractButton)this.gedcomScope, (String)NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.gedcomScope.text"));
        this.gedcomScope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MassMergePanel.this.gedcomScopeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.probLabel, (String)NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.probLabel.text"));
        this.probLabel.setToolTipText(NbBundle.getMessage(MassMergePanel.class, (String)"MassMergePanel.probLabel.toolTipText"));
        this.probThreshold.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(50), null, (Number)1));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.probLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.probThreshold).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.mergeScopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gedcomScope).addComponent(this.batchScope).addComponent(this.duplicateScope)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mergeScopeLabel).addComponent(this.duplicateScope)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.batchScope).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gedcomScope).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.probLabel).addComponent(this.probThreshold, -2, 30, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void duplicateScopeActionPerformed(ActionEvent evt) {
        this.updateDisplay();
    }

    private void batchScopeActionPerformed(ActionEvent evt) {
        this.updateDisplay();
    }

    private void gedcomScopeActionPerformed(ActionEvent evt) {
        this.updateDisplay();
    }

    public void readParams() {
        this.duplicateScope.setSelected(this.registry.get("duplicatesDuplicateScope", true));
        this.batchScope.setSelected(this.registry.get("duplicatesBatchScope", false));
        this.gedcomScope.setSelected(this.registry.get("duplicatesGedcomScope", false));
        this.probThreshold.setValue(this.registry.get("duplicatesMergeThreshold", 100));
    }

    public void storeParams() {
        this.registry.put("duplicatesDuplicateScope", Boolean.valueOf(this.duplicateScope.isSelected()));
        this.registry.put("duplicatesBatchScope", Boolean.valueOf(this.batchScope.isSelected()));
        this.registry.put("duplicatesGedcomScope", Boolean.valueOf(this.gedcomScope.isSelected()));
        this.registry.put("duplicatesMergeThreshold", this.probThreshold.getValue().toString());
    }

    public int getThreshold() {
        return (Integer)this.probThreshold.getValue();
    }

    public int getMergeScope() {
        return this.gedcomScope.isSelected() ? GEDCOM_SCOPE : (this.batchScope.isSelected() ? BATCH_SCOPE : DUPLICATE_SCOPE);
    }

    private void updateDisplay() {
        boolean isThreshHoldDisabled = !this.duplicateScope.isSelected();
        this.probLabel.setEnabled(isThreshHoldDisabled);
        this.probThreshold.setEnabled(isThreshHoldDisabled);
    }
}

