/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.foryed;

import ancestris.core.TextOptions;
import ancestris.reports.FilterOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.foryed.Events;
import ancestris.reports.foryed.Gender;
import ancestris.reports.foryed.Images;
import ancestris.reports.foryed.Layout;
import ancestris.reports.foryed.Links;
import ancestris.reports.utils.PropUtils;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.TextLabelPanel;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.renderer.BlueprintRenderer;
import genj.report.Report;
import genj.util.EnvironmentChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openide.util.Exceptions;

public class ReportForYEd
extends Report {
    private static final Logger LOGGER = Logger.getLogger(ReportForYEd.class.getName());
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    public FilterOptions filterOptions = new FilterOptions();
    public Layout layout = new Layout();
    public Gender gender = new Gender();
    public Images images = new Images();
    public Events events = new Events();
    public Links links = new Links(this.translate("indiUrlDefault"), this.translate("familyUrlDefault"), this);
    private String xmlLinkContainer = this.getString("xmlLinkContainer");
    private String xmlPopupContainer = this.getString("xmlPopupContainer");
    private String xmlFamily = this.getString("xmlFamily");
    private String xmlIndi = this.getString("xmlIndi");
    private String xmlEdge = this.getString("xmlEdge");
    private String xmlHead = this.getString("XmlHead");
    private String xmlTail = this.getString("XmlTail");
    private static final TextOptions TEXT_OPTIONS = TextOptions.getInstance();
    private static final PointInTime pit = new PointInTime(1, 1, 2200);
    private int edgeCount = 0;
    private File reportFile;
    private Entity entity;
    private BlueprintRenderer indiRenderer;
    private BlueprintRenderer famRenderer;

    private void setUserXmlContent(boolean reset) {
        block9: {
            try {
                File xmlProperties;
                File dir = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/report", (String)"?", (String)"Looking for user directory"));
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((xmlProperties = new File(dir.getAbsolutePath() + "/ReportForYed.properties")).exists() && reset) {
                    xmlProperties.delete();
                }
                if (xmlProperties.exists()) break block9;
                xmlProperties.createNewFile();
                StringBuilder sb = new StringBuilder();
                sb.append("XmlHead=").append(this.xmlHead).append('\n');
                sb.append("XmlIndi=").append(this.xmlIndi).append('\n');
                sb.append("XmlFamily=").append(this.xmlFamily).append('\n');
                sb.append("XmlEdge=").append(this.xmlEdge).append('\n');
                sb.append("XmlLinkContainer=").append(this.xmlLinkContainer).append('\n');
                sb.append("XmlPopupContainer=").append(this.xmlPopupContainer).append('\n');
                sb.append("XmlTail=").append(this.xmlTail).append('\n');
                try (FileOutputStream fw = new FileOutputStream(xmlProperties);){
                    fw.write(sb.toString().getBytes(Charset.forName("UTF-8")));
                    fw.flush();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Unable to work with ReportForYed.properties");
            }
        }
    }

    private void loadUserXmlContent() {
        File xmlProperties = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/report/ReportForYed.properties", (String)"?", (String)"Looking for user directory"));
        try (FileInputStream fis = new FileInputStream(xmlProperties);){
            Properties newValues = new Properties();
            newValues.load(fis);
            if (newValues.containsKey("XmlHead")) {
                this.xmlHead = newValues.getProperty("XmlHead");
            }
            if (newValues.containsKey("XmlIndi")) {
                this.xmlIndi = newValues.getProperty("XmlIndi");
            }
            if (newValues.containsKey("XmlFamily")) {
                this.xmlFamily = newValues.getProperty("XmlFamily");
            }
            if (newValues.containsKey("XmlEdge")) {
                this.xmlEdge = newValues.getProperty("XmlEdge");
            }
            if (newValues.containsKey("XmlLinkContainer")) {
                this.xmlLinkContainer = newValues.getProperty("XmlLinkContainer");
            }
            if (newValues.containsKey("XmlPopupContainer")) {
                this.xmlPopupContainer = newValues.getProperty("XmlPopupContainer");
            }
            if (newValues.containsKey("XmlTail")) {
                this.xmlTail = newValues.getProperty("XmlTail");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Unable to work with ReportForYed.properties");
        }
    }

    protected String getXmlLinkContainer() {
        return this.xmlLinkContainer;
    }

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public void start(Gedcom gedcom) {
        List<Indi> indis = this.scope.getScope(gedcom, this);
        this.entity = gedcom.getDeCujusIndi();
        if (indis != null) {
            this.main(indis);
        }
    }

    public void start(Entity entity) {
        this.entity = entity;
        List<Indi> indis = this.scope.getScope(entity, this);
        if (indis != null) {
            this.main(indis);
        }
    }

    public void start(Indi[] indis) {
        if (indis.length == 0) {
            return;
        }
        this.entity = indis[0];
        this.main(Arrays.asList(indis));
    }

    public void main(List<Indi> scopedIndis) {
        ArrayList<Indi> filteredIndis = new ArrayList<Indi>();
        for (Indi indi : scopedIndis) {
            if (!this.filterOptions.matchRecord((Property)indi, indi.getName(), PropUtils.getStringFromIndi(indi))) continue;
            filteredIndis.add(indi);
        }
        Collections.sort(filteredIndis, (i1, i2) -> {
            Delta p2;
            if (i2 == null) {
                return -1;
            }
            if (i1 == null) {
                return 1;
            }
            Delta p1 = i1.getAge(pit);
            if (p1 == (p2 = i2.getAge(pit))) {
                return 0;
            }
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            return -p1.compareTo(p2);
        });
        HashSet<Fam> fams = new HashSet<Fam>();
        for (Indi indi : filteredIndis) {
            for (Fam fam : indi.getFamiliesWhereSpouse()) {
                if (!this.filterOptions.matchRecord((Property)fam, fam.getNames(), PropUtils.getStringFromFam(fam))) continue;
                fams.add(fam);
            }
            for (Fam fam : indi.getFamiliesWhereChild()) {
                boolean found = false;
                for (Indi sibling : fam.getChildren()) {
                    if (sibling == indi || !filteredIndis.contains(sibling)) continue;
                    found = true;
                    break;
                }
                if (!found || !this.filterOptions.matchRecord((Property)fam, fam.getNames(), PropUtils.getStringFromFam(fam))) continue;
                fams.add(fam);
            }
        }
        this.generateReport(filteredIndis, new ArrayList<Fam>(fams));
    }

    private void generateReport(List<Indi> indis, List<Fam> families) {
        this.setUserXmlContent(this.layout.resetLayout);
        this.loadUserXmlContent();
        this.indiRenderer = new BlueprintRenderer(this.layout.indiBlueprints[this.layout.indiBlueprint]);
        this.famRenderer = new BlueprintRenderer(this.layout.famBlueprints[this.layout.famBlueprint]);
        this.indiRenderer.prepareHTMLBlueprint();
        this.famRenderer.prepareHTMLBlueprint();
        this.println(this.scope.getMainMessage());
        for (String[] msg : this.scope.getMessages()) {
            this.println(msg[0] + ": " + msg[1]);
        }
        this.println(this.translate("inscope", new Object[]{indis.size(), families.size()}));
        this.println("\n");
        try (Writer out = this.createWriter();){
            if (out == null) {
                this.println(this.translate("aborted"));
                this.println("\n");
                return;
            }
            this.println(this.translate("creating", new Object[]{this.reportFile.getAbsoluteFile()}));
            this.println("\n");
            String title = this.translate("instructions");
            Object instructions = this.translate("instructions.text", new Object[]{this.reportFile.getAbsoluteFile(), this.gender.getFamilyColor(), this.gender.getColors(1), this.gender.getColors(2)});
            int w = 80;
            this.println("-".repeat(w));
            this.println(title);
            this.println("-".repeat(w));
            this.println(instructions);
            this.println("-".repeat(w));
            this.println("\n");
            out.write(this.xmlHead + "\n");
            for (Indi indi : indis) {
                this.println(this.translate("exportingindividual", new Object[]{indi}));
                out.write(this.createNode(indi) + "\n");
            }
            this.println("\n");
            for (Fam fam : families) {
                this.println(this.translate("exportingfamily", new Object[]{fam}));
                out.write(this.createNode(fam) + "\n");
            }
            for (Indi indi : indis) {
                out.write(this.createSpouseEdges(indi, families) + "\n");
                out.write(this.createParentsEdges(indi, families) + "\n");
            }
            out.write(this.xmlTail + "\n");
            out.flush();
            if (this.layout.displayInstructions) {
                instructions = (String)instructions + "<br><br>" + this.translate("instructions.note");
                instructions = "<html>" + ((String)instructions).replaceAll("\\n", "<br>").replaceAll("<br>-", "<br>&nbsp;&nbsp;&nbsp;&bull;").replaceAll("(#[0-9a-f]{6})\\s", "<b>$1</b><span color=$1>&nbsp;\u2588&nbsp;</span>") + "</html>";
                DialogManager.create((String)title, (JComponent)new TextLabelPanel((String)instructions), (boolean)false).setMessageType(1).setDialogId(((Object)((Object)this)).getClass()).setOptionType(10).show();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.println("\n");
        this.println(this.translate("ready"));
        this.println("\n");
    }

    private String createNode(Indi indi) {
        String id = indi.getId();
        String label = this.createLabel(indi);
        return MessageFormat.format(this.xmlIndi, id, this.escape(label), this.links.format(id, this.links.indi), this.gender.getColors(indi.getSex()), this.createPopUpContainer(label));
    }

    private String createNode(Fam family) {
        String id = family.getId();
        String label = this.createLabel(family);
        return MessageFormat.format(this.xmlFamily, id, this.escape(label), this.links.format(id, this.links.family), this.gender.getFamilyColor(), this.createPopUpContainer(label));
    }

    private String createLabel(Indi indi) {
        if (this.layout.useBlueprints) {
            return this.indiRenderer.renderHTML((Property)indi, 0, this.images.maxHeightIndi, this.reportFile.getParentFile());
        }
        String id = indi.getId();
        String image = this.images.format((Entity)indi, this.reportFile.getParentFile());
        String sex = this.gender.format(indi);
        String name = indi.getPropertyDisplayValue("NAME");
        String occu = indi.getPropertyDisplayValue("OCCU");
        Property naiss = indi.getProperty("BIRT");
        if (naiss == null && TextOptions.getInstance().isUseChr()) {
            naiss = indi.getProperty("CHR");
        }
        String birth = this.events.format(TEXT_OPTIONS.getBirthSymbol(), (PropertyEvent)naiss);
        Property mort = indi.getProperty("DEAT");
        if (mort == null && TextOptions.getInstance().isUseBuri()) {
            mort = indi.getProperty("BURI");
        }
        String death = this.events.format(TEXT_OPTIONS.getDeathSymbol(), (PropertyEvent)mort);
        StringBuilder sb = new StringBuilder();
        if (image != null) {
            sb.append("<html><body><table><tr><td>");
        } else {
            sb.append("<html><body>");
        }
        if (!sex.equals("")) {
            sb.append("{5}");
        }
        sb.append("<p>{6} - {0}");
        if (!birth.equals("") || !death.equals("")) {
            sb.append("<br>{1}<br>{2}");
        }
        if (this.events.showOccupation && occu != null && !occu.trim().equals("")) {
            sb.append("<br>{3}");
        }
        if (image != null) {
            sb.append("</p></td><td>{4}</td></tr></table></body></html>");
        } else {
            sb.append("</p></body></html>");
        }
        return this.wrap(sb.toString(), name, birth, death, occu, image, sex, id);
    }

    private String createLabel(Fam family) {
        if (this.layout.useBlueprints) {
            return this.famRenderer.renderHTML((Property)family, 0, this.images.maxHeightFam, this.reportFile.getParentFile());
        }
        String id = family.getId();
        String image = this.images.format((Entity)family, this.reportFile.getParentFile());
        String mariage = this.events.format(TEXT_OPTIONS.getMarriageSymbol(), (PropertyEvent)family.getProperty("MARR"));
        String divorce = this.events.format(TEXT_OPTIONS.getDivorceSymbol(), (PropertyEvent)family.getProperty("DIV"));
        String format = image != null ? "<html><table><tr><td><p>{0}<br>{1}<br>{2}</p></td><td>{3}</td></tr></table></body></html>" : (divorce.equals("") && mariage.equals("") ? "{0}" : (divorce.equals("") || mariage.equals("") ? "<html>{0}<br>{1}{2}</html>" : "<html><body>{0}<br>{1}<br>{2}</body></html>"));
        return this.wrap(format, id, mariage, divorce, image);
    }

    private String createSpouseEdges(Indi indi, Collection<Fam> families) {
        Object s = "";
        for (Fam fam : indi.getFamiliesWhereSpouse()) {
            if (!families.contains(fam)) continue;
            s = (String)s + MessageFormat.format(this.xmlEdge, this.edgeCount++, indi.getId(), fam.getId());
        }
        return s;
    }

    private String createParentsEdges(Indi indi, Collection<Fam> families) {
        Object s = "";
        for (Fam fam : indi.getFamiliesWhereChild()) {
            if (!families.contains(fam)) continue;
            s = (String)s + MessageFormat.format(this.xmlEdge, this.edgeCount++, fam.getId(), indi.getId());
        }
        return s;
    }

    private String wrap(String format, Object ... args) {
        return MessageFormat.format(format, args).replaceAll("'", "\"");
    }

    private String escape(String content) {
        return content.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }

    private String createPopUpContainer(String content) {
        if (content == null) {
            return "";
        }
        return MessageFormat.format(this.xmlPopupContainer, content);
    }

    private String getString(String key) {
        return this.getResources().getString(key);
    }

    private Writer createWriter() throws FileNotFoundException {
        String extension = "graphml";
        String filename = "yEd";
        if (this.entity != null) {
            String name = this.entity.getDisplayTitle();
            filename = Utilities.removeDiacriticsUnderscore((String)name).replaceAll("_$", "");
        }
        this.reportFile = this.getFileFromUser(this.translate("name"), this.translate("save"), true, "graphml", filename);
        if (this.reportFile == null) {
            return null;
        }
        if (!this.reportFile.getName().toLowerCase().endsWith(".graphml")) {
            this.reportFile = new File(this.reportFile.getPath() + ".graphml");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.reportFile);
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF8"));
        return new BufferedWriter(streamWriter);
    }
}

