/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.utils;

import ancestris.renderer.GradientExtensionHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgUtils {
    public static final Charset SVG_CHARSET = Charset.forName("UTF-8");
    public static final String SVG_NAME_SPACE = "http://www.w3.org/2000/svg";

    public static SVGGraphics2D createSvgGenerator() {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(SVG_NAME_SPACE, "svg", null);
        SVGGeneratorContext svgGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
        svgGeneratorContext.setComment("Generated by Ancestris with Batik SVG Generator");
        svgGeneratorContext.setExtensionHandler((ExtensionHandler)new GradientExtensionHandler());
        SVGGraphics2D svgGenerator = new SVGGraphics2D(svgGeneratorContext, false);
        return svgGenerator;
    }

    public static Element drawTextOnPath(Document doc, Element path, double offset, boolean usePercent, String id, String value, Color fontColor, int fontSize) {
        Element group = doc.createElementNS(SVG_NAME_SPACE, "g");
        path.setAttribute("id", id);
        group.appendChild(path);
        Element pathText = doc.createElement("textPath");
        pathText.setAttribute("xlink:href", "#" + id);
        double currentOffset = offset < 0.0 ? 2.0 : offset;
        Object displayOffset = String.valueOf(currentOffset);
        if (usePercent) {
            displayOffset = (String)displayOffset + "%";
        }
        pathText.setAttribute("startOffset", (String)displayOffset);
        pathText.setTextContent(value);
        Element text = doc.createElement("text");
        text.setAttribute("stroke", "none");
        text.setAttribute("fill", String.format("#%06x", fontColor.getRGB() & 0xFFFFFF));
        text.setAttribute("dominant-baseline", "middle");
        if (fontSize > 0) {
            text.setAttribute("font-size", String.valueOf(fontSize));
        }
        text.appendChild(pathText);
        group.appendChild(text);
        return group;
    }

    public static Rectangle2D getTextSize(String text, Font font) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        return font.getStringBounds(text, fontRenderContext);
    }

    public static String getText(String label, Font font, int width) {
        String ret = label;
        for (int len = label.length(); len > 0 && !(SvgUtils.getTextSize(ret = label.substring(0, len), font).getWidth() < (double)width); --len) {
        }
        return ret;
    }

    public static PrintWriter getWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(out, SVG_CHARSET));
    }
}

