/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFAttribute;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFAttributes
implements GEXFElement,
AttributeSink {
    GEXF root;
    GEXFElement.ClassType type;
    GEXFElement.Mode mode;
    HashMap<String, GEXFAttribute> attributes;

    public GEXFAttributes(GEXF root, GEXFElement.ClassType type) {
        this.root = root;
        this.type = type;
        this.mode = GEXFElement.Mode.STATIC;
        this.attributes = new HashMap();
        root.addAttributeSink(this);
    }

    protected void checkAttribute(String key, Object value) {
        GEXFElement.AttrType type = this.detectType(value);
        if (!this.attributes.containsKey(key)) {
            this.attributes.put(key, new GEXFAttribute(this.root, key, type));
        } else {
            GEXFAttribute a = this.attributes.get(key);
            if (a.type != type && value != null) {
                a.type = GEXFElement.AttrType.STRING;
            }
        }
    }

    protected GEXFElement.AttrType detectType(Object value) {
        if (value == null) {
            return GEXFElement.AttrType.STRING;
        }
        if (value instanceof Integer || value instanceof Short) {
            return GEXFElement.AttrType.INTEGER;
        }
        if (value instanceof Long) {
            return GEXFElement.AttrType.LONG;
        }
        if (value instanceof Float) {
            return GEXFElement.AttrType.FLOAT;
        }
        if (value instanceof Double) {
            return GEXFElement.AttrType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return GEXFElement.AttrType.BOOLEAN;
        }
        if (value instanceof URL || value instanceof URI) {
            return GEXFElement.AttrType.ANYURI;
        }
        if (value.getClass().isArray() || value instanceof Collection) {
            return GEXFElement.AttrType.LISTSTRING;
        }
        return GEXFElement.AttrType.STRING;
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        if (this.attributes.size() == 0) {
            return;
        }
        stream.startElement("attributes");
        stream.stream.writeAttribute("class", this.type.qname);
        for (GEXFAttribute attribute : this.attributes.values()) {
            attribute.export(stream);
        }
        stream.endElement();
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        if (this.type == GEXFElement.ClassType.NODE) {
            this.checkAttribute(attribute, value);
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.type == GEXFElement.ClassType.NODE) {
            this.checkAttribute(attribute, newValue);
        }
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (this.type == GEXFElement.ClassType.EDGE) {
            this.checkAttribute(attribute, value);
        }
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.type == GEXFElement.ClassType.EDGE) {
            this.checkAttribute(attribute, newValue);
        }
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
    }
}

