/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordMarriage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ReleveStatistic
extends JFrame {
    private final TreeMap<Integer, int[]> datas = new TreeMap();
    private final String[] columnNames = new String[]{NbBundle.getMessage(this.getClass(), (String)"ReleveStatistic.columnTitle.year"), NbBundle.getMessage(this.getClass(), (String)"ReleveStatistic.columnTitle.births"), NbBundle.getMessage(this.getClass(), (String)"ReleveStatistic.columnTitle.marriages"), NbBundle.getMessage(this.getClass(), (String)"ReleveStatistic.columnTitle.deaths"), NbBundle.getMessage(this.getClass(), (String)"ReleveStatistic.columnTitle.misc"), NbBundle.getMessage(this.getClass(), (String)"ReleveStatistic.columnTitle.all")};
    private static final String LINE_BREAK = "\n";
    private static final String CELL_BREAK = "\t";
    private JButton jButton1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public static void showStatistics(DataManager dataManager) {
        ReleveStatistic statistics = new ReleveStatistic();
        statistics.setVisible(true);
        statistics.setModel(dataManager);
    }

    public ReleveStatistic() {
        this.initComponents();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Releve.png"));
        this.setIconImage(icon.getImage());
        this.setTitle(NbBundle.getMessage(this.getClass(), (String)"ReleveTopComponent.menu.statistics.title"));
    }

    public void setModel(DataManager dataManager) {
        int i;
        int[] total = new int[5];
        if (dataManager != null) {
            int nbRecord = dataManager.getDataModel().getRowCount();
            for (i = 0; i < nbRecord; ++i) {
                int index;
                AbstractRecord record = dataManager.getDataModel().getRecord(i);
                String value = record.getFieldValue(AbstractRecord.FieldType.eventDate);
                int year = value.isEmpty() ? 0 : ((index = value.lastIndexOf("/")) == -1 ? Integer.parseInt(value) : Integer.parseInt(value.substring(index + 1)));
                int[] counters = this.datas.get(year);
                if (counters == null) {
                    counters = new int[5];
                    this.datas.put(year, counters);
                }
                counters[0] = year;
                if (record instanceof RecordBirth) {
                    counters[1] = counters[1] + 1;
                    total[1] = total[1] + 1;
                    continue;
                }
                if (record instanceof RecordMarriage) {
                    counters[2] = counters[2] + 1;
                    total[2] = total[2] + 1;
                    continue;
                }
                if (record instanceof RecordDeath) {
                    counters[3] = counters[3] + 1;
                    total[3] = total[3] + 1;
                    continue;
                }
                counters[4] = counters[4] + 1;
                total[4] = total[4] + 1;
            }
        }
        Object[][] data2 = new Object[this.datas.size() + 1][6];
        i = 0;
        for (int[] counters : this.datas.values()) {
            data2[i][0] = counters[0];
            data2[i][1] = counters[1];
            data2[i][2] = counters[2];
            data2[i][3] = counters[3];
            data2[i][4] = counters[4];
            data2[i][5] = counters[1] + counters[2] + counters[3] + counters[4];
            ++i;
        }
        data2[i][0] = "Total";
        data2[i][1] = total[1];
        data2[i][2] = total[2];
        data2[i][3] = total[3];
        data2[i][4] = total[4];
        data2[i][5] = total[1] + total[2] + total[3] + total[4];
        this.jTable1.setModel(new DefaultTableModel(data2, this.columnNames));
    }

    private void copyToClipboard() {
        Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
        int numCols = this.jTable1.getColumnCount();
        int numRows = this.jTable1.getRowCount();
        StringBuilder excelStr = new StringBuilder();
        for (int j = 0; j < numCols; ++j) {
            excelStr.append(this.columnNames[j]);
            if (j >= numCols - 1) continue;
            excelStr.append(CELL_BREAK);
        }
        excelStr.append(LINE_BREAK);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                excelStr.append(this.escape(this.jTable1.getValueAt(i, j)));
                if (j >= numCols - 1) continue;
                excelStr.append(CELL_BREAK);
            }
            excelStr.append(LINE_BREAK);
        }
        StringSelection sel = new StringSelection(excelStr.toString());
        CLIPBOARD.setContents(sel, sel);
    }

    private String escape(Object cell) {
        return cell.toString().replace(LINE_BREAK, " ").replace(CELL_BREAK, " ");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setMaximumSize(null);
        this.jTable1.setMinimumSize(null);
        this.jTable1.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jButton1.setText(NbBundle.getMessage(ReleveStatistic.class, (String)"ReleveStatistic.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveStatistic.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.copyToClipboard();
    }
}

