/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.dnd.TransferableRecord;
import ancestris.modules.releve.merge.MergeDialog;
import ancestris.modules.releve.merge.MergeInfo;
import ancestris.modules.releve.merge.MergeLogger;
import ancestris.modules.releve.merge.MergeQuery;
import ancestris.modules.releve.merge.MergeRecord;
import ancestris.modules.releve.merge.MergeTableAction;
import ancestris.modules.releve.merge.Proposal;
import ancestris.modules.releve.merge.ProposalHelper;
import ancestris.modules.releve.merge.SelectionManager;
import ancestris.modules.releve.merge.SpouseFamily;
import ancestris.modules.releve.merge.SpouseTag;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractListModel;
import org.openide.util.NbPreferences;

public class MergeManager {
    private final MergeRecord m_mergeRecord;
    private final Gedcom m_gedcom;
    private final Entity m_selectedEntity;
    private static boolean m_showAllParents = Boolean.parseBoolean(NbPreferences.forModule(MergeDialog.class).get("MergeDialogShowAllParents", "true"));
    private final ProposalList m_mergeModelList1 = new ProposalList(false);
    private final ProposalList m_mergeModelList2 = new ProposalList(true);
    protected boolean m_showFrenchCalendarDate = true;
    protected final ProposalHelper m_helper;
    static String m_cName = MergeManager.class.getName();

    public MergeManager(TransferableRecord.TransferableData transferableData, Gedcom gedcom, Entity selectedEntity) {
        this.m_mergeRecord = new MergeRecord(transferableData);
        this.m_gedcom = gedcom;
        this.m_selectedEntity = selectedEntity;
        this.m_helper = new ProposalHelper(this.m_mergeRecord, selectedEntity, gedcom);
        this.m_mergeModelList1.showAllProposal(selectedEntity == null);
    }

    public void createProposals() throws Exception {
        this.m_mergeModelList1.clear();
        this.m_mergeModelList2.clear();
        if (null != this.m_mergeRecord.getRecordType()) {
            block0 : switch (this.m_mergeRecord.getRecordType()) {
                case BIRTH: {
                    this.createProposalBirth();
                    break;
                }
                case MARRIAGE: {
                    this.createProposalMarriage();
                    break;
                }
                case DEATH: {
                    this.createProposalDeath();
                    break;
                }
                case MISC: {
                    switch (this.m_mergeRecord.getEventTypeTag()) {
                        case "MARB": 
                        case "MARC": 
                        case "MARL": {
                            this.createProposalMiscMarc();
                            break block0;
                        }
                        case "WILL": {
                            this.createProposalMiscWill();
                            break block0;
                        }
                    }
                    this.createProposalMiscOther();
                    break;
                }
            }
        }
        this.m_mergeModelList1.sort();
        this.m_mergeModelList2.sort();
        for (Proposal proposal : this.m_mergeModelList1.m_list) {
            this.m_helper.getSourceAction().addSourceListener(proposal.getRuleSource());
            for (MergeTableAction.WitnessRecordSelection witnessSelection : this.m_helper.getWitnessActions()) {
                witnessSelection.addWitnessListener(proposal.getRuleWitness(witnessSelection.m_recordWitness));
            }
        }
    }

    private void createProposalBirth() throws Exception {
        ProposalList proposals = this.m_mergeModelList1;
        MergeRecord.RecordParticipant participant = this.m_helper.getRecord().getIndi();
        if (this.m_selectedEntity instanceof Fam) {
            Fam selectedFamily = (Fam)this.m_selectedEntity;
            List<Indi> sameChildren = MergeQuery.findSameChild(this.m_mergeRecord, this.m_gedcom, selectedFamily);
            for (Indi indi : sameChildren) {
                proposals.add(new Proposal(this.m_helper, indi, indi.getFamilyWhereBiologicalChild(), null, null));
            }
        } else if (this.m_selectedEntity instanceof Indi) {
            Indi selectedIndi = (Indi)this.m_selectedEntity;
            proposals.add(new Proposal(this.m_helper, selectedIndi, null, null, null));
            List<Fam> families = MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, participant, this.m_gedcom);
            for (Fam fam : families) {
                proposals.add(new Proposal(this.m_helper, selectedIndi, fam, null, null));
            }
            List<Indi> sameIndis = selectedIndi.getFamilyWhereBiologicalChild() != null ? MergeQuery.findIndiCompatibleWithParticipant(this.m_mergeRecord, participant, this.m_gedcom, selectedIndi) : MergeQuery.findIndiCompatibleWithParticipant(this.m_mergeRecord, participant, this.m_gedcom, null);
            for (Indi sameIndi : sameIndis) {
                Fam sameIndiFamily = sameIndi.getFamilyWhereBiologicalChild();
                if (sameIndiFamily != null) {
                    proposals.add(new Proposal(this.m_helper, sameIndi, sameIndiFamily, null, null));
                    continue;
                }
                for (Fam family : families) {
                    proposals.add(new Proposal(this.m_helper, sameIndi, family, null, null));
                }
            }
        }
        proposals.add(new Proposal(this.m_helper, null, null, null, null));
        List<Indi> sameIndis = MergeQuery.findIndiCompatibleWithParticipant(this.m_mergeRecord, participant, this.m_gedcom, null);
        List<Fam> parentFamilies = MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, participant, this.m_gedcom);
        for (Fam fam : parentFamilies) {
            proposals.add(new Proposal(this.m_helper, null, fam, null, null));
        }
        for (Indi indi : sameIndis) {
            Fam sameIndiFamily = indi.getFamilyWhereBiologicalChild();
            if (sameIndiFamily != null) {
                proposals.add(new Proposal(this.m_helper, indi, sameIndiFamily, null, null));
                continue;
            }
            proposals.add(new Proposal(this.m_helper, indi, null, null, null));
            if (MergeLogger.LOG.isLoggable(MergeLogger.ACCEPT)) {
                MergeLogger.LOG.log(MergeLogger.getAccept("sameIndi %s without family", indi));
            }
            for (Fam parentFamily : parentFamilies) {
                proposals.add(new Proposal(this.m_helper, indi, parentFamily, null, null));
            }
        }
        if (m_showAllParents) {
            ArrayList<Indi> fathers = new ArrayList<Indi>();
            ArrayList<Indi> arrayList = new ArrayList<Indi>();
            MergeQuery.findFatherMotherCompatibleWithBirthParticipant(this.m_mergeRecord, this.m_gedcom, parentFamilies, fathers, arrayList);
            for (Indi father : fathers) {
                for (Indi mother : arrayList) {
                    proposals.add(new Proposal(this.m_helper, null, null, father, mother));
                }
            }
        }
    }

    void createProposalDeath() throws Exception {
        ProposalList models = this.m_mergeModelList1;
        MergeRecord.RecordParticipant participant = this.m_helper.getRecord().getIndi();
        if (this.m_selectedEntity instanceof Fam) {
            Fam selectedFamily = (Fam)this.m_selectedEntity;
            List<Indi> sameChildren = MergeQuery.findSameChild(this.m_mergeRecord, this.m_gedcom, selectedFamily);
            for (Indi sameIndi : sameChildren) {
                models.add(new Proposal(this.m_helper, sameIndi, sameIndi.getFamilyWhereBiologicalChild(), null, null));
            }
            this.addIndiWithSpouseFamily(participant, null, models);
        } else {
            this.addIndiWithSpouseFamily(participant, (Indi)this.m_selectedEntity, models);
        }
    }

    void createProposalMarriage() throws Exception {
        ProposalList models = this.m_mergeModelList1;
        if (this.m_selectedEntity instanceof Fam) {
            selectedFamily = (Fam)this.m_selectedEntity;
            models.add(new Proposal(this.m_helper, (Fam)selectedFamily, null, null, null, null, null, null, null, null));
        } else {
            selectedFamily = this.m_selectedEntity;
            if (selectedFamily instanceof Indi) {
                Indi selectedIndi = (Indi)selectedFamily;
                Fam[] families = selectedIndi.getFamiliesWhereSpouse();
                for (Fam family : families) {
                    models.add(new Proposal(this.m_helper, family, null, null, null, null, null, null, null, null));
                }
                if (m_showAllParents) {
                    ArrayList<Indi> husbands = new ArrayList<Indi>();
                    ArrayList<Indi> wifes = new ArrayList<Indi>();
                    if (selectedIndi.getSex() == 1 || selectedIndi.getSex() == 0) {
                        models.add(new Proposal(this.m_helper, null, selectedIndi, null, null, null, null, null, null, null));
                        husbands.add(selectedIndi);
                    } else {
                        models.add(new Proposal(this.m_helper, null, null, null, null, null, selectedIndi, null, null, null));
                        wifes.add(selectedIndi);
                    }
                    MergeQuery.findHusbanWifeCompatibleWithMarriageRecord(this.m_mergeRecord, this.m_gedcom, Arrays.asList(families), husbands, wifes);
                    for (Indi husband : husbands) {
                        for (Indi wife : wifes) {
                            models.add(new Proposal(this.m_helper, null, husband, null, null, null, wife, null, null, null));
                        }
                    }
                }
            }
        }
        models.add(new Proposal(this.m_helper, null, null, null, null, null, null, null, null, null));
        List<Fam> families = MergeQuery.findFamilyCompatibleWithMarriageRecord(this.m_mergeRecord, this.m_gedcom, null);
        for (Fam family : families) {
            models.add(new Proposal(this.m_helper, family, null, null, null, null, null, null, null, null));
        }
        ArrayList<Indi> husbands = new ArrayList<Indi>();
        ArrayList<Indi> wifes = new ArrayList<Indi>();
        MergeQuery.findHusbanWifeCompatibleWithMarriageRecord(this.m_mergeRecord, this.m_gedcom, families, husbands, wifes);
        for (Indi husband : husbands) {
            for (Indi wife : wifes) {
                models.add(new Proposal(this.m_helper, null, husband, null, null, null, wife, null, null, null));
            }
            models.add(new Proposal(this.m_helper, null, husband, null, null, null, null, null, null, null));
        }
        for (Indi wife : wifes) {
            models.add(new Proposal(this.m_helper, null, null, null, null, null, wife, null, null, null));
        }
        if (m_showAllParents || !m_showAllParents && !this.m_mergeRecord.getIndi().getFather().getFirstName().isEmpty() && !this.m_mergeRecord.getIndi().getMother().getFirstName().isEmpty() && !this.m_mergeRecord.getIndi().getMother().getLastName().isEmpty()) {
            Indi[] children;
            ArrayList<Fam> husbandFamilies = new ArrayList<Fam>();
            ArrayList<Fam> wifeFamilies = new ArrayList<Fam>();
            for (Fam husbandFamily : MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, this.m_helper.getRecord().getIndi(), this.m_gedcom)) {
                children = husbandFamily.getChildren();
                boolean foundHusband = false;
                for (Indi children1 : children) {
                    if (husbands.contains(children1)) {
                        foundHusband = true;
                    }
                    for (Fam family : families) {
                        if (family.getHusband() == null || !family.getHusband().equals(children1)) continue;
                        foundHusband = true;
                    }
                }
                if (foundHusband) continue;
                husbandFamilies.add(husbandFamily);
            }
            for (Fam wifeFamily : MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, this.m_helper.getRecord().getWife(), this.m_gedcom)) {
                children = wifeFamily.getChildren();
                boolean foundWife = false;
                for (Indi children1 : children) {
                    if (wifes.contains(children1)) {
                        foundWife = true;
                    }
                    for (Fam family : families) {
                        if (family.getWife() == null || !family.getWife().equals(children1)) continue;
                        foundWife = true;
                    }
                }
                if (foundWife) continue;
                wifeFamilies.add(wifeFamily);
            }
            for (Fam husbandFamily : husbandFamilies) {
                for (Fam wifeFamily : wifeFamilies) {
                    models.add(new Proposal(this.m_helper, null, null, husbandFamily, null, null, null, wifeFamily, null, null));
                }
                models.add(new Proposal(this.m_helper, null, null, husbandFamily, null, null, null, null, null, null));
            }
            for (Fam wifeFamily : wifeFamilies) {
                models.add(new Proposal(this.m_helper, null, null, null, null, null, null, wifeFamily, null, null));
            }
            for (Indi husband : husbands) {
                for (Fam wifeFamily : wifeFamilies) {
                    models.add(new Proposal(this.m_helper, null, husband, null, null, null, null, wifeFamily, null, null));
                }
            }
            for (Indi wife : wifes) {
                for (Fam husbandFamily : husbandFamilies) {
                    models.add(new Proposal(this.m_helper, null, null, husbandFamily, null, null, wife, null, null, null));
                }
            }
        }
    }

    private void createProposalMiscMarc() throws Exception {
        block26: {
            ProposalList models;
            block27: {
                Fam[] families;
                block25: {
                    models = this.m_mergeModelList1;
                    if (!(this.m_selectedEntity instanceof Fam)) break block25;
                    Fam selectedFamily = (Fam)this.m_selectedEntity;
                    models.add(new Proposal(this.m_helper, selectedFamily, null, null, null, null, null, null, null, null));
                    break block26;
                }
                if (!(this.m_selectedEntity instanceof Indi)) break block27;
                Indi selectedIndi = (Indi)this.m_selectedEntity;
                for (Fam family : families = selectedIndi.getFamiliesWhereSpouse()) {
                    models.add(new Proposal(this.m_helper, family, null, null, null, null, null, null, null, null));
                }
                if (!m_showAllParents) break block26;
                ArrayList<Indi> husbands = new ArrayList<Indi>();
                ArrayList<Indi> wifes = new ArrayList<Indi>();
                if (selectedIndi.getSex() == 1 || selectedIndi.getSex() == 0) {
                    models.add(new Proposal(this.m_helper, null, selectedIndi, null, null, null, null, null, null, null));
                    husbands.add(selectedIndi);
                } else {
                    models.add(new Proposal(this.m_helper, null, null, null, null, null, selectedIndi, null, null, null));
                    wifes.add(selectedIndi);
                }
                MergeQuery.findHusbanWifeCompatibleWithMarriageRecord(this.m_mergeRecord, this.m_gedcom, Arrays.asList(families), husbands, wifes);
                for (Indi husband : husbands) {
                    for (Indi wife : wifes) {
                        models.add(new Proposal(this.m_helper, null, husband, null, null, null, wife, null, null, null));
                    }
                }
                break block26;
            }
            models.add(new Proposal(this.m_helper, null, null, null, null, null, null, null, null, null));
            List<Fam> families = MergeQuery.findFamilyCompatibleWithMarriageRecord(this.m_mergeRecord, this.m_gedcom, null);
            for (Fam family : families) {
                models.add(new Proposal(this.m_helper, family, null, null, null, null, null, null, null, null));
            }
            ArrayList<Indi> husbands = new ArrayList<Indi>();
            ArrayList<Indi> wifes = new ArrayList<Indi>();
            MergeQuery.findHusbanWifeCompatibleWithMarriageRecord(this.m_mergeRecord, this.m_gedcom, families, husbands, wifes);
            for (Indi husband : husbands) {
                for (Indi wife : wifes) {
                    models.add(new Proposal(this.m_helper, null, husband, null, null, null, wife, null, null, null));
                }
                models.add(new Proposal(this.m_helper, null, husband, null, null, null, null, null, null, null));
            }
            for (Indi wife : wifes) {
                models.add(new Proposal(this.m_helper, null, null, null, null, null, wife, null, null, null));
            }
            if (m_showAllParents || m_showAllParents && !this.m_mergeRecord.getIndi().getFather().getFirstName().isEmpty() && !this.m_mergeRecord.getIndi().getMother().getFirstName().isEmpty() && !this.m_mergeRecord.getIndi().getMother().getLastName().isEmpty()) {
                Indi[] children;
                ArrayList<Fam> husbandFamilies = new ArrayList<Fam>();
                ArrayList<Fam> wifeFamilies = new ArrayList<Fam>();
                for (Fam husbandFamily : MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, this.m_helper.getRecord().getIndi(), this.m_gedcom)) {
                    children = husbandFamily.getChildren();
                    boolean foundHusband = false;
                    for (Indi children1 : children) {
                        if (husbands.contains(children1)) {
                            foundHusband = true;
                        }
                        for (Fam family : families) {
                            if (family.getHusband() == null || !family.getHusband().equals(children1)) continue;
                            foundHusband = true;
                        }
                    }
                    if (foundHusband) continue;
                    husbandFamilies.add(husbandFamily);
                }
                for (Fam wifeFamily : MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, this.m_helper.getRecord().getWife(), this.m_gedcom)) {
                    children = wifeFamily.getChildren();
                    boolean foundWife = false;
                    for (Indi children1 : children) {
                        if (wifes.contains(children1)) {
                            foundWife = true;
                        }
                        for (Fam family : families) {
                            if (family.getWife() == null || !family.getWife().equals(children1)) continue;
                            foundWife = true;
                        }
                    }
                    if (foundWife) continue;
                    wifeFamilies.add(wifeFamily);
                }
                for (Fam husbandFamily : husbandFamilies) {
                    for (Fam wifeFamily : wifeFamilies) {
                        models.add(new Proposal(this.m_helper, null, null, husbandFamily, null, null, null, wifeFamily, null, null));
                    }
                    models.add(new Proposal(this.m_helper, null, null, husbandFamily, null, null, null, null, null, null));
                }
                for (Fam wifeFamily : wifeFamilies) {
                    models.add(new Proposal(this.m_helper, null, null, null, null, null, null, wifeFamily, null, null));
                }
                for (Indi husband : husbands) {
                    for (Fam wifeFamily : wifeFamilies) {
                        models.add(new Proposal(this.m_helper, null, husband, null, null, null, null, wifeFamily, null, null));
                    }
                }
                for (Indi wife : wifes) {
                    for (Fam husbandFamily : husbandFamilies) {
                        models.add(new Proposal(this.m_helper, null, null, husbandFamily, null, null, wife, null, null, null));
                    }
                }
            }
        }
    }

    private void createProposalMiscOther() throws Exception {
        ProposalList models = this.m_mergeModelList1;
        Entity entity = this.m_selectedEntity;
        if (entity instanceof Fam) {
            Fam selectedParentFamily = (Fam)entity;
            participant = this.m_helper.getRecord().getIndi();
            SpouseTag tag = participant.getSex() == 2 ? SpouseTag.WIFE : SpouseTag.HUSB;
            List<Indi> sameChildren = MergeQuery.findSameChild(this.m_mergeRecord, this.m_gedcom, selectedParentFamily);
            for (Indi samedIndi : sameChildren) {
                models.add(new Proposal(this.m_helper, participant, samedIndi, null, tag, samedIndi.getFamilyWhereBiologicalChild(), null, null));
            }
            this.addIndiWithSpouseFamily(participant, null, models);
        } else {
            participant = this.m_helper.getRecord().getParticipant(MergeRecord.MergeParticipantType.participant1);
            this.addIndiWithSpouseFamily(participant, (Indi)this.m_selectedEntity, models);
        }
        ProposalList models2 = this.m_mergeModelList2;
        if (MergeLogger.LOG.isLoggable(Level.FINER)) {
            MergeLogger.LOG.logp(Level.FINER, m_cName, "createProposalMiscOther", "Participant 2 " + this.m_mergeRecord.getWife().getLastName() + " " + this.m_mergeRecord.getWife().getFirstName());
        }
        if (!this.m_mergeRecord.getWife().getLastName().isEmpty() || !this.m_mergeRecord.getWife().getFirstName().isEmpty()) {
            MergeRecord.RecordParticipant participant2 = this.m_helper.getRecord().getParticipant(MergeRecord.MergeParticipantType.participant2);
            this.addIndiWithSpouseFamily(participant2, null, models2);
        }
    }

    private void createProposalMiscWill() throws Exception {
        ProposalList models = this.m_mergeModelList1;
        MergeRecord.RecordParticipant participant = this.m_helper.getRecord().getIndi();
        if (this.m_selectedEntity instanceof Fam) {
            Fam selectedParentFamily = (Fam)this.m_selectedEntity;
            SpouseTag tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
            List<Indi> sameChildren = MergeQuery.findSameChild(this.m_mergeRecord, this.m_gedcom, selectedParentFamily);
            for (Indi samedIndi : sameChildren) {
                models.add(new Proposal(this.m_helper, samedIndi, null, tag, samedIndi.getFamilyWhereBiologicalChild(), null, null));
            }
            this.addIndiWithSpouseFamily(participant, null, models);
        } else {
            this.addIndiWithSpouseFamily(participant, (Indi)this.m_selectedEntity, models);
        }
    }

    /*
     * WARNING - void declaration
     */
    void addIndiWithSpouseFamily(MergeRecord.RecordParticipant participant, Indi selectedIndi, ProposalList models) throws Exception {
        block34: {
            List<Fam> parentFamilies;
            List<SpouseFamily> marriedFamilies;
            block33: {
                marriedFamilies = MergeQuery.findFamilyCompatibleWithParticipantMarried(this.m_mergeRecord, participant, this.m_gedcom);
                parentFamilies = MergeQuery.findFamilyCompatibleWithParticipantParents(this.m_mergeRecord, participant, this.m_gedcom);
                if (selectedIndi == null) break block33;
                if (!marriedFamilies.isEmpty()) {
                    for (SpouseFamily marriedFamily : marriedFamilies) {
                        Fam husbandParentFamily;
                        void var8_12;
                        if (marriedFamily.tag == SpouseTag.HUSB) {
                            Indi indi = marriedFamily.family.getHusband();
                        } else {
                            Indi indi = marriedFamily.family.getWife();
                        }
                        if (selectedIndi.compareTo((Property)var8_12) == 0) {
                            husbandParentFamily = var8_12.getFamilyWhereBiologicalChild();
                            models.add(new Proposal(this.m_helper, participant, (Indi)var8_12, marriedFamily.family, marriedFamily.tag, husbandParentFamily, null, null));
                            if (husbandParentFamily == null) {
                                for (Fam parentFamily : parentFamilies) {
                                    models.add(new Proposal(this.m_helper, participant, (Indi)var8_12, marriedFamily.family, marriedFamily.tag, parentFamily, null, null));
                                }
                            }
                        } else if (MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) {
                            MergeLogger.LOG.log(MergeLogger.getRefuse("husband %s different from selectedIndi %s", var8_12, selectedIndi));
                        }
                        if ((husbandParentFamily = var8_12.getFamilyWhereBiologicalChild()) != null) {
                            models.add(new Proposal(this.m_helper, participant, (Indi)var8_12, marriedFamily.family, marriedFamily.tag, husbandParentFamily, null, null));
                            continue;
                        }
                        models.add(new Proposal(this.m_helper, participant, (Indi)var8_12, marriedFamily.family, marriedFamily.tag, null, null, null));
                        for (Fam parentFamily : parentFamilies) {
                            models.add(new Proposal(this.m_helper, participant, (Indi)var8_12, marriedFamily.family, marriedFamily.tag, parentFamily, null, null));
                        }
                    }
                } else {
                    if (selectedIndi.getFamilyWhereBiologicalChild() != null) {
                        SpouseTag tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
                        models.add(new Proposal(this.m_helper, participant, selectedIndi, null, tag, selectedIndi.getFamilyWhereBiologicalChild(), null, null));
                    } else {
                        Fam[] selectedIndiFamilies = selectedIndi.getFamiliesWhereSpouse();
                        for (Fam fam : selectedIndiFamilies) {
                            if (MergeQuery.isRecordBeforeThanDate(fam.getMarriageDate(), this.m_mergeRecord.getIndi().getDeathDate(), 0, 0)) {
                                SpouseTag tag = selectedIndi == fam.getHusband() ? SpouseTag.HUSB : SpouseTag.WIFE;
                                models.add(new Proposal(this.m_helper, participant, selectedIndi, fam, tag, null, null, null));
                                if (this.m_mergeRecord.getIndi().getMarriedFamily().getMarried().getLastName().isEmpty() && this.m_mergeRecord.getIndi().getMarriedFamily().getMarried().getFirstName().isEmpty()) continue;
                                if (selectedIndi.equals(fam.getHusband())) {
                                    if (MergeQuery.isSameLastName(fam.getWife().getLastName(), this.m_mergeRecord.getIndi().getMarriedFamily().getMarried().getLastName()) && MergeQuery.isSameFirstName(fam.getWife().getFirstName(), this.m_mergeRecord.getIndi().getMarriedFamily().getMarried().getFirstName())) continue;
                                    tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
                                    models.add(new Proposal(this.m_helper, participant, selectedIndi, null, tag, null, null, null));
                                    continue;
                                }
                                if (MergeQuery.isSameLastName(fam.getHusband().getLastName(), this.m_mergeRecord.getIndi().getMarriedFamily().getMarried().getLastName()) && MergeQuery.isSameFirstName(fam.getHusband().getFirstName(), this.m_mergeRecord.getIndi().getMarriedFamily().getMarried().getFirstName())) continue;
                                tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
                                models.add(new Proposal(this.m_helper, participant, selectedIndi, null, tag, null, null, null));
                                continue;
                            }
                            if (!MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) continue;
                            MergeLogger.LOG.log(MergeLogger.getRefuse("selectedIndi %s marriage %s date %s must be before deathDate %s", selectedIndi, fam, fam.getMarriageDate().getValue(), this.m_mergeRecord.getIndi().getDeathDate().getValue()));
                        }
                        for (Fam fam : parentFamilies) {
                            SpouseTag tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
                            models.add(new Proposal(this.m_helper, participant, selectedIndi, null, tag, fam, null, null));
                        }
                    }
                    List<Indi> sameIndis = selectedIndi.getFamilyWhereBiologicalChild() != null ? MergeQuery.findIndiCompatibleWithParticipant(this.m_mergeRecord, participant, this.m_gedcom, selectedIndi) : MergeQuery.findIndiCompatibleWithParticipant(this.m_mergeRecord, participant, this.m_gedcom, null);
                    for (Indi indi : sameIndis) {
                        SpouseTag tag;
                        Fam sameIndiParentFamily = indi.getFamilyWhereBiologicalChild();
                        SpouseTag spouseTag = tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
                        if (sameIndiParentFamily != null) {
                            models.add(new Proposal(this.m_helper, participant, indi, null, tag, sameIndiParentFamily, null, null));
                            continue;
                        }
                        if (parentFamilies.size() > 0) {
                            for (Fam parentFamily : parentFamilies) {
                                models.add(new Proposal(this.m_helper, participant, indi, null, tag, parentFamily, null, null));
                            }
                            continue;
                        }
                        models.add(new Proposal(this.m_helper, participant, selectedIndi, null, tag, null, null, null));
                    }
                }
                break block34;
            }
            SpouseTag tag = participant.getSex() == 1 ? SpouseTag.HUSB : SpouseTag.WIFE;
            models.add(new Proposal(this.m_helper, participant, null, null, tag, null, null, null));
            if (!marriedFamilies.isEmpty()) {
                for (SpouseFamily spouseFamily : marriedFamilies) {
                    Indi indi = spouseFamily.tag == SpouseTag.HUSB ? spouseFamily.family.getHusband() : spouseFamily.family.getWife();
                    Fam husbandParentFamily = indi.getFamilyWhereBiologicalChild();
                    if (husbandParentFamily != null) {
                        models.add(new Proposal(this.m_helper, participant, indi, spouseFamily.family, spouseFamily.tag, husbandParentFamily, null, null));
                        continue;
                    }
                    models.add(new Proposal(this.m_helper, participant, indi, spouseFamily.family, spouseFamily.tag, null, null, null));
                    for (Fam parentFamily : parentFamilies) {
                        models.add(new Proposal(this.m_helper, participant, indi, spouseFamily.family, spouseFamily.tag, parentFamily, null, null));
                    }
                }
            } else {
                for (Fam fam : parentFamilies) {
                    models.add(new Proposal(this.m_helper, participant, null, null, tag, fam, null, null));
                }
                List<Indi> sameIndis = MergeQuery.findIndiCompatibleWithParticipant(this.m_mergeRecord, participant, this.m_gedcom, null);
                for (Indi sameIndi : sameIndis) {
                    Fam sameIndiParentFamily = sameIndi.getFamilyWhereBiologicalChild();
                    if (sameIndiParentFamily != null) {
                        models.add(new Proposal(this.m_helper, participant, sameIndi, null, tag, sameIndiParentFamily, null, null));
                        continue;
                    }
                    models.add(new Proposal(this.m_helper, participant, sameIndi, null, tag, null, null, null));
                    for (Fam parentFamily : parentFamilies) {
                        models.add(new Proposal(this.m_helper, participant, sameIndi, null, tag, parentFamily, null, null));
                    }
                }
            }
            if (!m_showAllParents) break block34;
            ArrayList<Indi> fathers = new ArrayList<Indi>();
            ArrayList<Indi> arrayList = new ArrayList<Indi>();
            MergeQuery.findFatherMotherCompatibleWithBirthParticipant(this.m_mergeRecord, this.m_gedcom, parentFamilies, fathers, arrayList);
            for (Indi father : fathers) {
                for (Indi mother : arrayList) {
                    models.add(new Proposal(this.m_helper, participant, null, null, tag, null, father, mother));
                }
            }
        }
    }

    void copyRecordToEntity(Proposal proposal1, Proposal proposal2) throws Exception {
        this.getGedcom().doUnitOfWork(gedcom -> {
            try {
                Property propertyNote;
                if (proposal1 == null) {
                    return;
                }
                proposal1.copyRecordToEntity();
                Property associatedProperty1 = proposal1.getMainEvent();
                if (proposal2 != null) {
                    proposal2.copyRecordToEntity();
                    if (proposal2.getMainEntity() != null) {
                        // empty if block
                    }
                }
                if ((propertyNote = associatedProperty1.getProperty("NOTE")) != null) {
                    associatedProperty1 = propertyNote;
                }
                SelectionManager.setRootEntity(associatedProperty1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        });
    }

    protected Gedcom getGedcom() {
        return this.m_gedcom;
    }

    protected MergeRecord getMergeRecord() {
        return this.m_mergeRecord;
    }

    protected MergeRecord.RecordType getMergeRecordType() {
        return this.m_mergeRecord.getRecordType();
    }

    protected Entity getSelectedEntity() {
        return this.m_selectedEntity;
    }

    static boolean getShowAllParents() {
        return m_showAllParents;
    }

    ProposalList getProposalList1() {
        return this.m_mergeModelList1;
    }

    ProposalList getProposalList2() {
        return this.m_mergeModelList2;
    }

    void setShowAllParents(boolean aShowAllParents) throws Exception {
        m_showAllParents = aShowAllParents;
        this.createProposals();
    }

    protected void generateLog() throws Exception {
        MergeLogger.enable();
        this.createProposals();
        MergeLogger.disable();
    }

    public static class ProposalList
    extends AbstractListModel<Proposal> {
        private final List<Proposal> m_list = new ArrayList<Proposal>();
        private final ArrayList<Integer> m_indices = new ArrayList();
        private boolean m_showAllProposal;

        public ProposalList(boolean showAllProposal) {
            this.m_showAllProposal = showAllProposal;
        }

        protected void add(Proposal proposal) {
            boolean alreadyExists = false;
            for (Proposal model : this.m_list) {
                if (!proposal.equalAs(model)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                this.m_list.add(proposal);
                if (MergeLogger.LOG.isLoggable(MergeLogger.ACCEPT)) {
                    MergeLogger.LOG.log(MergeLogger.getAccept(proposal.getMergeInfo()));
                }
            } else if (MergeLogger.LOG.isLoggable(MergeLogger.REFUSE)) {
                MergeInfo loginfo = proposal.getMergeInfo();
                loginfo.add(" already exists in models", new Object[0]);
                MergeLogger.LOG.log(MergeLogger.getRefuse(loginfo));
            }
        }

        private void clear() {
            this.m_list.clear();
            this.m_indices.clear();
        }

        private void sort() {
            Collections.sort(this.m_list);
            int count = this.m_list.size();
            for (int i = 0; i < count; ++i) {
                Proposal element = this.m_list.get(i);
                if (!element.isSelectedEntityProposed()) continue;
                this.m_indices.add(i);
            }
        }

        protected void fireContentsChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void showAllProposal(boolean showAllProposal) {
            if (showAllProposal != this.m_showAllProposal) {
                int size = this.getSize();
                this.m_showAllProposal = showAllProposal;
                this.fireContentsChanged(this, 0, size - 1);
            }
        }

        int getNbAllProposal() {
            return this.m_list.size();
        }

        boolean containsSelectedEntity(int index) {
            if (this.m_showAllProposal) {
                return this.m_indices.contains(index);
            }
            return true;
        }

        int getNbProposalWithSelectedEntity() {
            return this.m_indices.size();
        }

        int getNbBestProposal() {
            if (this.m_indices.size() > 0) {
                return this.m_indices.get(0);
            }
            return 0;
        }

        @Override
        public int getSize() {
            return !this.m_showAllProposal ? this.m_indices.size() : this.m_list.size();
        }

        @Override
        public Proposal getElementAt(int index) {
            return !this.m_showAllProposal ? this.m_list.get(this.m_indices.get(index)) : this.m_list.get(index);
        }
    }
}

