/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.Collection;
import org.openide.util.LookupEvent;

public class CreateAssociation
extends CreateRelationship {
    private Property target;

    public CreateAssociation() {
        this(null);
    }

    public CreateAssociation(Property target) {
        super(resources.getString("add.association"), "INDI");
        this.setContextProperties(target);
        this.contextChanged();
    }

    public void resultChanged(LookupEvent ev) {
        this.target = null;
        Collection props = this.lkpInfo.allInstances();
        if (props.size() == 1) {
            this.target = (Property)props.iterator().next();
            if (!(this.target.isEvent() || this.target instanceof Indi || this.target instanceof Fam && this.target.isGrammar7())) {
                this.target = null;
            }
        }
        super.resultChanged(ev);
    }

    protected final void contextChanged() {
        this.setEnabled(this.target != null);
    }

    @Override
    public String getDescription() {
        return resources.getString("add.association.with", new Object[]{Gedcom.getName((String)this.target.getTag()), this.target.getEntity().toString()});
    }

    @Override
    protected Property change(Entity source, boolean targetIsNew) throws GedcomException {
        Property role = null;
        if (!this.target.isGrammar7()) {
            Indi indi = (Indi)source;
            PropertyXRef asso = (PropertyXRef)indi.addProperty("ASSO", "@" + this.target.getEntity().getId() + "@");
            TagPath anchor = this.target.getPath(true);
            role = asso.addProperty("RELA", (String)(anchor == null ? "" : "@" + anchor.toString()));
            try {
                asso.link();
            }
            catch (GedcomException e) {
                indi.delProperty((Property)asso);
                throw e;
            }
        }
        PropertyAssociation asso = (PropertyAssociation)this.target.addProperty("ASSO", "@" + source.getEntity().getId() + "@");
        role = asso.addProperty("ROLE", "");
        try {
            asso.link();
        }
        catch (GedcomException e) {
            this.target.delProperty((Property)asso);
            throw e;
        }
        return role;
    }
}

