/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.preferences;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class RelPaths {
    private static String[] dirs;

    private RelPaths() {
    }

    public static String[] findRelativePath(String path) {
        if (path.isEmpty()) {
            return null;
        }
        String[] ret = new String[]{null, null};
        RelPaths.testWritePath(path, System.getProperty("netbeans.user"), "user", ret);
        int cnt = 0;
        for (String p : RelPaths.dirs()) {
            RelPaths.testWritePath(path, p, "" + cnt, ret);
            ++cnt;
        }
        RelPaths.testWritePath(path, System.getProperty("netbeans.home"), "home", ret);
        if (ret[1] == null) {
            ret[0] = "abs";
            ret[1] = path;
        }
        return ret;
    }

    public static String readRelativePath(ByteBuffer bb) throws IOException {
        class IS
        extends InputStream {
            final /* synthetic */ ByteBuffer val$bb;

            IS(ByteBuffer byteBuffer) {
                this.val$bb = byteBuffer;
            }

            @Override
            public int read() throws IOException {
                return this.val$bb.position() < this.val$bb.limit() ? (int)this.val$bb.get() : -1;
            }
        }
        DataInputStream dis = new DataInputStream(new IS(bb));
        return RelPaths.readRelativePath(dis);
    }

    public static String cluster(int cluster) {
        return RelPaths.dirs()[cluster];
    }

    public static String readRelativePath(DataInputStream dis) throws IOException {
        String index = dis.readUTF();
        if (index.isEmpty()) {
            return index;
        }
        String relative = dis.readUTF();
        if ("user".equals(index)) {
            return System.getProperty("netbeans.user").concat(relative);
        }
        if ("home".equals(index)) {
            return System.getProperty("netbeans.home").concat(relative);
        }
        if ("abs".equals(index)) {
            return relative;
        }
        int indx = 0;
        try {
            indx = Integer.parseInt(index);
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
        return RelPaths.dirs()[indx].concat(relative);
    }

    private static boolean testWritePath(String path, String prefix, String codeName, String[] ret) {
        if (prefix == null || prefix.isEmpty()) {
            return false;
        }
        if (path.startsWith(prefix)) {
            String relPath = path.substring(prefix.length());
            while (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            if (ret[1] == null || ret[1].length() > relPath.length()) {
                ret[0] = codeName;
                ret[1] = relPath;
            }
            return true;
        }
        return false;
    }

    private static synchronized String[] dirs() {
        if (dirs == null) {
            ArrayList<String> tmp = new ArrayList<String>();
            String nbdirs = System.getProperty("netbeans.dirs");
            if (nbdirs != null) {
                StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
                while (tok.hasMoreTokens()) {
                    tmp.add(tok.nextToken());
                }
            }
            dirs = tmp.toArray(new String[0]);
        }
        return dirs;
    }

    static synchronized void assignDirs(String ... arr) {
        dirs = arr;
    }
}

