/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.explorer;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.explorer.TrialListenerManager;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.Dumper;

public class GUIBrowser
extends JFrame {
    private static String WINDOWS_TAB = "Subwindows";
    private static String COMPONENTS_TAB = "Hierarchy";
    private static String PROPERTIES_TAB = "Properties";
    private static String REFLECTION_TAB = "Reflection";
    private static String EVENT_TAB = "Events";
    private static String IMAGE_TAB = "Image";
    boolean exit;
    PropertyDialog propDialog;
    RootNode root;
    QueueTool qt;
    JTextField refreshDelay;
    JTree mainTree;
    JLabel status;
    JButton viewButton;
    JButton expandButton;
    JSplitPane split;
    ByteArrayOutputStream dumpData = new ByteArrayOutputStream();
    PrintWriter dumpWriter = new PrintWriter(new OutputStreamWriter(this.dumpData));
    boolean shown = false;

    private GUIBrowser(boolean exitNecessary) {
        super("GUI Browser");
        this.exit = exitNecessary;
        this.propDialog = new PropertyDialog(this);
        this.qt = new QueueTool();
        this.qt.setOutput(TestOut.getNullOutput());
        this.root = new RootNode();
        this.mainTree = new JTree(this.root.getWindowModel());
        this.mainTree.setCellRenderer(new WindowRenderer());
        this.mainTree.setEditable(false);
        this.refreshDelay = new JTextField(3);
        this.refreshDelay.setText("0");
        this.viewButton = new JButton("View");
        this.viewButton.setEnabled(false);
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ComponentBrowser(GUIBrowser.this.getOwnr(), (ComponentNode)GUIBrowser.this.mainTree.getSelectionPath().getLastPathComponent()).show();
            }
        });
        this.expandButton = new JButton("Expand All");
        this.expandButton.setEnabled(false);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIBrowser.this.expandAll(GUIBrowser.this.mainTree, GUIBrowser.this.mainTree.getSelectionPath());
            }
        });
        JButton refreshButton = new JButton("Reload in ...");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIBrowser.this.reload(new Integer(GUIBrowser.this.refreshDelay.getText()));
            }
        });
        JButton dumpButton = new JButton("Dump");
        dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
                chooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getName().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return "xml files";
                    }
                });
                chooser.showSaveDialog(GUIBrowser.this);
                try {
                    File file = chooser.getSelectedFile();
                    FileOutputStream output = new FileOutputStream(file);
                    ((OutputStream)output).write(GUIBrowser.this.dumpData.toByteArray());
                }
                catch (IOException ee) {
                    ee.printStackTrace();
                }
            }
        });
        JPanel refreshPane = new JPanel();
        refreshPane.add(this.viewButton);
        refreshPane.add(this.expandButton);
        refreshPane.add(new JLabel(""));
        refreshPane.add(new JLabel(""));
        refreshPane.add(new JLabel(""));
        refreshPane.add(new JLabel(""));
        refreshPane.add(new JLabel(""));
        refreshPane.add(new JLabel(""));
        refreshPane.add(refreshButton);
        refreshPane.add(this.refreshDelay);
        refreshPane.add(new JLabel("seconds     "));
        refreshPane.add(dumpButton);
        this.split = this.createUnderPane(this.mainTree);
        JPanel nonStatusPane = new JPanel();
        nonStatusPane.setLayout(new BorderLayout());
        nonStatusPane.add((Component)refreshPane, "South");
        nonStatusPane.add((Component)this.split, "Center");
        this.split.setDividerLocation(0.8);
        this.status = new JLabel("Reloaded");
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.add((Component)this.status, "Center");
        statusPane.setBorder(new BevelBorder(1));
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BorderLayout());
        bottomPane.add((Component)statusPane, "North");
        bottomPane.add((Component)statusPane, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)bottomPane, "South");
        this.getContentPane().add((Component)nonStatusPane, "Center");
        Component[] cpss = new Component[]{this.viewButton, this.expandButton};
        this.mainTree.addTreeSelectionListener(new SelectionManager(cpss));
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                GUIBrowser.this.setVisible(false);
                if (GUIBrowser.this.exit) {
                    System.exit(0);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                GUIBrowser.this.split.setDividerLocation(0.8);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.setSize(800, 400);
    }

    @Override
    public void show() {
        super.show();
        this.viewButton.setEnabled(false);
        if (!this.shown) {
            this.split.setDividerLocation(0.8);
            this.shown = true;
        }
    }

    public void setStatus(String st) {
        this.status.setText(st);
    }

    public static void showBrowser() {
        GUIBrowser.showBrowser(new String[0], false);
    }

    public static void main(String[] argv) {
        GUIBrowser.showBrowser(argv, true);
    }

    private static void showBrowser(String[] argv, boolean exitNecessary) {
        if (argv.length >= 1) {
            String[] newArgv = new String[argv.length - 1];
            for (int i = 1; i < argv.length; ++i) {
                newArgv[i - 1] = argv[i];
            }
            try {
                new ClassReference(argv[0]).startApplication(newArgv);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return;
            }
        }
        new GUIBrowser(exitNecessary).show();
    }

    private void reload(final int delay) {
        this.viewButton.setEnabled(false);
        this.expandButton.setEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = delay - 1; i >= 0; --i) {
                        GUIBrowser.this.setStatus("Reloading after " + Integer.toString(i) + " second");
                        Thread.sleep(1000L);
                    }
                    GUIBrowser.this.setStatus("Reloading ...");
                    Dumper.dumpAll(GUIBrowser.this.dumpWriter);
                    GUIBrowser.this.root = new RootNode();
                    GUIBrowser.this.mainTree.setModel(GUIBrowser.this.root.getWindowModel());
                    GUIBrowser.this.setStatus("Reloaded");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private JFrame getOwnr() {
        return this;
    }

    private void expandAll(JTree tree, TreePath path) {
        tree.expandPath(path);
        TreeModel model = tree.getModel();
        Object lastComponent = path.getLastPathComponent();
        for (int i = 0; i < model.getChildCount(lastComponent); ++i) {
            this.expandAll(tree, path.pathByAddingChild(model.getChild(lastComponent, i)));
        }
    }

    private JSplitPane createUnderPane(JTree tree) {
        JTextArea toStringArea = new JTextArea();
        toStringArea.setLineWrap(true);
        toStringArea.setEditable(false);
        tree.addTreeSelectionListener(new ToStringListener(toStringArea));
        JSplitPane result = new JSplitPane(0, new JScrollPane(tree), new JScrollPane(toStringArea));
        result.setOneTouchExpandable(true);
        result.setDividerSize(8);
        result.setDividerLocation(0.8);
        return result;
    }

    private class ComponentImageProvider {
        BufferedImage image;
        int x;
        int y;

        public ComponentImageProvider(BufferedImage image, int x, int y) {
            this.image = image;
            this.x = x;
            this.y = y;
        }

        public BufferedImage getImage(int x, int y, int w, int h) {
            int realW = Math.min(this.image.getWidth() - x, w);
            int realH = Math.min(this.image.getHeight() - y, h);
            return this.image.getSubimage(x - this.x, y - this.y, realW, realH);
        }
    }

    private class ImagePane
    extends JPanel {
        BufferedImage image;

        public ImagePane(BufferedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, null);
        }
    }

    private class ListListener
    extends TrialListenerManager {
        DefaultListModel model;

        public ListListener(DefaultListModel m, Component comp) {
            super(comp);
            this.model = m;
        }

        @Override
        void printEvent(AWTEvent e) {
            this.model.addElement(e);
        }
    }

    private class MyModel
    extends DefaultTableModel {
        public MyModel(Hashtable props) {
            Object[] keys = props.keySet().toArray();
            if (keys.length > 0) {
                this.addColumn("Name");
                this.addColumn("Value");
                this.setNumRows(keys.length);
                for (int i = 0; i < keys.length; ++i) {
                    this.setValueAt(keys[i].toString(), i, 0);
                    this.setValueAt(props.get(keys[i]).toString(), i, 1);
                }
                Collections.sort(this.getDataVector(), new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((Vector)o1).get(0).toString().compareTo(((Vector)o2).get(0).toString());
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return false;
                    }
                });
            }
        }

        @Override
        public boolean isCellEditable(int x, int y) {
            return false;
        }
    }

    private class ToStringListener
    implements TreeSelectionListener {
        JTextArea area;

        public ToStringListener(JTextArea area) {
            this.area = area;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getPath() != null && e.getPath().getLastPathComponent() instanceof ComponentNode) {
                this.area.setText("toString(): " + ((ComponentNode)e.getPath().getLastPathComponent()).getToString());
            } else {
                this.area.setText("");
            }
        }
    }

    private class SelectionManager
    implements TreeSelectionListener,
    ListSelectionListener {
        Component[] comps;

        public SelectionManager(Component[] comps) {
            this.comps = comps;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            for (int i = 0; i < this.comps.length; ++i) {
                this.comps[i].setEnabled(e.getPath() != null);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            for (int i = 0; i < this.comps.length; ++i) {
                this.comps[i].setEnabled(e.getFirstIndex() != -1);
            }
        }
    }

    private class ComponentBrowser
    extends JFrame {
        JTree winTree;
        JTree componentTree;
        JTree methodTree;
        ClassNode compNode;
        JTabbedPane tbd;
        JButton viewButton;
        JButton expandButton;
        JSplitPane winSplit;
        JSplitPane componentSplit;
        WindowRenderer renderer;
        SelectionManager selManager;
        JList eventList;
        ListListener listListener;
        DefaultListModel eventModel;
        JCheckBox mouseEvents;
        JCheckBox mouseMotionEvents;
        JCheckBox keyEvents;

        public ComponentBrowser(JFrame owner, ClassNode componentNode) {
            super("Component " + componentNode.toString());
            this.winSplit = null;
            this.componentSplit = null;
            this.fill(componentNode);
        }

        private void fill(ClassNode componentNode) {
            this.compNode = componentNode;
            this.viewButton = new JButton("View");
            this.viewButton.setEnabled(false);
            this.viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ComponentBrowser(ComponentBrowser.this.getOwnr(), ComponentBrowser.this.getSelectedNode()).show();
                }
            });
            this.expandButton = new JButton("Expand All");
            this.expandButton.setEnabled(false);
            this.expandButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIBrowser.this.expandAll(ComponentBrowser.this.getSelectedTree(), ComponentBrowser.this.getSelectionPath());
                }
            });
            JPanel buttonPane = new JPanel();
            buttonPane.add(this.viewButton);
            buttonPane.add(this.expandButton);
            Component[] cpss = new Component[]{this.viewButton, this.expandButton};
            this.selManager = new SelectionManager(cpss);
            this.renderer = new WindowRenderer();
            this.tbd = new JTabbedPane();
            for (int i = 0; i < GUIBrowser.this.propDialog.viewTabs.size(); ++i) {
                String next = (String)GUIBrowser.this.propDialog.viewTabs.elementAt(i);
                if (next.equals(PROPERTIES_TAB)) {
                    this.addPropertiesTab();
                    continue;
                }
                if (next.equals(WINDOWS_TAB)) {
                    this.addWindowTab();
                    continue;
                }
                if (next.equals(COMPONENTS_TAB)) {
                    this.addComponentTab();
                    continue;
                }
                if (next.equals(REFLECTION_TAB)) {
                    this.addReflectionTab();
                    continue;
                }
                if (next.equals(EVENT_TAB)) {
                    this.addEventTab();
                    continue;
                }
                if (!next.equals(IMAGE_TAB)) continue;
                this.addImageTab();
            }
            this.tbd.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ComponentBrowser.this.viewButton.setEnabled(ComponentBrowser.this.getSelectedNode() != null);
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)buttonPane, "South");
            this.getContentPane().add((Component)this.tbd, "Center");
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (ComponentBrowser.this.winSplit != null) {
                        ComponentBrowser.this.winSplit.setDividerLocation(0.8);
                    }
                    if (ComponentBrowser.this.componentSplit != null) {
                        ComponentBrowser.this.componentSplit.setDividerLocation(0.8);
                    }
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }
            });
            this.setSize(800, 400);
        }

        private void addImageTab() {
            BufferedImage image = null;
            if (this.compNode instanceof ComponentNode) {
                image = ((ComponentNode)this.compNode).getImage();
            }
            if (image != null) {
                ImagePane imagePane = new ImagePane(image);
                imagePane.prepareImage(image, imagePane);
                JScrollPane pane = new JScrollPane(imagePane);
                this.tbd.add(IMAGE_TAB, pane);
            }
        }

        private void addWindowTab() {
            if (this.compNode instanceof WindowNode && ((WindowNode)this.compNode).getWindows().length > 0) {
                this.winTree = new JTree(((WindowNode)this.compNode).getWindowModel());
                this.winTree.setCellRenderer(this.renderer);
                this.winTree.setEditable(false);
                this.winTree.addTreeSelectionListener(this.selManager);
                this.winSplit = GUIBrowser.this.createUnderPane(this.winTree);
                this.tbd.add(WINDOWS_TAB, this.winSplit);
            }
        }

        private void addComponentTab() {
            if (this.compNode instanceof ContainerNode && ((ContainerNode)this.compNode).getComponents().length > 0) {
                this.componentTree = new JTree(((ContainerNode)this.compNode).getComponentModel());
                this.componentTree.setCellRenderer(this.renderer);
                this.componentTree.setEditable(false);
                this.componentTree.addTreeSelectionListener(this.selManager);
                this.componentSplit = GUIBrowser.this.createUnderPane(this.componentTree);
                this.tbd.add(COMPONENTS_TAB, this.componentSplit);
            }
        }

        private void addReflectionTab() {
            this.methodTree = new JTree(this.compNode.getMethodsModel());
            this.methodTree.setCellRenderer(this.renderer);
            this.methodTree.setEditable(false);
            this.methodTree.addTreeSelectionListener(this.selManager);
            this.tbd.add(REFLECTION_TAB, new JScrollPane(this.methodTree));
        }

        private void addPropertiesTab() {
            Hashtable props;
            if (this.compNode instanceof ComponentNode && (props = ((ContainerNode)this.compNode).getProperties()).size() > 0) {
                JTable propTable = new JTable(new MyModel(props));
                propTable.setAutoResizeMode(3);
                this.tbd.add(PROPERTIES_TAB, new JScrollPane(propTable));
            }
        }

        private void addEventTab() {
            if (this.compNode instanceof ComponentNode) {
                this.eventModel = new DefaultListModel();
                this.eventList = new JList(this.eventModel);
                this.listListener = new ListListener(this.eventModel, ((ComponentNode)this.compNode).comp);
                this.mouseEvents = new JCheckBox("Mouse events");
                this.mouseEvents.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ComponentBrowser.this.mouseEvents.isSelected()) {
                            ComponentBrowser.this.listListener.addMouseListener();
                        } else {
                            ComponentBrowser.this.listListener.removeMouseListener();
                        }
                    }
                });
                this.mouseMotionEvents = new JCheckBox("Mouse motion events");
                this.mouseMotionEvents.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ComponentBrowser.this.mouseMotionEvents.isSelected()) {
                            ComponentBrowser.this.listListener.addMouseMotionListener();
                        } else {
                            ComponentBrowser.this.listListener.removeMouseMotionListener();
                        }
                    }
                });
                this.keyEvents = new JCheckBox("Key events");
                this.keyEvents.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ComponentBrowser.this.keyEvents.isSelected()) {
                            ComponentBrowser.this.listListener.addKeyListener();
                        } else {
                            ComponentBrowser.this.listListener.removeKeyListener();
                        }
                    }
                });
                JButton clear = new JButton("Clear list");
                clear.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ComponentBrowser.this.eventModel.removeAllElements();
                    }
                });
                JPanel checkPane = new JPanel();
                checkPane.add(this.mouseEvents);
                checkPane.add(this.mouseMotionEvents);
                checkPane.add(this.keyEvents);
                checkPane.add(clear);
                JPanel subPane = new JPanel();
                subPane.setLayout(new BorderLayout());
                subPane.add((Component)checkPane, "South");
                subPane.add((Component)new JScrollPane(this.eventList), "Center");
                this.tbd.add(EVENT_TAB, subPane);
            }
        }

        private JFrame getOwnr() {
            return this;
        }

        private JTree getSelectedTree() {
            String title = this.tbd.getTitleAt(this.tbd.getSelectedIndex());
            if (title.equals(WINDOWS_TAB)) {
                return this.winTree;
            }
            if (title.equals(COMPONENTS_TAB)) {
                return this.componentTree;
            }
            if (title.equals(REFLECTION_TAB)) {
                return this.methodTree;
            }
            return null;
        }

        private TreePath getSelectionPath() {
            JTree tree = this.getSelectedTree();
            if (tree != null) {
                return tree.getSelectionPath();
            }
            return null;
        }

        private ClassNode getSelectedNode() {
            TreePath path = this.getSelectionPath();
            if (path != null) {
                return (ClassNode)path.getLastPathComponent();
            }
            return null;
        }
    }

    private class PropertyDialog
    extends JDialog {
        public boolean showAll;
        JComboBox visibleCombo;
        JCheckBox showToString;
        JCheckBox showReflection;
        JCheckBox showEvents;
        DefaultListModel viewTabs;
        JList orderList;
        JButton up;
        JButton down;
        Properties props;
        File propFile;

        public PropertyDialog(JFrame owner) {
            super(owner, "Properties", true);
            this.showAll = false;
            this.propFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".guibrowser");
            this.props = new Properties();
            String[] cpItems = new String[]{"Showing", "All"};
            this.visibleCombo = new JComboBox<String>(cpItems);
            this.visibleCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyDialog.this.showAll = PropertyDialog.this.visibleCombo.getSelectedIndex() == 1;
                }
            });
            JPanel visiblePane = new JPanel();
            visiblePane.add(new JLabel("Show "));
            visiblePane.add(this.visibleCombo);
            this.showToString = new JCheckBox("Show toString() method result");
            this.showToString.setSelected(true);
            JPanel compTreePane = new JPanel();
            compTreePane.add(visiblePane);
            this.viewTabs = new DefaultListModel();
            this.viewTabs.addElement(WINDOWS_TAB);
            this.viewTabs.addElement(COMPONENTS_TAB);
            this.viewTabs.addElement(PROPERTIES_TAB);
            this.viewTabs.addElement(REFLECTION_TAB);
            this.viewTabs.addElement(IMAGE_TAB);
            this.orderList = new JList(this.viewTabs);
            this.orderList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PropertyDialog.this.up.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                    PropertyDialog.this.down.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                }
            });
            this.showReflection = new JCheckBox("Show reflection tab");
            this.showReflection.setSelected(true);
            this.showReflection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PropertyDialog.this.showReflection.isSelected()) {
                        PropertyDialog.this.viewTabs.addElement(REFLECTION_TAB);
                    } else {
                        PropertyDialog.this.viewTabs.remove(PropertyDialog.this.viewTabs.indexOf(REFLECTION_TAB));
                    }
                    PropertyDialog.this.up.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                    PropertyDialog.this.down.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                }
            });
            this.showEvents = new JCheckBox("Show event tab");
            this.showEvents.setSelected(true);
            this.showEvents.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PropertyDialog.this.showEvents.isSelected()) {
                        PropertyDialog.this.viewTabs.addElement(EVENT_TAB);
                    } else {
                        PropertyDialog.this.viewTabs.remove(PropertyDialog.this.viewTabs.indexOf(EVENT_TAB));
                    }
                    PropertyDialog.this.up.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                    PropertyDialog.this.down.setEnabled(PropertyDialog.this.orderList.getSelectedIndex() > -1);
                }
            });
            this.up = new JButton("Move Up");
            this.up.setEnabled(false);
            this.up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PropertyDialog.this.orderList.getSelectedIndex();
                    if (index > 0) {
                        PropertyDialog.this.viewTabs.add(index - 1, PropertyDialog.this.viewTabs.remove(index));
                        PropertyDialog.this.orderList.setSelectedIndex(index - 1);
                    }
                }
            });
            this.down = new JButton("Move Down");
            this.down.setEnabled(false);
            this.down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PropertyDialog.this.orderList.getSelectedIndex();
                    if (index < PropertyDialog.this.viewTabs.size() - 1) {
                        PropertyDialog.this.viewTabs.add(index + 1, PropertyDialog.this.viewTabs.remove(index));
                        PropertyDialog.this.orderList.setSelectedIndex(index + 1);
                    }
                }
            });
            JPanel movePane = new JPanel();
            movePane.add(this.showEvents);
            movePane.add(this.showReflection);
            movePane.add(this.up);
            movePane.add(this.down);
            JPanel compViewPane = new JPanel();
            compViewPane.setLayout(new BorderLayout());
            compViewPane.add((Component)new JLabel("Tab order:"), "North");
            compViewPane.add((Component)movePane, "South");
            compViewPane.add((Component)this.orderList, "Center");
            JTabbedPane tbpn = new JTabbedPane();
            tbpn.add("Component Tree", compTreePane);
            tbpn.add("Component View", compViewPane);
            JButton okBUtton = new JButton("OK");
            okBUtton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyDialog.this.save();
                    PropertyDialog.this.setVisible(false);
                }
            });
            JButton cnBUtton = new JButton("Cancel");
            cnBUtton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyDialog.this.setVisible(false);
                    PropertyDialog.this.load();
                }
            });
            JPanel pn = new JPanel();
            pn.add(okBUtton);
            pn.add(cnBUtton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)pn, "South");
            this.getContentPane().add((Component)tbpn, "Center");
            this.load();
            this.setSize(400, 400);
        }

        private void save() {
            try {
                this.props.setProperty("guibrowser.showall", this.showAll ? "on" : "off");
                for (int i = 0; i < this.viewTabs.size(); ++i) {
                    this.props.setProperty("guibrowser.viewpage_" + Integer.toString(i), (String)this.viewTabs.elementAt(i));
                }
                this.props.store(new FileOutputStream(this.propFile), "Jemmy GUIBrowser");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void load() {
            if (this.propFile.exists()) {
                try {
                    this.props.load(new FileInputStream(this.propFile));
                    this.showAll = this.props.getProperty("guibrowser.showall") == null || this.props.getProperty("guibrowser.showall").equals("") || this.props.getProperty("guibrowser.showall").equals("on");
                    this.visibleCombo.setSelectedIndex(this.showAll ? 1 : 0);
                    if (this.props.getProperty("guibrowser.viewpage_0") != null && !this.props.getProperty("guibrowser.viewpage_0").equals("")) {
                        this.viewTabs.removeAllElements();
                        this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_0"));
                        this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_1"));
                        this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_2"));
                        if (this.props.getProperty("guibrowser.viewpage_3") != null && !this.props.getProperty("guibrowser.viewpage_3").equals("")) {
                            this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_3"));
                        }
                        if (this.props.getProperty("guibrowser.viewpage_4") != null && !this.props.getProperty("guibrowser.viewpage_4").equals("")) {
                            this.viewTabs.addElement(this.props.getProperty("guibrowser.viewpage_4"));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.showReflection.setSelected(this.viewTabs.indexOf(REFLECTION_TAB) > -1);
                this.showEvents.setSelected(this.viewTabs.indexOf(EVENT_TAB) > -1);
            }
        }
    }

    private class WindowRenderer
    implements TreeCellRenderer,
    ListCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return this.get(value, selected);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.get(value, isSelected);
        }

        private Component get(Object value, boolean selected) {
            JLabel result = new JLabel(((ClassNode)value).toString());
            if (selected) {
                ((Component)result).setBackground(Color.blue);
                ((Component)result).setForeground(Color.white);
                JPanel resPane = new JPanel();
                resPane.setLayout(new BorderLayout());
                resPane.add((Component)result, "Center");
                return resPane;
            }
            return result;
        }
    }

    private class ComponentModel
    implements TreeModel {
        ContainerNode cont;

        ComponentModel(ContainerNode cont) {
            this.cont = cont;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof ContainerNode) {
                return ((ContainerNode)parent).getComponents()[index];
            }
            return "";
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof ContainerNode) {
                return ((ContainerNode)parent).getComponents().length;
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof ContainerNode) {
                return ((ContainerNode)parent).getComponentIndex((ComponentNode)child);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.cont;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node instanceof ContainerNode) {
                return ((ContainerNode)node).getComponents().length == 0;
            }
            return true;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class WindowModel
    implements TreeModel {
        WindowNode win;

        WindowModel(WindowNode win) {
            this.win = win;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((WindowNode)parent).getWindows()[index];
        }

        @Override
        public int getChildCount(Object parent) {
            return ((WindowNode)parent).getWindows().length;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return ((WindowNode)parent).getWindowIndex((WindowNode)child);
        }

        @Override
        public Object getRoot() {
            return this.win;
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((WindowNode)node).getWindows().length == 0;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class ClassModel
    implements TreeModel {
        ClassNode clsn;

        ClassModel(ClassNode clsn) {
            this.clsn = clsn;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.clsn) {
                return this.clsn.getSuperClasses()[index];
            }
            if (parent instanceof SuperClassNode || parent instanceof InterfaceNode) {
                return ((ClassNode)parent).getSubNodes()[index];
            }
            if (parent instanceof MethodNode) {
                return ((MethodNode)parent).getParameters()[index];
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.clsn) {
                return this.clsn.getSuperClasses().length;
            }
            if (parent instanceof SuperClassNode || parent instanceof InterfaceNode) {
                return ((ClassNode)parent).getSubNodes().length;
            }
            if (parent instanceof MethodNode) {
                return ((MethodNode)parent).getParameters().length;
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.clsn || parent instanceof MethodNode || parent instanceof SuperClassNode || parent instanceof InterfaceNode) {
                ClassNode[] children = parent instanceof SuperClassNode || parent instanceof InterfaceNode ? ((ClassNode)parent).getSuperClasses() : (parent instanceof MethodNode ? ((MethodNode)parent).getParameters() : this.clsn.getSuperClasses());
                for (int i = 0; i < children.length; ++i) {
                    if (!children.equals(child)) continue;
                    return i;
                }
            }
            return 0;
        }

        @Override
        public Object getRoot() {
            return this.clsn;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class RootNode
    extends WindowNode {
        public RootNode() {
            int i;
            Frame[] wns = Frame.getFrames();
            this.wins = new WindowNode[wns.length];
            int count = 0;
            for (i = 0; i < wns.length; ++i) {
                if (!GUIBrowser.this.propDialog.showAll && !wns[i].isVisible()) continue;
                ++count;
            }
            this.wins = new WindowNode[count];
            count = 0;
            for (i = 0; i < wns.length; ++i) {
                if (!GUIBrowser.this.propDialog.showAll && !wns[i].isVisible()) continue;
                this.wins[count] = new WindowNode(wns[i]);
                ++count;
            }
        }
    }

    private class WindowNode
    extends ContainerNode {
        protected WindowNode[] wins;
        String title;

        protected WindowNode() {
            this.wins = new WindowNode[0];
            this.title = "All Frames";
            this.clss = "";
        }

        public WindowNode(Window win) {
            int i;
            super(win);
            Window[] wns = win.getOwnedWindows();
            Vector<WindowNode> wwns = new Vector<WindowNode>();
            for (i = 0; i < wns.length; ++i) {
                if (!GUIBrowser.this.propDialog.showAll && !wns[i].isVisible()) continue;
                wwns.add(new WindowNode(wns[i]));
            }
            this.wins = new WindowNode[wwns.size()];
            for (i = 0; i < wwns.size(); ++i) {
                this.wins[i] = (WindowNode)wwns.get(i);
            }
            this.title = win.toString();
            this.clss = win.getClass().getName();
            BufferedImage image = null;
            try {
                image = new Robot().createScreenCapture(new Rectangle(win.getLocationOnScreen(), win.getSize()));
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            this.setComponentImageProvider(new ComponentImageProvider(image, this.x, this.y));
        }

        public WindowNode[] getWindows() {
            return this.wins;
        }

        public int getWindowIndex(WindowNode node) {
            for (int i = 0; i < this.wins.length; ++i) {
                if (!this.wins[i].equals(node)) continue;
                return i;
            }
            return -1;
        }

        public WindowModel getWindowModel() {
            return new WindowModel(this);
        }

        @Override
        public String toString() {
            return this.clss + " \"" + this.title + "\"";
        }
    }

    private class ContainerNode
    extends ComponentNode {
        protected ComponentNode[] comps;

        protected ContainerNode() {
            this.comps = new ComponentNode[0];
        }

        public ContainerNode(Container comp) {
            int i;
            super(comp);
            Component[] cmps = comp.getComponents();
            Vector<ComponentNode> wwns = new Vector<ComponentNode>();
            for (i = 0; i < cmps.length; ++i) {
                if (cmps[i] == null || !GUIBrowser.this.propDialog.showAll && !cmps[i].isVisible()) continue;
                if (cmps[i] instanceof Container) {
                    wwns.add(new ContainerNode((Container)cmps[i]));
                    continue;
                }
                wwns.add(new ComponentNode(cmps[i]));
            }
            this.comps = new ComponentNode[wwns.size()];
            for (i = 0; i < wwns.size(); ++i) {
                this.comps[i] = (ComponentNode)wwns.get(i);
            }
        }

        public ComponentNode[] getComponents() {
            return this.comps;
        }

        public int getComponentIndex(ComponentNode comp) {
            for (int i = 0; i < this.comps.length; ++i) {
                if (!this.comps[i].equals(comp)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void setComponentImageProvider(ComponentImageProvider provider) {
            super.setComponentImageProvider(provider);
            for (int i = 0; i < this.comps.length; ++i) {
                this.comps[i].setComponentImageProvider(provider);
            }
        }

        public ComponentModel getComponentModel() {
            return new ComponentModel(this);
        }
    }

    private class ComponentNode
    extends ClassNode {
        protected Hashtable props;
        protected String clss;
        protected String compToString;
        Component comp;
        ComponentImageProvider image;
        protected int x;
        protected int y;
        protected int w;
        protected int h;

        protected ComponentNode() {
            this.clss = "";
            this.compToString = "";
            this.props = new Hashtable();
        }

        public ComponentNode(Component comp) {
            super(comp.getClass());
            this.clss = "";
            this.compToString = "";
            try {
                this.props = Operator.createOperator(comp).getDump();
            }
            catch (Exception e) {
                this.props = new Hashtable();
            }
            this.clss = comp.getClass().getName();
            this.compToString = comp.toString();
            this.comp = comp;
            this.x = comp.getLocationOnScreen().x;
            this.y = comp.getLocationOnScreen().y;
            this.w = comp.getWidth();
            this.h = comp.getHeight();
        }

        @Override
        public String toString() {
            return this.clss;
        }

        public Hashtable getProperties() {
            return this.props;
        }

        public String getToString() {
            return this.compToString;
        }

        public void setComponentImageProvider(ComponentImageProvider provider) {
            this.image = provider;
        }

        public BufferedImage getImage() {
            if (this.image != null) {
                return this.image.getImage(this.x, this.y, this.w, this.h);
            }
            return null;
        }
    }

    private class MethodNode
    extends ClassNode {
        Method method;

        public MethodNode(Method mtd) {
            super(mtd.getReturnType());
            this.method = mtd;
        }

        @Override
        public String toString() {
            return "Method: " + Modifier.toString(this.method.getModifiers()) + " " + super.toString() + " " + this.method.getName();
        }

        public ClassNode[] getParameters() {
            Class<?>[] ptps = this.method.getParameterTypes();
            ClassNode[] result = new ClassNode[ptps.length];
            for (int i = 0; i < ptps.length; ++i) {
                result[i] = new ClassNode(ptps[i]);
            }
            return result;
        }
    }

    private class FieldNode
    extends ClassNode {
        Field field;

        public FieldNode(Field fld) {
            super(fld.getType());
            this.field = fld;
        }

        @Override
        public String toString() {
            return "Field: " + Modifier.toString(this.field.getModifiers()) + " " + super.toString() + " " + this.field.getName();
        }
    }

    private class InterfaceNode
    extends ClassNode {
        public InterfaceNode(Class clzz) {
            super(clzz);
        }

        @Override
        public String toString() {
            return "Interfac: " + super.toString();
        }
    }

    private class SuperClassNode
    extends ClassNode {
        public SuperClassNode(Class clzz) {
            super(clzz);
        }

        @Override
        public String toString() {
            return "Class: " + super.toString();
        }
    }

    private class ClassNode {
        Class clzz;

        protected ClassNode() {
            this.clzz = null;
        }

        public ClassNode(Class clzz) {
            this.clzz = clzz;
        }

        public ClassNode[] getSuperClasses() {
            int count = 0;
            Class parent = this.clzz;
            while ((parent = parent.getSuperclass()) != null) {
                ++count;
            }
            Class<?>[] interfaces = this.clzz.getInterfaces();
            ClassNode[] result = new ClassNode[count + interfaces.length + 1];
            result[0] = new SuperClassNode(this.clzz);
            count = 1;
            parent = this.clzz;
            while ((parent = parent.getSuperclass()) != null) {
                result[count] = new SuperClassNode(parent);
                ++count;
            }
            for (int i = count; i < count + interfaces.length; ++i) {
                result[i] = new InterfaceNode(interfaces[i - count]);
            }
            return result;
        }

        public String toString() {
            if (this.clzz.isArray()) {
                return this.clzz.getComponentType().getName() + "[]";
            }
            return this.clzz.getName();
        }

        public TreeModel getMethodsModel() {
            return new ClassModel(this);
        }

        public ClassNode[] getSubNodes() {
            int i;
            Vector<ClassNode> res = new Vector<ClassNode>();
            Field[] fields = this.clzz.getFields();
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Field)o1).getName().compareTo(((Field)o2).getName());
                }
            });
            Method[] mtds = this.clzz.getMethods();
            Arrays.sort(mtds, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((Method)o1).getName().compareTo(((Method)o2).getName());
                }
            });
            for (i = 0; i < fields.length; ++i) {
                if (!fields[i].getDeclaringClass().getName().equals(this.clzz.getName())) continue;
                res.add(new FieldNode(fields[i]));
            }
            for (i = 0; i < mtds.length; ++i) {
                if (!mtds[i].getDeclaringClass().getName().equals(this.clzz.getName())) continue;
                res.add(new MethodNode(mtds[i]));
            }
            ClassNode[] result = new ClassNode[res.size()];
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = (ClassNode)res.get(i2);
            }
            return result;
        }
    }
}

