/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.GedcomExplorerTopComponent;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.io.Filter;
import java.awt.Image;
import java.util.Collection;

class GedcomEntities {
    private final String tag;
    private final Gedcom gedcom;

    GedcomEntities(Gedcom gedcom, String tag) {
        this.tag = tag;
        this.gedcom = gedcom;
    }

    public String getTitle() {
        int count;
        Filter f = GedcomExplorerTopComponent.getDefault().getFilter();
        int n = count = f == null ? -1 : f.getIndividualsCount();
        if (count == -1) {
            count = this.getEntities().size();
        } else {
            count = 0;
            for (Entity entity : this.getEntities()) {
                count += f.veto(entity) ? 0 : 1;
            }
        }
        return Gedcom.getName((String)this.tag, (boolean)true) + " (" + count + ")";
    }

    public Image getImage() {
        return GedcomConstants.getEntityImage((String)this.tag).getImage();
    }

    public Collection<? extends Entity> getEntities() {
        return this.gedcom.getEntities(this.tag);
    }

    public String getTag() {
        return this.tag;
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }
}

