/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.GedcomExplorerTopComponent;
import genj.gedcom.GedcomOptions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GedcomExplorerSettings
extends JPanel {
    private final GedcomExplorerTopComponent.Settings caller;
    private boolean initialised = false;
    private final long oldMillisec;
    private JSpinner fromModificationDate;
    private JLabel modifiedLabel;
    private JButton nowButton;
    private JButton thisMonthButton;
    private JButton thisWeekButton;
    private JButton thisYearButton;
    private JButton todayButton;

    protected GedcomExplorerSettings(GedcomExplorerTopComponent.Settings caller) {
        this.caller = caller;
        this.initComponents();
        String milisecStr = GedcomOptions.getInstance().getFromModificationDate();
        this.fromModificationDate.setValue(new Date(Long.parseLong(milisecStr)));
        this.initialised = true;
        this.oldMillisec = Long.parseLong(GedcomOptions.getInstance().getFromModificationDate());
    }

    private void initComponents() {
        this.modifiedLabel = new JLabel();
        this.fromModificationDate = new JSpinner();
        this.thisYearButton = new JButton();
        this.thisMonthButton = new JButton();
        this.thisWeekButton = new JButton();
        this.todayButton = new JButton();
        this.nowButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.modifiedLabel, (String)NbBundle.getMessage(GedcomExplorerSettings.class, (String)"GedcomExplorerSettings.modifiedLabel.text"));
        this.fromModificationDate.setModel(new SpinnerDateModel(new Date(), new Date(-3600000L), new Date(), 10));
        this.fromModificationDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GedcomExplorerSettings.this.fromModificationDateStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.thisYearButton, (String)NbBundle.getMessage(GedcomExplorerSettings.class, (String)"GedcomExplorerSettings.thisYearButton.text"));
        this.thisYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomExplorerSettings.this.thisYearButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.thisMonthButton, (String)NbBundle.getMessage(GedcomExplorerSettings.class, (String)"GedcomExplorerSettings.thisMonthButton.text"));
        this.thisMonthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomExplorerSettings.this.thisMonthButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.thisWeekButton, (String)NbBundle.getMessage(GedcomExplorerSettings.class, (String)"GedcomExplorerSettings.thisWeekButton.text"));
        this.thisWeekButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomExplorerSettings.this.thisWeekButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.todayButton, (String)NbBundle.getMessage(GedcomExplorerSettings.class, (String)"GedcomExplorerSettings.todayButton.text"));
        this.todayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomExplorerSettings.this.todayButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.nowButton, (String)NbBundle.getMessage(GedcomExplorerSettings.class, (String)"GedcomExplorerSettings.nowButton.text"));
        this.nowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GedcomExplorerSettings.this.nowButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.modifiedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fromModificationDate)).addGroup(layout.createSequentialGroup().addComponent(this.thisYearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.thisMonthButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.thisWeekButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.todayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nowButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modifiedLabel).addComponent(this.fromModificationDate, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nowButton).addComponent(this.todayButton).addComponent(this.thisWeekButton).addComponent(this.thisMonthButton).addComponent(this.thisYearButton)).addContainerGap()));
    }

    private void fromModificationDateStateChanged(ChangeEvent evt) {
        if (!this.initialised) {
            return;
        }
        Date value = (Date)this.fromModificationDate.getValue();
        long newMillisec = value.getTime();
        GedcomOptions.getInstance().setFromModificationDate(Long.toString(newMillisec));
        this.caller.setUpdateTree(this.oldMillisec != newMillisec);
    }

    private void nowButtonActionPerformed(ActionEvent evt) {
        this.fromModificationDate.setValue(new Date());
    }

    private void todayButtonActionPerformed(ActionEvent evt) {
        long millisec = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
        Date date = new Date(millisec);
        this.fromModificationDate.setValue(date);
    }

    private void thisWeekButtonActionPerformed(ActionEvent evt) {
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        LocalDateTime startOfWeek = startOfDay.minusDays(startOfDay.getDayOfWeek().getValue() - 1);
        long millisec = startOfWeek.toLocalDate().atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
        Date date = new Date(millisec);
        this.fromModificationDate.setValue(date);
    }

    private void thisMonthButtonActionPerformed(ActionEvent evt) {
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        LocalDateTime startOfMonth = startOfDay.minusDays(startOfDay.getDayOfMonth());
        long millisec = startOfMonth.toLocalDate().plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
        Date date = new Date(millisec);
        this.fromModificationDate.setValue(date);
    }

    private void thisYearButtonActionPerformed(ActionEvent evt) {
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        LocalDateTime startOfYear = startOfDay.minusDays(startOfDay.getDayOfYear());
        long millisec = startOfYear.toLocalDate().plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toEpochSecond() * 1000L;
        Date date = new Date(millisec);
        this.fromModificationDate.setValue(date);
    }
}

