/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;

public class NbinstURLMapper
extends URLMapper {
    public static final String PROTOCOL = "nbinst";
    private static final Logger LOG = Logger.getLogger(NbinstURLMapper.class.getName());

    public FileObject[] getFileObjects(URL url) {
        File f;
        if (PROTOCOL.equals(url.getProtocol()) && (f = NbinstURLMapper.decodeURL(url)) != null) {
            FileObject fo = FileUtil.toFileObject((File)f);
            if (fo != null) {
                return new FileObject[]{fo};
            }
            LOG.log(Level.WARNING, "could find no FileObject for {0}", f);
        }
        return null;
    }

    public URL getURL(FileObject fo, int type) {
        return null;
    }

    static File decodeURL(URL url) {
        assert (url != null);
        try {
            URI uri = new URI(url.toExternalForm());
            String protocol = uri.getScheme();
            if (PROTOCOL.equals(protocol)) {
                String module = uri.getAuthority();
                String path = uri.getPath();
                if (path.length() > 0) {
                    String relpath = path.substring(1).replaceFirst("/$", "");
                    return InstalledFileLocator.getDefault().locate(relpath, module, false);
                }
            }
        }
        catch (URISyntaxException x) {
            LOG.log(Level.WARNING, null, x);
        }
        return null;
    }
}

