;;; sc68 wrapper for Quartet (DIGISYNTH - MindBomb - TLB)
;;;
;;; by Benjamin Gerard
;;; 
;;; Time-stamp: <2011-09-12 15:10:47 ben>
;;; 

	include "lib/org.s"

	bra		Init
	bra		Kill
Play:
	pea		.rts(pc)
	move	sr,-(a7)
	bra		QuartetReplay
.rts:
	rts
		
Init:
	bsr 		SaveMfp			; PRESERVE INTERRUPTS
	movem.l	(a0),d5-d7
; 00 'QUAR'
; 04 offset from start to voice-set
; 08 number of songs
; 0C 1st song, offset from start
; 10 2nd song, ...
	
	cmp.l		#'QUAR',d5	;[ QUAR, Offset to voice set, max-song]
	bne.s		.rts
	subq.l	#1,d0
	divu		d7,d0
	swap		d0
	lsl			#2,d0
	move.l	$0c(a0,d0.w),d7
	add.l		a0,d6
	add.l		a0,d7

	move.w	sr,-(a7)	
	move		#$2700,sr
	lea			SONGP(pc),a6	
	move.l	d7,(a6)+	;SONGBUFFER
	move.l	d6,(a6)+	;VOICESET
	bsr			QuartetStart
	move.w	(a7)+,sr
.rts:	
	rts

Kill:
	bsr 		QuartetStop			;TURN OFF MUSIC
	bsr 		RestoreMfp				;RESTORE MFP
	rts

SONGP:		DC.L 	0
VOICEP:  	DC.L 	0

;********************************************************
;* HERE STARTS THE DIGISYNTH ROUTINE. WORK THIS ONE OUT *
;* FOR YOURELF!!!!    I'LL HELP WHERE I CAN             *
;********************************************************

L47ECE:
	LEA	L4B040,A4
	BSR	L47EF8
	LEA	L4B044,A4
	BSR	L47EF8
	LEA	L4B048,A4
	BSR	L47EF8
	LEA	L4B04C,A4
	BSR	L47EF8
	RTS
L47EF8	MOVE.W	#$52,$40(A4)
	MOVE.W	#1,$70(A4)
	MOVEA.L	$A0(A4),A0
	MOVEQ	#0,D0
	BRA	L47F1C
L47F0E	CMPI.W	#$50,(A0)
	BNE	L47F18
	ADDQ.W	#1,D0
L47F18	BSR	L480A0
L47F1C	CMPI.W	#$46,(A0)
	BNE	L47F0E
	TST.W	D0
	BEQ	L47F32
	MOVE.L	$A0(A4),$80(A4)
	RTS
L47F32	MOVE.L	#L47F44,$A0(A4)
	MOVE.L	#L47F44,$80(A4)
	RTS
L47F44	DC.B	0,$52,$27,$10,0,0,0,0
	DC.B	0,0,0,0,0,$46,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0
L47F66	LEA	L47FFC,A1
	MOVEA.L	L4B0E0,A0
	BSR	L48004
	LEA	L47FFE,A1
	MOVEA.L	L4B0E4,A0
	BSR	L48004
	LEA	L48000,A1
	MOVEA.L	L4B0E8,A0
	BSR	L48004
	LEA	L48002,A1
	MOVEA.L	L4B0EC,A0
	BSR	L48004
	RTS
L47FA8	MOVEQ	#0,D0
	MOVE.W	L47FFC,D0
	BEQ	L47FBE
	MOVEA.L	L4B0E0,A1
	BSR	L48058
L47FBE	MOVE.W	L47FFE,D0
	BEQ	L47FD2
	MOVEA.L	L4B0E4,A1
	BSR	L48058
L47FD2	MOVE.W	L48000,D0
	BEQ	L47FE6
	MOVEA.L	L4B0E8,A1
	BSR	L48058
L47FE6	MOVE.W	L48002,D0
	BEQ	L47FFA
	MOVEA.L	L4B0EC,A1
	BSR	L48058
L47FFA	RTS
L47FFC	DC.W 0
L47FFE	DC.W 0
L48000	DC.W 0
L48002	DC.W 0
L48004	CLR.W	(A1)
	MOVEQ	#0,D0
	MOVEA.L	A0,A6
L4800A	CMPI.W	#$46,(A0)
	BEQ	L48056
	CMPI.W	#$6C,(A0)
	BNE	L4801C
	ADDQ.W	#1,D0
L4801C	CMPI.W	#$4C,(A0)
	BNE	L4804E
	SUBQ.W	#1,D0
	BPL	L4804E
	MOVEM.L	D0/A0-A1,-(A7)
	MOVEA.L	A6,A1
	MOVE.L	#$C,D0
	BSR	L4807A
	MOVE.W	#$6C,(A6)
	MOVEM.L	(A7)+,D0/A0-A1
	ADDA.L	#$C,A0
	ADDI.W	#$C,(A1)
	ADDQ.W	#1,D0
L4804E	BSR	L480A0
	BRA	L4800A
L48056	RTS
L48058	MOVEA.L	A1,A0
	BRA	L48062
L4805E	BSR	L480A0
L48062	CMPI.W	#$46,(A0)
	BNE	L4805E
	ADDQ.L	#2,A0
	MOVEA.L	A1,A2
	ADDA.L	D0,A1
L48070	MOVE.W	(A1)+,(A2)+
	CMPA.L	A0,A1
	BNE	L48070
	RTS
L4807A	MOVEA.L	A1,A0
	BRA	L48084
L48080	BSR	L480A0
L48084	CMPI.W	#$46,(A0)
	BNE	L48080
	ADDA.L	#2,A0
	MOVEA.L	A0,A2
	ADDA.L	D0,A2
L48096	MOVE.W	-(A0),-(A2)
	CMPA.L	A0,A1
	BNE	L48096
	RTS
L480A0	CMPI.W	#$46,(A0)
	BEQ	L480AE
	ADDA.L	#$C,A0
L480AE	RTS

;************INITIALISATION ROUTINE******************

QuartetLaunch:
	LEA			L4B040(pc),A0
	MOVE.L	#$FF000000,(A0)+
	MOVE.L	#$FF000000,(A0)+
	MOVE.L	#$FF000000,(A0)+
	MOVE.L	#$FF000000,(A0)+
	CLR.L		(A0)+
	CLR.L		(A0)+
	CLR.L		(A0)+
	CLR.L		(A0)+
	MOVE.L	#$1000000,L4B070
	MOVE.L	#$1000000,L4B0D0
	MOVE.L	#$1000000,L4B074
	MOVE.L	#$1000000,L4B0D4
	MOVE.L	#$1000000,L4B078
	MOVE.L	#$1000000,L4B0D8
	MOVE.L	#$1000000,L4B07C
	MOVE.L	#$1000000,L4B0DC
	MOVE.L	#L4B430,L4B0F0
	MOVE.L	#L4B5C4,L4B0F4
	MOVE.L	#L4B758,L4B0F8
	MOVE.L	#L4B8EC,L4B0FC
	MOVE.B	#7,$FFFF8800.W
	MOVE.B	#$C0,D0
	AND.B		$FFFF8800.W,D0
	ORI.B		#%111111,D0
	MOVE.B	D0,$FFFF8802.W
	MOVE.B	#0,$FFFF8800.W
	CLR.B		$FFFF8802.W
	MOVE.B	#1,$FFFF8800.W
	CLR.B		$FFFF8802.W
	MOVE.B	#2,$FFFF8800.W
	CLR.B		$FFFF8802.W
	MOVE.B	#3,$FFFF8800.W
	CLR.B		$FFFF8802.W
	MOVE.B	#4,$FFFF8800.W
	CLR.B		$FFFF8802.W
	MOVE.B	#5,$FFFF8800.W
	CLR.B		$FFFF8802.W
	MOVE.W	#$2700,SR
;	MOVE.L	$114.W,Save114
;	MOVE.L	#QuartetReplay,$114.W
	move.l	_OutputIrq(pc),$134.W
	bclr	#3,$FFFFFA17.W
	BSR			QuartetSaveMfp
	BSR	L4AEFE
	MOVE.B	L4826C,$FFFFFA1F.W
	MOVE.B	#1,$FFFFFA19.W
	MOVE.L	#$FF000000,D0
	MOVE.L	#$FF000000,D1
	MOVE.L	#$FF000000,D2
	MOVE.L	#$FF000000,D3
	LEA	L4B040(PC),A0
	LEA	L4B040(PC),A1
	LEA	L4B040(PC),A2
	LEA	L4B040(PC),A3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVEA.L	L48268,A4
	CLR.L	L4AF20
	
	bclr	#5,$fffffa09.w
	bclr	#5,$fffffa15.w
;	moveq		#$0f,d7
;	and.b		$fffffa1d.w,d7
;	move.b	d7,$fffffa1d.w			; stop timer C
;	move.b	#244,$fffffa23.w		; Go at 200 hz (original ST frq)
;	or.b		#$40,d7
;	move.b	d7,$fffffa1d.w	; start timer C
;	bset	#5,$fffffa09.w
;	bset	#5,$fffffa15.w
	
	MOVE.W	#$2300,SR
	rts
	
L4825C	DC.L	0
L48260	DC.L	0
BL4825C	DC.L	0
;Save114	DC.L	0
_OutputIrq:	DC.L	QuartetOutputIrq
L48268	DC.L 	$FFFF8800
L4826C	DC.B	$2C,0

QuartetRestoreHw:
	MOVE.B	#7,$FFFF8800.W
	MOVE.B	#7,D0
	OR.B		$FFFF8800.W,D0
	MOVE.B	D0,$FFFF8802.W
	MOVE.W	#$2700,SR
	MOVE.B	#$E,$FFFF8800.W
	MOVE.B	#6,$FFFF8802.W
	
	MOVE.L	$134.W,_OutputIrq
	MOVE.L	A4,L48268
	move.L	BL4825C,$118.W
;	MOVE.L	Save114,$114.W
	BSR	L4AEB6
	BSET	#3,$FFFFFA17.W
	MOVE.W	#$2300,SR
	RTS

; *************THE TIMER A OUTPUT ROUTINE*****************

QuartetOutputIrq:
	SWAP	D0
	SWAP	D1
	SWAP	D2
	SWAP	D3
	MOVEQ	#0,D4
	MOVE.B	0(A0,D0.W),D5
	MOVE.B	0(A1,D1.W),D4
	ADD.W	D4,D5
	MOVE.B	0(A2,D2.W),D4
	ADD.W	D4,D5
	MOVE.B	0(A3,D3.W),D4
	ADD.W	D4,D5
	SWAP	D0
	SWAP	D1
	SWAP	D2
	SWAP	D3
	LSL.W	#3,D5
	MOVE.L	SOUNDTAB(PC,D5.W),D4
	MOVEP.L	D4,0(A4)
	MOVE.W	SOUNDTAB+4(PC,D5.W),D4
	MOVEP.W	D4,0(A4)
	MOVEQ	#0,D5
	ADD.L	L4B050(PC),D0
	ADDX.W	D5,D5
	ADD.L	L4B054(PC),D1
	ADDX.W	D5,D5
	ADD.L	L4B058(PC),D2
	ADDX.W	D5,D5
	ADD.L	L4B05C(PC),D3
	ADDX.W	D5,D5
	TST.W	D5
	BNE	L4AB82
	RTE
SOUNDTAB
	INCBIN	"org/quartet_table.bin"

; *********************ROUTINE TO CHECK WHETHER NOTE SHOULD BE ENDED
; *********************OR SUSTAINED

L4AB82	BCLR	#3,D5
	BEQ	L4ABAA
	TST.W	L4B072
	BEQ	L4ABA4
	LEA	L4B040(PC),A0
	MOVE.L	#$1000000,L4B070
L4ABA4	SUB.L	L4B070,D0
L4ABAA	BCLR	#2,D5
	BEQ	L4ABD2
	TST.W	L4B076
	BEQ	L4ABCC
	LEA	L4B040(PC),A1
	MOVE.L	#$1000000,L4B074
L4ABCC	SUB.L	L4B074,D1
L4ABD2	BCLR	#1,D5
	BEQ	L4ABFA
	TST.W	L4B07A
	BEQ	L4ABF4
	LEA	L4B040(PC),A2
	MOVE.L	#$1000000,L4B078
L4ABF4	SUB.L	L4B078(PC),D2
L4ABFA	BCLR	#0,D5
	BEQ	L4AC22
	TST.W	L4B07E
	BEQ	L4AC1C
	LEA	L4B040(PC),A3
	MOVE.L	#$1000000,L4B07C
L4AC1C	SUB.L	L4B07C,D3
L4AC22	RTE

; ******************THE TIMER C MANAGEMENT ROUTINE

QuartetReplay:
	MOVE.W	#$2500,SR
	MOVEM.L	D6-D7/A5-A6,-(A7)
	LEA	L4B040(PC),A5
	BSR	L4ACC4
	LEA	L4B044(PC),A5
	BSR	L4ACC4
	LEA	L4B048(PC),A5
	BSR	L4ACC4
	LEA	L4B04C(PC),A5
	BSR	L4ACC4
	LEA	L4B040(PC),A5
	CLR.W 	FULLVOL
	BSR	L4AD0E
	CMP.W 	#0,FULLVOL
	BEQ.S 	N2
	MOVE.W 	#30,CHAN1
N2	LEA	L4B044(PC),A5
	CLR.W 	FULLVOL
	BSR	L4AD0E
	CMP.W 	#0,FULLVOL
	BEQ.S 	N3
	MOVE.W 	#30,CHAN2
N3	LEA	L4B048(PC),A5
	CLR.W 	FULLVOL
	BSR	L4AD0E
	CMP.W 	#0,FULLVOL
	BEQ.S 	N4
	MOVE.W 	#30,CHAN3
N4	LEA	L4B04C(PC),A5
	CLR.W 	FULLVOL
	BSR.S	L4AD0E
	CMP.W 	#0,FULLVOL
	BEQ.S 	N5
	MOVE.W 	#30,CHAN4
N5	MOVEM.L	(A7)+,D6-D7/A5-A6
	RTE

CHAN1	DC.W 0
CHAN2	DC.W 0
CHAN3	DC.W 0
CHAN4	DC.W 0

L4ACC4	CMPI.W	#$53,$40(A5)
	BNE	L4AD0C
	MOVE.L	$50(A5),D6
	ADD.L	$10(A5),D6
	MOVE.L	D6,$10(A5)
	TST.L	$50(A5)
	BMI	L4ACF8
	CMP.L	$60(A5),D6
	BLT	L4AD0C
	MOVE.W	#$50,$40(A5)
	MOVE.L	$60(A5),$10(A5)
	RTS
L4ACF8	CMP.L	$60(A5),D6
	BGT	L4AD0C
	MOVE.W	#$50,$40(A5)
	MOVE.L	$60(A5),$10(A5)
L4AD0C	RTS
L4AD0E	SUBQ.W	#1,$70(A5)
	BNE	L4AD62
	MOVE.W #1,FULLVOL
L4AD16	MOVEA.L	$80(A5),A6
	ADDI.L	#$C,$80(A5)
	MOVE.W	(A6),D6
	MOVE.W	D6,$40(A5)

	CMP.W	#$50,D6
	BEQ	L4AD64
	CMP.W	#$52,D6		;BLANK SOUND?
	BEQ	L4AD86
	CMP.W	#$46,D6		;RESTART TRACK
	BEQ	L4ADA4
	CMP.W	#$56,D6		;LOOP
	BEQ	L4ADAE
	CMP.W	#$6C,D6
	BEQ	L4ADD2
	CMP.W	#$4C,D6
	BEQ	L4ADE4
	CMP.W	#$53,D6		;NEW SAMPLE
	BEQ	L4AE16
L4AD60	RTS
L4AD62	RTS
L4AD64	MOVE.L	0(A5),D6
	MOVE.L	$20(A5),D7
	BSR	L4AE2C
	MOVE.L	$90(A5),$30(A5)
	MOVE.L	4(A6),$10(A5)
	MOVE.W	2(A6),$70(A5)
	BRA.S	L4AD60

L4AD86
	CLR.W FULLVOL
	MOVE.L	#$FF000000,D6		;BLANK SOUND
	MOVE.L	#L4B040,D7
	BSR	L4AE2C
	CLR.L	$10(A5)
	MOVE.W	2(A6),$70(A5)
	BRA.S	L4AD60

L4ADA4	MOVE.L	$A0(A5),$80(A5)		;RESTART TRACK ROUTINE
	BRA	L4AD16

L4ADAE	MOVEA.L	8(A6),A6		;LOOP ROUTINE
	MOVE.L	-4(A6),0(A5)
	NEG.L	0(A5)
	MOVE.L	-8(A6),$90(A5)
	MOVEQ	#0,D7
	MOVE.W	-4(A6),D7
	ADDA.L	D7,A6
	MOVE.L	A6,$20(A5)
	BRA	L4AD16

L4ADD2	MOVEA.L	$B0(A5),A6
	MOVE.L	$80(A5),-(A6)
	CLR.W	-(A6)
	MOVE.L	A6,$B0(A5)
	BRA	L4AD16

L4ADE4	MOVE.W	8(A6),D7
	MOVEA.L	$B0(A5),A6
	MOVE.W	(A6)+,D6
	TST.W	D6
	BNE	L4ADF8
	MOVE.W	D7,D6
	ADDQ.W	#1,D6
L4ADF8	SUBQ.W	#1,D6
	BEQ	L4AE0C
	MOVE.L	(A6),$80(A5)
	MOVE.W	D6,-(A6)
	MOVE.L	A6,$B0(A5)
	BRA	L4AD16

L4AE0C	ADDQ.L	#4,A6
	MOVE.L	A6,$B0(A5)
	BRA	L4AD16

L4AE16	MOVE.L	4(A6),$60(A5)
	MOVE.W	2(A6),$70(A5)
	MOVE.L	8(A6),$50(A5)
	MOVE.W 	#1,FULLVOL
	BRA	L4AD60

L4AE2C	CMPA.L	#L4B040,A5
	BEQ	L4AE56
	CMPA.L	#L4B044,A5
	BEQ	L4AE5C
	CMPA.L	#L4B048,A5
	BEQ	L4AE62
	CMPA.L	#L4B04C,A5
	BEQ	L4AE68
	RTS
L4AE56	MOVE.L	D6,D0
	MOVEA.L	D7,A0
	RTS
L4AE5C	MOVE.L	D6,D1
	MOVEA.L	D7,A1
	RTS
L4AE62	MOVE.L	D6,D2
	MOVEA.L	D7,A2
	RTS
L4AE68	MOVE.L	D6,D3
	MOVEA.L	D7,A3
	RTS
QuartetSaveMfp:
	lea			BL4AF28(pc),a0
	MOVE.B	$FFFFFA07.w,BL4AF28-BL4AF28(a0)
	MOVE.B	$FFFFFA09.w,BL4AF29-BL4AF28(a0)
	MOVE.B	$FFFFFA13.w,BL4AF2A-BL4AF28(a0)
	MOVE.B	$FFFFFA15.w,BL4AF2B-BL4AF28(a0)
	MOVE.B	$FFFFFA1F.w,BL4AF2C-BL4AF28(a0)
	MOVE.B	$FFFFFA19.w,BL4AF2D-BL4AF28(a0)
	MOVE.B	$FFFFFA17.w,BL4AF2E-BL4AF28(a0)
	MOVE.B  $FFFFFA1B.W,BOLD1B-BL4AF28(a0)
	MOVE.B  $FFFFFA21.W,BOLD21-BL4AF28(a0)
	MOVE.B  $FFFFFA0F.W,BOLD0F-BL4AF28(a0)
	RTS

SaveMfp:
	pea		(a0)
	lea		MfpBuf(pc),a0
	move.w 	#$2700,sr
	move.l	$114.w,(a0)+
	move.l	$118.w,(a0)+
	move.b	$fffffa07.w,(a0)+
	move.b	$fffffa09.w,(a0)+
	move.b	$fffffa13.w,(a0)+
	move.b	$fffffa15.w,(a0)+
	move.b	$fffffa1f.w,(a0)+
	move.b	$fffffa19.w,(a0)+
	move.b	$fffffa17.w,(a0)+
	move.b  $fffffa1b.w,(a0)+
	move.b  $fffffa0f.w,(a0)+
	move.w 	#$2300,sr
	move.l	(a7)+,a0
	rts
	
RestoreMfp:
	pea		(a0)
	lea		MfpBuf(pc),a0
	move.w 	#$2700,sr
	move.l	(a0)+,$114.w			
	move.l	(a0)+,$118.w			
	move.b	(a0)+,$fffffa07.w
	move.b	(a0)+,$fffffa09.w
	move.b	(a0)+,$fffffa13.w
	move.b	(a0)+,$fffffa15.w
	move.b	(a0)+,$fffffa1f.w
	move.b	(a0)+,$fffffa19.w
	move.b	(a0)+,$fffffa17.w
	move.b  (a0)+,$fffffa1b.w
	move.b  (a0)+,$fffffa0f.w
	move.w #$2300,sr
	move.l	(a7)+,a0
	rts

MfpBuf:
	ds.b		32
	
L4AEB6
	MOVE.B	BL4AF2E,$FFFA17
	MOVE.B	BL4AF2D,$FFFA19
	MOVE.B	BL4AF2C,$FFFA1F
	MOVE.B	BL4AF2B,$FFFA15
	MOVE.B	BL4AF2A,$FFFA13
	MOVE.B	BL4AF29,$FFFA09
	MOVE.B	BL4AF28,$FFFA07
	MOVE.B  BOLD1B,$FFFFFA1B.W
	MOVE.B  BOLD21,$FFFFFA21.W
	MOVE.B  BOLD0F,$FFFFFA0F.W
	RTS

L4AEFE	MOVE.B	#$21,$FFFA13
	MOVE.B	#$60,$FFFA15
	MOVE.B	#$21,$FFFA07
	MOVE.B	#$60,$FFFA09
	RTS
FULLVOL	DC.W 	0
OLD1B	DC.W	0
OLD21	DC.W 	0
OLD0F	DC.W 	0
BOLD1B	DC.W	0
BOLD21	DC.W 	0
BOLD0F	DC.W 	0
L4AF20	DC.B	0,0,0,0,0,0,0,0
L4AF28	DC.B	0
L4AF29	DC.B	0
L4AF2A	DC.B	0
L4AF2B	DC.B 	0
L4AF2C	DC.B 	0
L4AF2D	DC.B	0
L4AF2E	DC.B	0,0
BL4AF28	DC.B	0
BL4AF29	DC.B	0
BL4AF2A	DC.B	0
BL4AF2B	DC.B 	0
BL4AF2C	DC.B 	0
BL4AF2D	DC.B	0
BL4AF2E	DC.B	0,0

	DC.B	0,0,0,0,0,0,0,0
	DC.B	1,0,0,0,1,0,0,0
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
	DC.B	$80,$80,$80,$80,$80,$80,$80,$80
L4B040	DC.L	0
L4B044	DC.L    0
L4B048	DC.L	0
L4B04C  DC.L    0
L4B050	DC.L	0
L4B054	DC.L	0
L4B058	DC.L	0
L4B05C	DC.L    0
L4B060	DC.L 	L4B040
L4B064	DC.L 	L4B040
L4B068	DC.L 	L4B040
L4B06C	DC.L 	L4B040
L4B070	DC.B	0,0
L4B072	DC.B	0,0
L4B074	DC.B	0,0
L4B076	DC.B	0,0
L4B078	DC.B	0,0
L4B07A	DC.B	0,0
L4B07C	DC.B	0,0
L4B07E	DC.B	0,0
	DC.B	0,0,0,$52,0,0,0,$52
	DC.B	0,0,0,$52,0,0,0,$52
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,1,0,0,0,1
	DC.B	0,0,0,1,0,0,0,1
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
L4B0D0	DC.B	0,0,0,0
L4B0D4	DC.B 	0,0,0,0
L4B0D8	DC.B	0,0,0,0
L4B0DC	DC.B 	0,0,0,0
L4B0E0	DC.B	0,0,0,0
L4B0E4	DC.B 	0,0,0,0
L4B0E8	DC.B	0,0,0,0
L4B0EC	DC.B 	0,0,0,0
L4B0F0	DC.L	L4B430
L4B0F4	DC.L 	L4B5C4
L4B0F8	DC.L	L4B758
L4B0FC	DC.L 	L4B8EC
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
L4B430	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0
L4B5C4	DC.B	0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
L4B758	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0,0,0,0,0
	DC.B	0,0,0,0
L4B8EC	DC.B	0,0,0,0

QuartetStart:
	BSR	L4B9D6
	MOVEM.L	L4BAC0,D0-D3
	MOVEM.L	D0-D3,L4B0E0
	BSR	L47ECE
	BSR	L47F66
	bsr	QuartetLaunch
	rts
	
QuartetStop:
	CLR.W 	CHAN1
	CLR.W 	CHAN2
	CLR.W 	CHAN3
	CLR.W 	CHAN4
	bsr	QuartetRestoreHw
	BSR	L47FA8
	BSR	L4BA7A
	rts
	
L4B94A:
	CMPI.W	#$46,(A0)
	BEQ	L4B988
	CMPI.W	#$56,(A0)
	BNE	L4B978
	MOVE.L	8(A0),D0
	CLR.L	D1
	LEA	L4BAD0,A1
L4B966:
	CMP.L	0(A1,D1.L),D0
	BEQ	L4B974
	ADDQ.L	#4,D1
	BRA	L4B966
L4B974	MOVE.L	D1,8(A0)
L4B978	CMPI.W	#$46,(A0)
	BEQ	L4B984
	ADDA.W	#$C,A0
L4B984	BRA	L4B94A
L4B988	RTS
L4B98A	CMPI.W	#$46,(A0)
	BEQ	L4B9D4
	CMPI.W	#$56,(A0)
	BNE	L4B9C4
	MOVE.L	8(A0),D0
	LEA	L4BAD0,A1
	MOVE.L	0(A1,D0.L),8(A0)
	MOVE.L	VOICEP,D0
	ADDI.L	#8,D0
	CMP.L	8(A0),D0
	BNE	L4B9C4
	MOVE.L	0(A1),8(A0)
L4B9C4	CMPI.W	#$46,(A0)
	BEQ	L4B9D0
	ADDA.W	#$C,A0
L4B9D0	BRA	L4B98A
L4B9D4	rts

L4B9D6
	MOVEA.L	VOICEP,A5
	ADDA.W	#$8E,A5
	LEA	L4BAD0,A4
	MOVEQ	#$13,D0
L4B9E8
	MOVE.L	(A5)+,D1
	ADD.L	VOICEP,D1
	ADDI.L	#8,D1
	MOVE.L	D1,(A4)+
	DBF	D0,L4B9E8
	MOVEA.L	SONGP,A0
	MOVE.W	(A0),D0
	BSR	L4BAA4
	ADDA.W	#$10,A0
	MOVE.L	A0,L4BAC0
	BSR	L4BA5A
	MOVE.L	A0,L4BAC4
	BSR	L4BA5A
	MOVE.L	A0,L4BAC8
	BSR	L4BA5A
	MOVE.L	A0,L4BACC
	MOVEA.L	L4BAC0,A0
	BSR	L4B98A
	MOVEA.L	L4BAC4,A0
	BSR	L4B98A
	MOVEA.L	L4BAC8,A0
	BSR	L4B98A
	MOVEA.L	L4BACC,A0
	BSR	L4B98A
	RTS
L4BA5A	CMPI.W	#$46,(A0)
	BEQ	L4BA72
	CMPI.W	#$46,(A0)
	BEQ	L4BA6E
	ADDA.W	#$C,A0
L4BA6E	BRA	L4BA5A
L4BA72	ADDA.L	#$C,A0
	RTS
L4BA7A	MOVEA.L	L4BAC0,A0
	BSR	L4B94A
	MOVEA.L	L4BAC4,A0
	BSR	L4B94A
	MOVEA.L	L4BAC8,A0
	BSR	L4B94A
	MOVEA.L	L4BACC,A0
	BSR	L4B94A
	RTS
L4BAA4	MOVE.B	POINT-2(PC,D0.W),L4826C
POINT	RTS
	DC.B	$98,$7A,$66,$58,$4C,$44,$3D,$38
	DC.B	$33,$2F,$2C,$29,$26,$24,$22,$20
	DC.B	$1E,0,0,0,0,0,0,0
L4BAC0	DC.L	0
L4BAC4	DC.L	0
L4BAC8	DC.L	0
L4BACC	DC.L	0
L4BAD0	DS.L 	20

