/* -*- indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

const TEST_PAGE_URL = URL_ROOT + "page_basic.html";
const JSON_XHR_URL = URL_ROOT + "test.json";

/**
 * This test generates XHR requests in the page, expands
 * networks details in the Console panel and checks that
 * HTTP parameters (query string) are there.
 */
add_task(function* () {
  info("Test XHR Spy params started");

  let {hud} = yield addTestTab(TEST_PAGE_URL);

  let netInfoBody = yield executeAndInspectXhr(hud, {
    method: "GET",
    url: JSON_XHR_URL,
    queryString: "?foo=bar"
  });

  // Check headers
  let tabBody = yield selectNetInfoTab(hud, netInfoBody, "params");

  let paramName = tabBody.querySelector(
    ".netInfoParamName > span[title='foo']");

  // Verify "Content-Type" header (name and value)
  ok(paramName, "Header name must exist");
  is(paramName.textContent, "foo",
    "The param name must have proper value");

  let paramValue = paramName.parentNode.nextSibling;
  ok(paramValue, "param value must exist");
  is(paramValue.textContent, "bar",
    "The param value must have proper value");
});

/**
 * Test URL parameters with the same name.
 */
add_task(function* () {
  info("Test XHR Spy params started");

  let {hud} = yield addTestTab(TEST_PAGE_URL);

  let netInfoBody = yield executeAndInspectXhr(hud, {
    method: "GET",
    url: JSON_XHR_URL,
    queryString: "?box[]=123&box[]=456"
  });

  // Check headers
  let tabBody = yield selectNetInfoTab(hud, netInfoBody, "params");

  let params = tabBody.querySelectorAll(
    ".netInfoParamName > span[title='box[]']");
  is(params.length, 2, "Two URI parameters must exist");

  let values = tabBody.querySelectorAll(
    ".netInfoParamValue > code");
  is(values[0].textContent, 123, "First value must match");
  is(values[1].textContent, 456, "Second value must match");
});
