/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;

public class File
extends ScriptableObject {
    private static final long serialVersionUID = 2549960399774237828L;
    private String name;
    private java.io.File file;
    private LineNumberReader reader;
    private BufferedWriter writer;

    @JSConstructor
    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        File file = new File();
        if (objectArray.length == 0 || objectArray[0] == Context.getUndefinedValue()) {
            file.name = "";
            file.file = null;
        } else {
            file.name = Context.toString((Object)objectArray[0]);
            file.file = new java.io.File(file.name);
        }
        return file;
    }

    public String getClassName() {
        return "File";
    }

    @JSGetter
    public String getName() {
        return this.name;
    }

    @JSFunction
    public Object readLines() throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = this.readLine()) != null) {
            arrayList.add(string);
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        Context context = Context.getCurrentContext();
        return context.newObject(scriptable, "Array", objectArray);
    }

    @JSFunction
    public String readLine() throws IOException {
        return this.getReader().readLine();
    }

    @JSFunction
    public String readChar() throws IOException {
        int n = this.getReader().read();
        if (n == -1) {
            return null;
        }
        char[] cArray = new char[]{(char)n};
        return new String(cArray);
    }

    @JSFunction
    public static void write(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        File.write0(scriptable, objectArray, false);
    }

    @JSFunction
    public static void writeLine(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        File.write0(scriptable, objectArray, true);
    }

    @JSGetter
    public int getLineNumber() throws FileNotFoundException {
        return this.getReader().getLineNumber();
    }

    @JSFunction
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        } else if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JSFunction(value="getReader")
    public Object getJSReader() {
        if (this.reader == null) {
            return null;
        }
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        return Context.javaToJS((Object)this.reader, (Scriptable)scriptable);
    }

    @JSFunction
    public Object getWriter() {
        if (this.writer == null) {
            return null;
        }
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)this);
        return Context.javaToJS((Object)this.writer, (Scriptable)scriptable);
    }

    private LineNumberReader getReader() throws FileNotFoundException {
        if (this.writer != null) {
            throw Context.reportRuntimeError((String)("already writing file \"" + this.name + "\""));
        }
        if (this.reader == null) {
            this.reader = new LineNumberReader(this.file == null ? new InputStreamReader(System.in) : new FileReader(this.file));
        }
        return this.reader;
    }

    private static void write0(Scriptable scriptable, Object[] objectArray, boolean bl) throws IOException {
        File file = File.checkInstance(scriptable);
        if (file.reader != null) {
            throw Context.reportRuntimeError((String)("already writing file \"" + file.name + "\""));
        }
        if (file.writer == null) {
            file.writer = new BufferedWriter(file.file == null ? new OutputStreamWriter(System.out) : new FileWriter(file.file));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = Context.toString((Object)objectArray[i]);
            file.writer.write(string, 0, string.length());
        }
        if (bl) {
            file.writer.newLine();
        }
    }

    private static File checkInstance(Scriptable scriptable) {
        if (scriptable == null || !(scriptable instanceof File)) {
            throw Context.reportRuntimeError((String)"called on incompatible object");
        }
        return (File)scriptable;
    }
}

