/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.piccolo.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xmlbeans.impl.piccolo.util.FactoryServiceFinder;
import org.apache.xmlbeans.impl.piccolo.xml.Piccolo;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JAXPSAXParserFactory
extends SAXParserFactory {
    private Map featureMap = new HashMap();
    private static Boolean TRUE = new Boolean(true);
    private static Boolean FALSE = new Boolean(false);
    private Piccolo nvParser = new Piccolo();
    private SAXParserFactory validatingFactory;
    private static final String VALIDATING_PROPERTY = "org.apache.xmlbeans.impl.piccolo.xml.ValidatingSAXParserFactory";
    private static Class validatingFactoryClass = JAXPSAXParserFactory.findValidatingFactory();
    private ParserConfigurationException pendingValidatingException = null;
    private ParserConfigurationException pendingNonvalidatingException = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    public static SAXParserFactory newInstance() {
        return new JAXPSAXParserFactory();
    }

    public JAXPSAXParserFactory() {
        try {
            if (validatingFactoryClass != null) {
                this.validatingFactory = (SAXParserFactory)validatingFactoryClass.newInstance();
                this.validatingFactory.setNamespaceAware(false);
                this.validatingFactory.setValidating(true);
            }
        }
        catch (Exception e) {
            this.validatingFactory = null;
        }
        this.setNamespaceAware(false);
    }

    @Override
    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (this.validating && this.validatingFactory != null) {
            return this.validatingFactory.getFeature(name);
        }
        return this.nvParser.getFeature(name);
    }

    @Override
    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        if (this.validating) {
            if (this.validatingFactory == null) {
                throw new ParserConfigurationException("XML document validation is not supported");
            }
            if (this.pendingValidatingException != null) {
                throw this.pendingValidatingException;
            }
            return this.validatingFactory.newSAXParser();
        }
        if (this.pendingNonvalidatingException != null) {
            throw this.pendingNonvalidatingException;
        }
        return new JAXPSAXParser(new Piccolo(this.nvParser));
    }

    @Override
    public void setFeature(String name, boolean enabled) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.featureMap.put(name, enabled ? TRUE : FALSE);
        if (this.validatingFactory != null) {
            if (this.pendingValidatingException != null) {
                this.reconfigureValidating();
            } else {
                try {
                    this.validatingFactory.setFeature(name, enabled);
                }
                catch (ParserConfigurationException e) {
                    this.pendingValidatingException = e;
                }
            }
        }
        if (this.pendingNonvalidatingException != null) {
            this.reconfigureNonvalidating();
        }
        if (this.validating && this.pendingValidatingException != null) {
            throw this.pendingValidatingException;
        }
        if (!this.validating && this.pendingNonvalidatingException != null) {
            throw this.pendingNonvalidatingException;
        }
    }

    @Override
    public void setNamespaceAware(boolean awareness) {
        super.setNamespaceAware(awareness);
        this.namespaceAware = awareness;
        try {
            this.nvParser.setFeature("http://xml.org/sax/features/namespaces", awareness);
            this.nvParser.setFeature("http://xml.org/sax/features/namespace-prefixes", !awareness);
        }
        catch (SAXNotSupportedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException("Error setting namespace feature: " + e.toString());
        }
        catch (SAXNotRecognizedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException("Error setting namespace feature: " + e.toString());
        }
        if (this.validatingFactory != null) {
            this.validatingFactory.setNamespaceAware(awareness);
        }
    }

    @Override
    public void setValidating(boolean value) {
        super.setValidating(value);
        this.validating = value;
    }

    private static Class findValidatingFactory() {
        try {
            String validatingClassName = System.getProperty(VALIDATING_PROPERTY);
            if (validatingClassName != null) {
                return Class.forName(validatingClassName);
            }
        }
        catch (Exception validatingClassName) {
            // empty catch block
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String validatingClassName = props.getProperty(VALIDATING_PROPERTY);
                if (validatingClassName != null) {
                    return Class.forName(validatingClassName);
                }
            }
        }
        catch (Exception javah) {
            // empty catch block
        }
        try {
            Enumeration enumValue = FactoryServiceFinder.findServices("javax.xml.parsers.SAXParserFactory");
            while (enumValue.hasMoreElements()) {
                try {
                    String factory = (String)enumValue.nextElement();
                    if (factory.equals("org.apache.xmlbeans.impl.piccolo.xml.Piccolo")) continue;
                    return Class.forName(factory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Exception enumValue) {
            // empty catch block
        }
        try {
            return Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void reconfigureValidating() {
        if (this.validatingFactory == null) {
            return;
        }
        try {
            for (Map.Entry entry : this.featureMap.entrySet()) {
                this.validatingFactory.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        catch (ParserConfigurationException e) {
            this.pendingValidatingException = e;
        }
        catch (SAXNotRecognizedException e) {
            this.pendingValidatingException = new ParserConfigurationException(e.toString());
        }
        catch (SAXNotSupportedException e) {
            this.pendingValidatingException = new ParserConfigurationException(e.toString());
        }
    }

    private void reconfigureNonvalidating() {
        try {
            for (Map.Entry entry : this.featureMap.entrySet()) {
                this.nvParser.setFeature((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        catch (SAXNotRecognizedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException(e.toString());
        }
        catch (SAXNotSupportedException e) {
            this.pendingNonvalidatingException = new ParserConfigurationException(e.toString());
        }
    }

    static class JAXPSAXParser
    extends SAXParser {
        Piccolo parser;

        JAXPSAXParser(Piccolo parser) {
            this.parser = parser;
        }

        @Override
        public Parser getParser() {
            return this.parser;
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return this.parser.getProperty(name);
        }

        @Override
        public XMLReader getXMLReader() {
            return this.parser;
        }

        @Override
        public boolean isNamespaceAware() {
            return this.parser.fNamespaces;
        }

        @Override
        public boolean isValidating() {
            return false;
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
            this.parser.setProperty(name, value);
        }
    }
}

