/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.util.LinkedList;
import java.util.List;
import jline.Completor;
import jline.ConsoleReader;

public class ArgumentCompletor
implements Completor {
    final Completor[] completors;
    final ArgumentDelimiter delim;
    boolean strict = true;

    public ArgumentCompletor(Completor completor) {
        this(new Completor[]{completor});
    }

    public ArgumentCompletor(List completors) {
        this(completors.toArray(new Completor[completors.size()]));
    }

    public ArgumentCompletor(Completor[] completors) {
        this(completors, (ArgumentDelimiter)new WhitespaceArgumentDelimiter());
    }

    public ArgumentCompletor(Completor completor, ArgumentDelimiter delim) {
        this(new Completor[]{completor}, delim);
    }

    public ArgumentCompletor(Completor[] completors, ArgumentDelimiter delim) {
        this.completors = completors;
        this.delim = delim;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean getStrict() {
        return this.strict;
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        ArgumentList list = this.delim.delimit(buffer, cursor);
        int argpos = list.getArgumentPosition();
        int argIndex = list.getCursorArgumentIndex();
        if (argIndex < 0) {
            return -1;
        }
        Completor comp = argIndex >= this.completors.length ? this.completors[this.completors.length - 1] : this.completors[argIndex];
        for (int i = 0; this.getStrict() && i < argIndex; ++i) {
            Completor sub = this.completors[i >= this.completors.length ? this.completors.length - 1 : i];
            String[] args = list.getArguments();
            String arg = args == null || i >= args.length ? "" : args[i];
            LinkedList subCandidates = new LinkedList();
            if (sub.complete(arg, arg.length(), subCandidates) == -1) {
                return -1;
            }
            if (subCandidates.size() != 0) continue;
            return -1;
        }
        int ret = comp.complete(list.getCursorArgument(), argpos, candidates);
        if (ret == -1) {
            return -1;
        }
        int pos = ret + (list.getBufferPosition() - argpos);
        if (cursor != buffer.length() && this.delim.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                String val = candidates.get(i).toString();
                while (val.length() > 0 && this.delim.isDelimiter(val, val.length() - 1)) {
                    val = val.substring(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
        ConsoleReader.debug("Completing " + buffer + "(pos=" + cursor + ") with: " + candidates + ": offset=" + pos);
        return pos;
    }

    public static class ArgumentList {
        private String[] arguments;
        private int cursorArgumentIndex;
        private int argumentPosition;
        private int bufferPosition;

        public ArgumentList(String[] arguments, int cursorArgumentIndex, int argumentPosition, int bufferPosition) {
            this.arguments = arguments;
            this.cursorArgumentIndex = cursorArgumentIndex;
            this.argumentPosition = argumentPosition;
            this.bufferPosition = bufferPosition;
        }

        public void setCursorArgumentIndex(int cursorArgumentIndex) {
            this.cursorArgumentIndex = cursorArgumentIndex;
        }

        public int getCursorArgumentIndex() {
            return this.cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this.cursorArgumentIndex < 0 || this.cursorArgumentIndex >= this.arguments.length) {
                return null;
            }
            return this.arguments[this.cursorArgumentIndex];
        }

        public void setArgumentPosition(int argumentPosition) {
            this.argumentPosition = argumentPosition;
        }

        public int getArgumentPosition() {
            return this.argumentPosition;
        }

        public void setArguments(String[] arguments) {
            this.arguments = arguments;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setBufferPosition(int bufferPosition) {
            this.bufferPosition = bufferPosition;
        }

        public int getBufferPosition() {
            return this.bufferPosition;
        }
    }

    public static class WhitespaceArgumentDelimiter
    extends AbstractArgumentDelimiter {
        @Override
        public boolean isDelimiterChar(String buffer, int pos) {
            return Character.isWhitespace(buffer.charAt(pos));
        }
    }

    public static abstract class AbstractArgumentDelimiter
    implements ArgumentDelimiter {
        private char[] quoteChars = new char[]{'\'', '\"'};
        private char[] escapeChars = new char[]{'\\'};

        public void setQuoteChars(char[] quoteChars) {
            this.quoteChars = quoteChars;
        }

        public char[] getQuoteChars() {
            return this.quoteChars;
        }

        public void setEscapeChars(char[] escapeChars) {
            this.escapeChars = escapeChars;
        }

        public char[] getEscapeChars() {
            return this.escapeChars;
        }

        @Override
        public ArgumentList delimit(String buffer, int cursor) {
            LinkedList<String> args = new LinkedList<String>();
            StringBuffer arg = new StringBuffer();
            int argpos = -1;
            int bindex = -1;
            for (int i = 0; buffer != null && i <= buffer.length(); ++i) {
                if (i == cursor) {
                    bindex = args.size();
                    argpos = arg.length();
                }
                if (i == buffer.length() || this.isDelimiter(buffer, i)) {
                    if (arg.length() <= 0) continue;
                    args.add(arg.toString());
                    arg.setLength(0);
                    continue;
                }
                arg.append(buffer.charAt(i));
            }
            return new ArgumentList(args.toArray(new String[args.size()]), bindex, argpos, cursor);
        }

        @Override
        public boolean isDelimiter(String buffer, int pos) {
            if (this.isQuoted(buffer, pos)) {
                return false;
            }
            if (this.isEscaped(buffer, pos)) {
                return false;
            }
            return this.isDelimiterChar(buffer, pos);
        }

        public boolean isQuoted(String buffer, int pos) {
            return false;
        }

        public boolean isEscaped(String buffer, int pos) {
            if (pos <= 0) {
                return false;
            }
            for (int i = 0; this.escapeChars != null && i < this.escapeChars.length; ++i) {
                if (buffer.charAt(pos) != this.escapeChars[i]) continue;
                return !this.isEscaped(buffer, pos - 1);
            }
            return false;
        }

        public abstract boolean isDelimiterChar(String var1, int var2);
    }

    public static interface ArgumentDelimiter {
        public ArgumentList delimit(String var1, int var2);

        public boolean isDelimiter(String var1, int var2);
    }
}

