/* Copyright 2001 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* Define the machine-dependent type `jmp_buf'.  AM33 version. */
#ifndef _BITS_SETJMP_H
#define _BITS_SETJMP_H  1

#if !defined _SETJMP_H && !defined _PTHREAD_H
# error "Never include <bits/setjmp.h> directly; use <setjmp.h> instead."
#endif

#ifndef _ASM
typedef int __jmp_buf[26];
#endif

#define __JMP_BUF_D2	        0
#define __JMP_BUF_D3	        1
#define __JMP_BUF_MDR	        2
#define __JMP_BUF_A2	        3
#define __JMP_BUF_A3	        4
#define __JMP_BUF_SP		5
#define __JMP_BUF_R4	        6
#define __JMP_BUF_R5	        7
#define __JMP_BUF_R6	        8
#define __JMP_BUF_R7	        9
#define __JMP_BUF_FS4	        10
#define __JMP_BUF_FS5	        11
#define __JMP_BUF_FS6	        12
#define __JMP_BUF_FS7	        13
#define __JMP_BUF_FS8	        14
#define __JMP_BUF_FS9	        15
#define __JMP_BUF_FS10	        16
#define __JMP_BUF_FS11	        17
#define __JMP_BUF_FS12	        18
#define __JMP_BUF_FS13	        19
#define __JMP_BUF_FS14	        20
#define __JMP_BUF_FS15	        21
#define __JMP_BUF_FS16	        22
#define __JMP_BUF_FS17	        23
#define __JMP_BUF_FS18	        24
#define __JMP_BUF_FS19	        25

/* Test if longjmp to JMPBUF would unwind the frame
   containing a local variable at ADDRESS.  */
#define _JMPBUF_UNWINDS(jmpbuf, address) \
  ((void *) (address) < (void *) (jmpbuf[__JMP_BUF_SP]))

#endif
