/* bug.h: description
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_BUG_H
#define _ASM_BUG_H


/*
 * Tell the user there is some problem.
 */

extern void __do_bug(void);

#define BUG()							\
do {								\
	printk("kernel BUG at %s:%d (caller %p)!\n",		\
	      __FILE__, __LINE__, __builtin_return_address(0));	\
	__do_bug();						\
} while (0)

#define HAVE_ARCH_BUG
#include <asm/generic/bug.h>

#endif /* _ASM_BUG_H */
