/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.pakkage;

import com.metamatrix.metamodels.diagram.DiagramLinkType;
import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.ScaledFontManager;
import com.metamatrix.modeler.diagram.ui.connection.BronxConnectionRouter;
import com.metamatrix.modeler.diagram.ui.connection.NodeConnectionModel;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorUtil;
import com.metamatrix.modeler.diagram.ui.layout.LayoutHelper;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.pakkage.PackageDiagramNode;
import com.metamatrix.modeler.diagram.ui.part.AbstractDefaultEditPart;
import com.metamatrix.modeler.diagram.ui.part.AbstractDiagramEditPart;
import com.metamatrix.modeler.diagram.ui.part.DiagramEditPart;
import com.metamatrix.modeler.diagram.ui.part.LabelEditPart;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.diagram.ui.util.DiagramXYLayoutEditPolicy;
import com.metamatrix.modeler.diagram.ui.util.LassoDragTracker;
import com.metamatrix.modeler.ui.IDiagramTypeEditPart;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class PackageDiagramEditPart
extends AbstractDiagramEditPart
implements DiagramUiConstants,
IDiagramTypeEditPart {
    private int routerStyle = DiagramEditorUtil.getCurrentDiagramRouterStyle();
    static DragTracker m_dragTracker = null;

    protected IFigure createFigure() {
        Figure newFigure = this.getFigureFactory().createFigure(this.getModel(), "umlDiagramNotation");
        this.setCurrentDiagramFont(ScaledFontManager.getFont());
        return newFigure;
    }

    protected void createEditPolicies() {
        this.setSelectablePart(false);
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramXYLayoutEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        if (m_dragTracker == null) {
            m_dragTracker = new LassoDragTracker();
        }
        return m_dragTracker;
    }

    public void layout(boolean layoutChildren) {
        if (!this.hasChildren()) {
            return;
        }
        if (layoutChildren) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(layoutChildren);
            }
        }
        if (!((DiagramModelNode)this.getModel()).wasLayedOut()) {
            this.layout();
        } else {
            ((DiagramModelNode)this.getModel()).recoverObjectProperties();
        }
        ArrayList arylSourceConnections = new ArrayList();
        if (!arylSourceConnections.isEmpty()) {
            Iterator itSourceConns = arylSourceConnections.iterator();
            while (itSourceConns.hasNext()) {
                NodeConnectionModel ncmSourceConn = (NodeConnectionModel)itSourceConns.next();
                ncmSourceConn.setRouterStyle(DiagramUiConstants.LinkRouter.types[this.routerStyle]);
                ncmSourceConn.layout();
            }
        }
        if (layoutChildren) {
            this.refreshAssociationLabels();
        }
    }

    private boolean hasChildren() {
        return this.getViewer().getContents().getChildren().size() > 0;
    }

    private void refreshAssociationLabels() {
        EditPart canvasEditPart = this.getViewer().getContents();
        List canvasChildren = canvasEditPart.getChildren();
        Iterator iter = canvasChildren.iterator();
        EditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (EditPart)iter.next();
            if (!(nextEditPart instanceof AbstractDefaultEditPart)) continue;
            ((AbstractDefaultEditPart)nextEditPart).refreshAllLabels();
        }
    }

    public void layout() {
        EditPart sep;
        Object selectedPart;
        if (!this.hasChildren()) {
            return;
        }
        DiagramModelNode selectedModelNode = null;
        if (this.getViewer().getSelectedEditParts().size() == 1 && (selectedPart = this.getViewer().getSelectedEditParts().get(0)) != null && selectedPart instanceof DiagramEditPart && !selectedPart.equals((Object)this) && (sep = (EditPart)selectedPart).getParent() == this) {
            selectedModelNode = (DiagramModelNode)((DiagramEditPart)selectedPart).getModel();
        }
        LayoutHelper layoutHelper = new LayoutHelper((DiagramModelNode)this.getModel(), selectedModelNode);
        layoutHelper.layoutAll();
        this.createOrUpdateAnchorsLocations(true);
        this.refreshAllLabels();
        this.refreshVisuals();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("children")) {
            this.refreshChildren();
            this.layoutChildren();
        } else if (prop.equals("size")) {
            this.createOrUpdateAnchorsLocations(true);
            this.refreshAllLabels();
            this.refreshVisuals();
        } else if (prop.equals("location")) {
            if (DiagramUiConstants.Util.isTraceEnabled(((Object)((Object)this)).getClass())) {
                String debugMessage = "Location Property Change on EP = " + ((DiagramModelNode)this.getModel()).getName() + " Position = " + ((DiagramModelNode)this.getModel()).getPosition();
                DiagramUiConstants.Util.print(((Object)((Object)this)).getClass(), debugMessage);
            }
            this.createOrUpdateAnchorsLocations(true);
            this.refreshAllLabels();
            this.refreshVisuals();
        } else if (prop.equals("prop")) {
            this.refreshVisuals();
        } else if (prop.equals("name")) {
            this.refreshName();
            this.refreshAllLabels();
            this.refreshVisuals();
        } else if (prop.equals("router")) {
            this.notifyRouterChanged((String)evt.getOldValue(), (String)evt.getNewValue());
        }
    }

    private void layoutChildren() {
        Iterator iter = this.getChildren().iterator();
        EditPart nextEP = null;
        while (iter.hasNext()) {
            nextEP = (EditPart)iter.next();
            if (!(nextEP instanceof DiagramEditPart)) continue;
            ((DiagramEditPart)nextEP).layout(true);
        }
    }

    public void createOrUpdateAnchorsLocations(boolean updateOtherEnds) {
        Iterator iter = this.getChildren().iterator();
        EditPart nextEP = null;
        while (iter.hasNext()) {
            nextEP = (EditPart)iter.next();
            if (!(nextEP instanceof DiagramEditPart) || nextEP instanceof LabelEditPart) continue;
            ((DiagramEditPart)nextEP).createOrUpdateAnchorsLocations(updateOtherEnds);
            ((AbstractDefaultEditPart)nextEP).refreshAllLabels();
        }
    }

    protected void refreshVisuals() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        switch (this.routerStyle) {
            case 0: {
                cLayer.setConnectionRouter((ConnectionRouter)new BronxConnectionRouter(30));
                break;
            }
            case 2: {
                FanRouter router = new FanRouter();
                router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
                cLayer.setConnectionRouter((ConnectionRouter)router);
                break;
            }
            default: {
                cLayer.setConnectionRouter((ConnectionRouter)new FanRouter());
            }
        }
    }

    public void refreshFont(boolean refreshChildren) {
        super.refreshFont(refreshChildren);
        if (this.hasChildren()) {
            EditPart canvasEditPart = this.getViewer().getContents();
            List canvasChildren = canvasEditPart.getChildren();
            Iterator iter = canvasChildren.iterator();
            EditPart nextEditPart = null;
            while (iter.hasNext()) {
                nextEditPart = (EditPart)iter.next();
                if (!(nextEditPart instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEditPart).layout(true);
            }
            if (this.hasConnections()) {
                this.refreshAssociationLabels();
            }
        }
    }

    public boolean hasConnections() {
        EditPart canvasEditPart = this.getViewer().getContents();
        Iterator iter = canvasEditPart.getChildren().iterator();
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextEditPart = (DiagramEditPart)iter.next();
            if (nextEditPart.getSourceConnections().isEmpty() && nextEditPart.getTargetConnections().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void updateForPreferences() {
        RGB currentBkgdColor = PreferenceConverter.getColor((IPreferenceStore)DiagramUiPlugin.getDefault().getPreferenceStore(), (String)"modeler.preference.diagram.package.backgroundcolor");
        this.getFigure().setBackgroundColor(new Color(null, currentBkgdColor));
        ((PackageDiagramNode)this.getModel()).refreshAssociationLabels();
        this.refreshFont(true);
    }

    private void notifyRouterChanged(String oldValue, String newValue) {
        int newType = 0;
        if (newValue != null) {
            newType = DiagramLinkType.get((String)newValue).getValue();
        }
        this.routerStyle = newType;
        this.refreshVisuals();
        List allSourceConnections = DiagramUiUtilities.getAllSourceConnections((DiagramModelNode)((DiagramModelNode)this.getModel()));
        if (allSourceConnections != null && !allSourceConnections.isEmpty()) {
            Iterator iter = allSourceConnections.iterator();
            Object nextObj = null;
            String routerType = DiagramUiConstants.LinkRouter.types[this.routerStyle];
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof NodeConnectionModel)) continue;
                ((NodeConnectionModel)nextObj).setRouterStyle(routerType);
                ((NodeConnectionModel)nextObj).firePropertyChange("router", (Object)oldValue, (Object)newValue);
            }
        }
    }
}

